/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bean;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.MBeanNames;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.apache.servicemix.bean.BeanComponent;
import org.apache.servicemix.bean.Callback;
import org.apache.servicemix.bean.Correlation;
import org.apache.servicemix.bean.ExchangeTarget;
import org.apache.servicemix.bean.MethodInvocationFailedException;
import org.apache.servicemix.bean.NoSuchBeanException;
import org.apache.servicemix.bean.UnknownMessageExchangeTypeException;
import org.apache.servicemix.bean.support.BeanInfo;
import org.apache.servicemix.bean.support.DefaultMethodInvocationStrategy;
import org.apache.servicemix.bean.support.DestinationImpl;
import org.apache.servicemix.bean.support.Holder;
import org.apache.servicemix.bean.support.MethodInvocationStrategy;
import org.apache.servicemix.bean.support.ReflectionUtils;
import org.apache.servicemix.bean.support.Request;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.common.util.MessageUtil;
import org.apache.servicemix.common.util.URIResolver;
import org.apache.servicemix.expression.Expression;
import org.apache.servicemix.expression.JAXPStringXPathExpression;
import org.apache.servicemix.expression.PropertyExpression;
import org.apache.servicemix.jbi.listener.MessageExchangeListener;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ReflectionUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanEndpoint
extends ProviderEndpoint
implements ApplicationContextAware {
    public static final String CORRELATION_ID = BeanEndpoint.class.getName().replaceAll("\\.", "_") + "_correlation";
    private ApplicationContext applicationContext;
    private String beanName;
    private Object bean;
    private BeanInfo beanInfo;
    private Class<?> beanType;
    private String beanClassName;
    private MethodInvocationStrategy methodInvocationStrategy;
    private Expression correlationExpression;
    private Map<String, Holder> exchanges = new ConcurrentHashMap<String, Holder>();
    private Map<Object, Request> requests = new ConcurrentHashMap<Object, Request>();
    private ThreadLocal<Request> currentRequest = new ThreadLocal();
    private ServiceEndpoint serviceEndpoint;

    public BeanEndpoint() {
    }

    public BeanEndpoint(BeanComponent component, ServiceEndpoint serviceEndpoint) {
        super((DefaultComponent)component, serviceEndpoint);
        this.applicationContext = component.getApplicationContext();
        this.serviceEndpoint = serviceEndpoint;
    }

    public void start() throws Exception {
        Object pojo;
        super.start();
        if (this.serviceEndpoint == null) {
            this.serviceEndpoint = this.getContext().getEndpoint(this.getService(), this.getEndpoint());
        }
        if ((pojo = this.getBean()) != null) {
            this.beanType = pojo.getClass();
            this.injectBean(pojo);
            ReflectionUtils.callLifecycleMethod(pojo, PostConstruct.class);
        } else {
            this.beanType = this.createBean().getClass();
        }
        if (this.getMethodInvocationStrategy() == null) {
            throw new IllegalArgumentException("No 'methodInvocationStrategy' property set");
        }
    }

    public void stop() throws Exception {
        super.stop();
        Object pojo = this.getBean();
        if (pojo != null) {
            ReflectionUtils.callLifecycleMethod(pojo, PreDestroy.class);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public void setBeanType(Class<?> beanType) {
        this.beanType = beanType;
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }

    public void setBeanClassName(String beanClassName) {
        this.beanClassName = beanClassName;
    }

    public BeanInfo getBeanInfo() {
        if (this.beanInfo == null) {
            this.beanInfo = new BeanInfo(this.beanType, this.getMethodInvocationStrategy());
            this.beanInfo.introspect();
        }
        return this.beanInfo;
    }

    public void setBeanInfo(BeanInfo beanInfo) {
        this.beanInfo = beanInfo;
    }

    public MethodInvocationStrategy getMethodInvocationStrategy() {
        if (this.methodInvocationStrategy == null) {
            this.methodInvocationStrategy = this.createMethodInvocationStrategy();
        }
        return this.methodInvocationStrategy;
    }

    public void setMethodInvocationStrategy(MethodInvocationStrategy methodInvocationStrategy) {
        this.methodInvocationStrategy = methodInvocationStrategy;
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getRole() == MessageExchange.Role.CONSUMER) {
            this.onConsumerExchange(exchange);
        } else {
            this.onProviderExchange(exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void onProviderExchange(MessageExchange exchange) throws Exception {
        Request req;
        block18: {
            req = this.getOrCreateCurrentRequest(exchange);
            this.currentRequest.set(req);
            Request request = req;
            // MONITORENTER : request
            if (req.getBean() instanceof MessageExchangeListener) {
                ((MessageExchangeListener)req.getBean()).onMessageExchange(exchange);
                return;
            }
            if (exchange.getStatus() != ExchangeStatus.DONE) break block18;
            // MONITOREXIT : request
            this.checkEndOfRequest(req);
            this.currentRequest.set(null);
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            // MONITOREXIT : request
            this.checkEndOfRequest(req);
            this.currentRequest.set(null);
            return;
        }
        try {
            if (exchange.getFault() != null) {
                this.done(exchange);
                return;
            }
            MethodInvocation invocation = this.getMethodInvocationStrategy().createInvocation(req.getBean(), this.getBeanInfo(), exchange, this);
            if (invocation == null) {
                throw new UnknownMessageExchangeTypeException(exchange, this);
            }
            try {
                invocation.proceed();
            }
            catch (InvocationTargetException e) {
                throw new MethodInvocationFailedException(req.getBean(), invocation, exchange, this, e.getCause());
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new MethodInvocationFailedException(req.getBean(), invocation, exchange, this, throwable);
            }
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                this.send(exchange);
            }
            if (exchange.getFault() == null && exchange.getMessage("out") == null) {
                this.done(exchange);
            }
            // MONITOREXIT : request
            return;
        }
        finally {
            this.checkEndOfRequest(req);
            this.currentRequest.set(null);
        }
    }

    protected boolean onProviderExchangeDone(MessageExchange exchange) {
        return exchange instanceof InOnly || exchange instanceof RobustInOnly && exchange.getFault() == null || exchange instanceof InOptionalOut && exchange.getFault() == null && exchange.getMessage("out") == null;
    }

    protected Request getOrCreateCurrentRequest(MessageExchange exchange) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException {
        if (this.currentRequest.get() != null) {
            return this.currentRequest.get();
        }
        Request req = this.getRequest(exchange);
        if (req == null) {
            Object pojo = this.getBean();
            if (pojo == null) {
                pojo = this.createBean();
                this.injectBean(pojo);
                ReflectionUtils.callLifecycleMethod(pojo, PostConstruct.class);
            }
            req = new Request(this.getCorrelation(exchange), pojo, exchange);
            this.requests.put(req.getCorrelationId(), req);
        }
        return req;
    }

    protected Request getRequest(MessageExchange exchange) throws MessagingException {
        Object correlation = this.getCorrelation(exchange);
        return correlation == null ? null : this.requests.get(correlation);
    }

    protected void onConsumerExchange(MessageExchange exchange) throws Exception {
        Request req = this.getOrCreateCurrentRequest(exchange);
        if (req == null) {
            throw new IllegalStateException("Receiving unknown consumer exchange: " + exchange);
        }
        this.currentRequest.set(req);
        if (this.exchanges.containsKey(exchange.getExchangeId())) {
            this.exchanges.remove(exchange.getExchangeId()).set(exchange);
            this.evaluateCallbacks(req);
            if (exchange instanceof InOut && ExchangeStatus.ACTIVE.equals(exchange.getStatus())) {
                this.done(exchange);
            }
        } else if (req.getBean() instanceof MessageExchangeListener) {
            ((MessageExchangeListener)req.getBean()).onMessageExchange(exchange);
        } else {
            throw new IllegalStateException("No known consumer exchange found and bean does not implement MessageExchangeListener");
        }
        this.checkEndOfRequest(req);
        this.currentRequest.set(null);
    }

    protected Object getCorrelation(MessageExchange exchange) throws MessagingException {
        return this.getCorrelationExpression().evaluate(exchange, exchange.getMessage("in"));
    }

    protected Object createBean() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.beanType == null && this.beanClassName != null) {
            this.beanType = Class.forName(this.beanClassName, true, this.getServiceUnit().getConfigurationClassLoader());
        }
        if (this.beanName == null && this.beanType == null) {
            throw new IllegalArgumentException("Property 'bean', 'beanName' or 'beanClassName' has not been set!");
        }
        if (this.beanName != null && this.applicationContext == null) {
            throw new IllegalArgumentException("Property 'beanName' specified, but no BeanFactory set!");
        }
        if (this.beanType != null) {
            return this.beanType.newInstance();
        }
        Object answer = this.applicationContext.getBean(this.beanName);
        if (answer == null) {
            throw new NoSuchBeanException(this.beanName, this);
        }
        return answer;
    }

    protected MethodInvocationStrategy createMethodInvocationStrategy() {
        DefaultMethodInvocationStrategy st = new DefaultMethodInvocationStrategy();
        st.loadDefaultRegistry();
        return st;
    }

    protected void injectBean(final Object target) {
        final PojoContext ctx = new PojoContext();
        final DeliveryChannel ch = ctx.channel;
        ReflectionUtils.doWithFields(target.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field f) throws IllegalArgumentException, IllegalAccessException {
                ExchangeTarget et = f.getAnnotation(ExchangeTarget.class);
                if (et != null) {
                    ReflectionUtils.setField(f, target, new DestinationImpl(et.uri(), BeanEndpoint.this));
                }
                if (f.getAnnotation(Resource.class) != null) {
                    if (ComponentContext.class.isAssignableFrom(f.getType())) {
                        ReflectionUtils.setField(f, target, ctx);
                    } else if (DeliveryChannel.class.isAssignableFrom(f.getType())) {
                        ReflectionUtils.setField(f, target, ch);
                    } else if (ServiceEndpoint.class.isAssignableFrom(f.getType())) {
                        ReflectionUtils.setField(f, target, BeanEndpoint.this.serviceEndpoint);
                    }
                }
            }
        });
    }

    protected void evaluateCallbacks(final Request req) {
        final Object obj = req.getBean();
        ReflectionUtils.doWithMethods(obj.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                if (method.getAnnotation(Callback.class) != null) {
                    try {
                        JexlEngine jexl = new JexlEngine();
                        org.apache.commons.jexl2.Expression e = jexl.createExpression(method.getAnnotation(Callback.class).condition());
                        MapContext jc = new MapContext();
                        jc.set("this", obj);
                        Object r = e.evaluate((JexlContext)jc);
                        if (!(r instanceof Boolean)) {
                            throw new RuntimeException("Expression did not returned a boolean value but: " + r);
                        }
                        Boolean oldVal = req.getCallbacks().get(method);
                        Boolean newVal = (Boolean)r;
                        if ((oldVal == null || !oldVal.booleanValue()) && newVal.booleanValue()) {
                            req.getCallbacks().put(method, newVal);
                            method.invoke(obj, new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to invoke callback", e);
                    }
                }
            }
        });
    }

    public Future<NormalizedMessage> send(String uri, NormalizedMessage message) {
        try {
            InOut me = this.getExchangeFactory().createInOutExchange();
            URIResolver.configureExchange((MessageExchange)me, (ComponentContext)this.getServiceUnit().getComponent().getComponentContext(), (String)uri);
            MessageUtil.transferTo((NormalizedMessage)message, (MessageExchange)me, (String)"in");
            Holder h = new Holder();
            this.getOrCreateCurrentRequest((MessageExchange)me).addExchange((MessageExchange)me);
            this.exchanges.put(me.getExchangeId(), h);
            this.send((MessageExchange)me);
            return h;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void send(MessageExchange me) throws MessagingException {
        this.checkEndOfRequest(me);
        super.send(me);
    }

    private void checkEndOfRequest(MessageExchange me) throws MessagingException {
        Request request;
        if (!ExchangeStatus.ACTIVE.equals(me.getStatus()) && (request = this.getRequest(me)) != null) {
            this.checkEndOfRequest(request);
        }
    }

    protected void checkEndOfRequest(Request req) {
        if (req.isFinished()) {
            this.requests.remove(req.getCorrelationId());
            if (req.getBean() != this.bean) {
                ReflectionUtils.callLifecycleMethod(req.getBean(), PreDestroy.class);
            }
        }
    }

    public Expression getCorrelationExpression() {
        if (this.correlationExpression == null) {
            Correlation cor = this.beanType.getAnnotation(Correlation.class);
            if (cor != null) {
                if (cor.property() != null) {
                    this.correlationExpression = new PropertyExpression(cor.property());
                } else if (cor.xpath() != null) {
                    this.correlationExpression = new JAXPStringXPathExpression(cor.xpath());
                }
            }
            if (this.correlationExpression == null) {
                this.correlationExpression = new Expression(){

                    public Object evaluate(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
                        if (exchange.getProperty(CORRELATION_ID) != null) {
                            return exchange.getProperty(CORRELATION_ID);
                        }
                        return exchange.getExchangeId();
                    }
                };
            }
        }
        return this.correlationExpression;
    }

    public void setCorrelationExpression(Expression correlationExpression) {
        this.correlationExpression = correlationExpression;
    }

    protected class PojoChannel
    implements DeliveryChannel {
        protected PojoChannel() {
        }

        public void close() throws MessagingException {
        }

        public MessageExchangeFactory createExchangeFactory() {
            return BeanEndpoint.this.getChannel().createExchangeFactory();
        }

        public MessageExchangeFactory createExchangeFactory(QName qName) {
            return BeanEndpoint.this.getChannel().createExchangeFactory(qName);
        }

        public MessageExchangeFactory createExchangeFactoryForService(QName qName) {
            return BeanEndpoint.this.getChannel().createExchangeFactoryForService(qName);
        }

        public MessageExchangeFactory createExchangeFactory(ServiceEndpoint serviceEndpoint) {
            return BeanEndpoint.this.getChannel().createExchangeFactory(serviceEndpoint);
        }

        public MessageExchange accept() throws MessagingException {
            return BeanEndpoint.this.getChannel().accept();
        }

        public MessageExchange accept(long l) throws MessagingException {
            return BeanEndpoint.this.getChannel().accept(l);
        }

        public void send(MessageExchange messageExchange) throws MessagingException {
            try {
                Request req = BeanEndpoint.this.getOrCreateCurrentRequest(messageExchange);
                if (messageExchange.getRole() == MessageExchange.Role.CONSUMER && messageExchange.getStatus() == ExchangeStatus.ACTIVE) {
                    if (!(req.getBean() instanceof MessageExchangeListener)) {
                        throw new IllegalStateException("A bean acting as a consumer and using the channel to send exchanges must implement the MessageExchangeListener interface");
                    }
                    req.addExchange(messageExchange);
                }
                if (messageExchange.getStatus() != ExchangeStatus.ACTIVE) {
                    BeanEndpoint.this.checkEndOfRequest(req);
                }
                BeanEndpoint.this.getChannel().send(messageExchange);
            }
            catch (MessagingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessagingException((Throwable)e);
            }
        }

        public boolean sendSync(MessageExchange messageExchange) throws MessagingException {
            BeanEndpoint.this.checkEndOfRequest(messageExchange);
            return BeanEndpoint.this.getChannel().sendSync(messageExchange);
        }

        public boolean sendSync(MessageExchange messageExchange, long l) throws MessagingException {
            BeanEndpoint.this.checkEndOfRequest(messageExchange);
            return BeanEndpoint.this.getChannel().sendSync(messageExchange, l);
        }
    }

    protected class PojoContext
    implements ComponentContext {
        private DeliveryChannel channel;

        protected PojoContext() {
            this.channel = new PojoChannel();
        }

        public ServiceEndpoint activateEndpoint(QName qName, String s) throws JBIException {
            return BeanEndpoint.this.getContext().activateEndpoint(qName, s);
        }

        public void deactivateEndpoint(ServiceEndpoint serviceEndpoint) throws JBIException {
            BeanEndpoint.this.getContext().deactivateEndpoint(serviceEndpoint);
        }

        public void registerExternalEndpoint(ServiceEndpoint serviceEndpoint) throws JBIException {
            BeanEndpoint.this.getContext().registerExternalEndpoint(serviceEndpoint);
        }

        public void deregisterExternalEndpoint(ServiceEndpoint serviceEndpoint) throws JBIException {
            BeanEndpoint.this.getContext().deregisterExternalEndpoint(serviceEndpoint);
        }

        public ServiceEndpoint resolveEndpointReference(DocumentFragment documentFragment) {
            return BeanEndpoint.this.getContext().resolveEndpointReference(documentFragment);
        }

        public String getComponentName() {
            return BeanEndpoint.this.getContext().getComponentName();
        }

        public DeliveryChannel getDeliveryChannel() throws MessagingException {
            return this.channel;
        }

        public ServiceEndpoint getEndpoint(QName qName, String s) {
            return BeanEndpoint.this.getContext().getEndpoint(qName, s);
        }

        public Document getEndpointDescriptor(ServiceEndpoint serviceEndpoint) throws JBIException {
            return BeanEndpoint.this.getContext().getEndpointDescriptor(serviceEndpoint);
        }

        public ServiceEndpoint[] getEndpoints(QName qName) {
            return BeanEndpoint.this.getContext().getEndpoints(qName);
        }

        public ServiceEndpoint[] getEndpointsForService(QName qName) {
            return BeanEndpoint.this.getContext().getEndpointsForService(qName);
        }

        public ServiceEndpoint[] getExternalEndpoints(QName qName) {
            return BeanEndpoint.this.getContext().getExternalEndpoints(qName);
        }

        public ServiceEndpoint[] getExternalEndpointsForService(QName qName) {
            return BeanEndpoint.this.getContext().getExternalEndpointsForService(qName);
        }

        public String getInstallRoot() {
            return BeanEndpoint.this.getContext().getInstallRoot();
        }

        public Logger getLogger(String s, String s1) throws MissingResourceException, JBIException {
            return BeanEndpoint.this.getContext().getLogger(s, s1);
        }

        public MBeanNames getMBeanNames() {
            return BeanEndpoint.this.getContext().getMBeanNames();
        }

        public MBeanServer getMBeanServer() {
            return BeanEndpoint.this.getContext().getMBeanServer();
        }

        public InitialContext getNamingContext() {
            return BeanEndpoint.this.getContext().getNamingContext();
        }

        public Object getTransactionManager() {
            return BeanEndpoint.this.getContext().getTransactionManager();
        }

        public String getWorkspaceRoot() {
            return BeanEndpoint.this.getContext().getWorkspaceRoot();
        }
    }
}

