/*
 * Decompiled with CFR 0.152.
 */
package org.jencks.pool;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.jencks.pool.PooledProducer;
import org.jencks.pool.PooledQueueSender;
import org.jencks.pool.PooledTopicPublisher;

public class PooledSpringXASession
implements TopicSession,
QueueSession,
XASession {
    private static final Log log = LogFactory.getLog(PooledSpringXASession.class);
    private XASession session;
    private ObjectPool sessionPool;
    private MessageProducer messageProducer;
    private QueueSender queueSender;
    private TopicPublisher topicPublisher;
    private boolean ignoreClose;

    public PooledSpringXASession(XASession session, ObjectPool sessionPool) {
        this.session = session;
        this.sessionPool = sessionPool;
        this.ignoreClose = false;
    }

    public boolean getIgnoreClose() {
        return this.ignoreClose;
    }

    public void setIgnoreClose(boolean ignoreClose) {
        this.ignoreClose = ignoreClose;
    }

    public void destroyAndRemoveFromPool() {
        try {
            this.sessionPool.invalidateObject((Object)this);
        }
        catch (Throwable t) {
            log.warn((Object)"Unable to remove invalidated JMS Session from the pool due to the following exception.  Will ignore the exception and continue.", t);
        }
    }

    public void close() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"---->>>>> PooledSpringXASession.close() called");
        }
        if (!this.getIgnoreClose()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"---->>>>> ignoreClose = false, so returning session pool...");
            }
            this.getActualSession().setMessageListener(null);
            try {
                this.sessionPool.returnObject((Object)this);
            }
            catch (Exception e) {
                JMSException jmsException = new JMSException("Failed to return session to pool: " + e);
                jmsException.initCause((Throwable)e);
                throw jmsException;
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"---->>>>> ignoreClose IS TRUE!  KEEPING SESSION OPEN!");
        }
    }

    public void commit() throws JMSException {
        throw new JMSException("Cannot commit() inside XASession");
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.getActualSession().createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.getActualSession().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.getActualSession().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getActualSession().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.getActualSession().createObjectMessage(serializable);
    }

    public Queue createQueue(String s) throws JMSException {
        return this.getActualSession().createQueue(s);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.getActualSession().createStreamMessage();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.getActualSession().createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.getActualSession().createTemporaryTopic();
    }

    public void unsubscribe(String s) throws JMSException {
        this.getActualSession().unsubscribe(s);
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.getActualSession().createTextMessage();
    }

    public TextMessage createTextMessage(String s) throws JMSException {
        return this.getActualSession().createTextMessage(s);
    }

    public Topic createTopic(String s) throws JMSException {
        return this.getActualSession().createTopic(s);
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.getActualSession().getAcknowledgeMode();
    }

    public boolean getTransacted() throws JMSException {
        return true;
    }

    public void recover() throws JMSException {
        this.getActualSession().recover();
    }

    public void rollback() throws JMSException {
        throw new JMSException("Cannot rollback() inside XASession");
    }

    public void run() {
        if (this.session != null) {
            this.session.run();
        }
    }

    public XAResource getXAResource() {
        try {
            return this.getActualSession().getXAResource();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Session getSession() throws JMSException {
        return this;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.getActualSession().createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String selector) throws JMSException {
        return this.getActualSession().createBrowser(queue, selector);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.getActualSession().createConsumer(destination);
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        return this.getActualSession().createConsumer(destination, selector);
    }

    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        return this.getActualSession().createConsumer(destination, selector, noLocal);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String selector) throws JMSException {
        return this.getActualSession().createDurableSubscriber(topic, selector);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        return this.getActualSession().createDurableSubscriber(topic, name, selector, noLocal);
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.getActualSession().getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.getActualSession().setMessageListener(messageListener);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return ((TopicSession)this.getActualSession()).createSubscriber(topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String selector, boolean local) throws JMSException {
        return ((TopicSession)this.getActualSession()).createSubscriber(topic, selector, local);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return ((QueueSession)this.getActualSession()).createReceiver(queue);
    }

    public QueueReceiver createReceiver(Queue queue, String selector) throws JMSException {
        return ((QueueSession)this.getActualSession()).createReceiver(queue, selector);
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return new PooledProducer(this.getMessageProducer(), destination);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return new PooledQueueSender(this.getQueueSender(), (Destination)queue);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return new PooledTopicPublisher(this.getTopicPublisher(), (Destination)topic);
    }

    public XASession getActualSession() throws JMSException {
        if (this.session == null) {
            throw new JMSException("The session has already been closed");
        }
        return this.session;
    }

    public MessageProducer getMessageProducer() throws JMSException {
        if (this.messageProducer == null) {
            this.messageProducer = this.getActualSession().createProducer(null);
        }
        return this.messageProducer;
    }

    public QueueSender getQueueSender() throws JMSException {
        if (this.queueSender == null) {
            this.queueSender = ((QueueSession)this.getActualSession()).createSender(null);
        }
        return this.queueSender;
    }

    public TopicPublisher getTopicPublisher() throws JMSException {
        if (this.topicPublisher == null) {
            this.topicPublisher = ((TopicSession)this.getActualSession()).createPublisher(null);
        }
        return this.topicPublisher;
    }
}

