/*
 * Decompiled with CFR 0.152.
 */
package org.jencks;

import javax.jms.MessageListener;
import javax.resource.spi.UnavailableException;
import javax.transaction.TransactionManager;
import org.jencks.EndpointFactorySupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;

public class DefaultEndpointFactory
extends EndpointFactorySupport
implements InitializingBean,
BeanFactoryAware {
    private BeanFactory beanFactory;
    private String ref;

    public DefaultEndpointFactory() {
    }

    public DefaultEndpointFactory(BeanFactory beanFactory, String ref) {
        this.beanFactory = beanFactory;
        this.ref = ref;
    }

    public DefaultEndpointFactory(BeanFactory beanFactory, String ref, TransactionManager transactionManager, String name) {
        this.beanFactory = beanFactory;
        this.ref = ref;
        this.transactionManager = transactionManager;
        this.setName(name);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.ref == null) {
            throw new IllegalArgumentException("ref property must be set");
        }
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected MessageListener createMessageListener() throws UnavailableException {
        MessageListener messageListener = (MessageListener)this.beanFactory.getBean(this.ref, MessageListener.class);
        if (messageListener == null) {
            throw new UnavailableException("No MessageListener bean available for reference name: " + this.ref);
        }
        return messageListener;
    }
}

