/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.manager.LogException;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.Recovery;
import org.apache.geronimo.transaction.manager.TransactionBranchInfo;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryImpl
implements Recovery {
    private static final Logger log = LoggerFactory.getLogger((String)"Recovery");
    private final TransactionLog txLog;
    private final XidFactory xidFactory;
    private final Map externalXids = new HashMap();
    private final Map ourXids = new HashMap();
    private final Map nameToOurTxMap = new HashMap();
    private final Map externalGlobalIdMap = new HashMap();
    private final List recoveryErrors = new ArrayList();

    public RecoveryImpl(TransactionLog txLog, XidFactory xidFactory) {
        this.txLog = txLog;
        this.xidFactory = xidFactory;
    }

    public synchronized void recoverLog() throws XAException {
        Collection preparedXids = null;
        try {
            preparedXids = this.txLog.recover(this.xidFactory);
        }
        catch (LogException e) {
            throw (XAException)new XAException(-3).initCause(e);
        }
        for (Recovery.XidBranchesPair xidBranchesPair : preparedXids) {
            Xid xid = xidBranchesPair.getXid();
            if (this.xidFactory.matchesGlobalId(xid.getGlobalTransactionId())) {
                this.ourXids.put(new ByteArrayWrapper(xid.getGlobalTransactionId()), xidBranchesPair);
                Iterator branches = xidBranchesPair.getBranches().iterator();
                while (branches.hasNext()) {
                    String name = ((TransactionBranchInfo)branches.next()).getResourceName();
                    HashSet<Recovery.XidBranchesPair> transactionsForName = (HashSet<Recovery.XidBranchesPair>)this.nameToOurTxMap.get(name);
                    if (transactionsForName == null) {
                        transactionsForName = new HashSet<Recovery.XidBranchesPair>();
                        this.nameToOurTxMap.put(name, transactionsForName);
                    }
                    transactionsForName.add(xidBranchesPair);
                }
                continue;
            }
            ExternalTransaction externalTx = new ExternalTransaction(xid, this.txLog, xidBranchesPair.getBranches());
            this.externalXids.put(xid, externalTx);
            this.externalGlobalIdMap.put(xid.getGlobalTransactionId(), externalTx);
        }
    }

    public synchronized void recoverResourceManager(NamedXAResource xaResource) throws XAException {
        String name = xaResource.getName();
        Xid[] prepared = xaResource.recover(0x1800000);
        for (int i = 0; prepared != null && i < prepared.length; ++i) {
            Xid xid = prepared[i];
            ByteArrayWrapper globalIdWrapper = new ByteArrayWrapper(xid.getGlobalTransactionId());
            Recovery.XidBranchesPair xidNamesPair = (Recovery.XidBranchesPair)this.ourXids.get(globalIdWrapper);
            if (xidNamesPair != null) {
                if (!this.isNameInTransaction(xidNamesPair, name)) continue;
                try {
                    xaResource.commit(xid, false);
                }
                catch (XAException e) {
                    this.recoveryErrors.add(e);
                    log.error("Recovery error", (Throwable)e);
                }
                this.removeNameFromTransaction(xidNamesPair, name, true);
                continue;
            }
            if (this.xidFactory.matchesGlobalId(xid.getGlobalTransactionId())) {
                try {
                    xaResource.rollback(xid);
                }
                catch (XAException e) {
                    this.recoveryErrors.add(e);
                    log.error("Could not roll back", (Throwable)e);
                }
                continue;
            }
            if (!this.xidFactory.matchesBranchId(xid.getBranchQualifier())) continue;
            TransactionImpl externalTx = (TransactionImpl)this.externalGlobalIdMap.get(xid.getGlobalTransactionId());
            if (externalTx == null) {
                try {
                    xaResource.rollback(xid);
                }
                catch (XAException e) {
                    this.recoveryErrors.add(e);
                    log.error("Could not roll back", (Throwable)e);
                }
                continue;
            }
            externalTx.addBranchXid(xaResource, xid);
        }
        Set transactionsForName = (Set)this.nameToOurTxMap.get(name);
        if (transactionsForName != null) {
            for (Recovery.XidBranchesPair xidBranchesPair : transactionsForName) {
                this.removeNameFromTransaction(xidBranchesPair, name, false);
            }
        }
    }

    private boolean isNameInTransaction(Recovery.XidBranchesPair xidBranchesPair, String name) {
        for (TransactionBranchInfo transactionBranchInfo : xidBranchesPair.getBranches()) {
            if (!name.equals(transactionBranchInfo.getResourceName())) continue;
            return true;
        }
        return false;
    }

    private void removeNameFromTransaction(Recovery.XidBranchesPair xidBranchesPair, String name, boolean warn) {
        int removed = 0;
        Iterator branches = xidBranchesPair.getBranches().iterator();
        while (branches.hasNext()) {
            TransactionBranchInfo transactionBranchInfo = (TransactionBranchInfo)branches.next();
            if (!name.equals(transactionBranchInfo.getResourceName())) continue;
            branches.remove();
            ++removed;
        }
        if (warn && removed == 0) {
            log.error("XAResource named: " + name + " returned branch xid for xid: " + xidBranchesPair.getXid() + " but was not registered with that transaction!");
        }
        if (xidBranchesPair.getBranches().isEmpty() && 0 != removed) {
            try {
                this.ourXids.remove(new ByteArrayWrapper(xidBranchesPair.getXid().getGlobalTransactionId()));
                this.txLog.commit(xidBranchesPair.getXid(), xidBranchesPair.getMark());
            }
            catch (LogException e) {
                this.recoveryErrors.add(e);
                log.error("Could not commit", (Throwable)e);
            }
        }
    }

    public synchronized boolean hasRecoveryErrors() {
        return !this.recoveryErrors.isEmpty();
    }

    public synchronized List getRecoveryErrors() {
        return Collections.unmodifiableList(this.recoveryErrors);
    }

    public synchronized boolean localRecoveryComplete() {
        return this.ourXids.isEmpty();
    }

    public synchronized int localUnrecoveredCount() {
        return this.ourXids.size();
    }

    public synchronized Map getExternalXids() {
        return new HashMap(this.externalXids);
    }

    private static class ExternalTransaction
    extends TransactionImpl {
        private Set resourceNames;

        public ExternalTransaction(Xid xid, TransactionLog txLog, Set resourceNames) {
            super(xid, txLog);
            this.resourceNames = resourceNames;
        }

        public boolean hasName(String name) {
            return this.resourceNames.contains(name);
        }

        public void removeName(String name) {
            this.resourceNames.remove(name);
        }

        public void preparedCommit() throws HeuristicRollbackException, HeuristicMixedException, SystemException {
            if (!this.resourceNames.isEmpty()) {
                throw new SystemException("This tx does not have all resource managers online, commit not allowed yet");
            }
            super.preparedCommit();
        }

        public void rollback() throws SystemException {
            if (!this.resourceNames.isEmpty()) {
                throw new SystemException("This tx does not have all resource managers online, rollback not allowed yet");
            }
            super.rollback();
        }
    }

    private static class ByteArrayWrapper {
        private final byte[] bytes;
        private final int hashCode;

        public ByteArrayWrapper(byte[] bytes) {
            assert (bytes != null);
            this.bytes = bytes;
            int hash = 0;
            for (int i = 0; i < bytes.length; ++i) {
                hash += 37 * bytes[i];
            }
            this.hashCode = hash;
        }

        public boolean equals(Object other) {
            if (other instanceof ByteArrayWrapper) {
                return Arrays.equals(this.bytes, ((ByteArrayWrapper)other).bytes);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

