/*
 * Decompiled with CFR 0.152.
 */
package org.jencks.factory;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import org.apache.geronimo.connector.GeronimoBootstrapContext;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.LocalTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.XATransactions;
import org.apache.geronimo.connector.work.GeronimoWorkManager;
import org.apache.geronimo.transaction.log.UnrecoverableLog;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.XAWork;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.apache.geronimo.transaction.manager.XidFactoryImpl;
import org.jencks.factory.HowlLogFactoryBean;
import org.springframework.beans.FatalBeanException;

public final class GeronimoDefaults {
    public static final int DEFAULT_THREAD_POOL_SIZE = 30;

    private GeronimoDefaults() {
    }

    public static XidFactory createXidFactory() {
        XidFactoryImpl xidFactory = new XidFactoryImpl();
        return xidFactory;
    }

    public static PoolingSupport createPoolingSupport() {
        return new NoPool();
    }

    public static TransactionSupport createTransactionSupport(String transaction) {
        if (transaction == null || "local".equalsIgnoreCase(transaction)) {
            return LocalTransactions.INSTANCE;
        }
        if ("none".equalsIgnoreCase(transaction)) {
            return NoTransactions.INSTANCE;
        }
        if ("xa".equalsIgnoreCase(transaction)) {
            return new XATransactions(true, false);
        }
        throw new FatalBeanException("Unknown transaction type " + transaction);
    }

    public static Executor createThreadPool() {
        return GeronimoDefaults.createThreadPool(30);
    }

    public static Executor createThreadPool(int threadPoolSize) {
        if (threadPoolSize <= 0) {
            threadPoolSize = 30;
        }
        ExecutorService pooledExecutor = Executors.newFixedThreadPool(threadPoolSize);
        return pooledExecutor;
    }

    public static WorkManager createWorkManager(GeronimoTransactionManager transactionManager, int threadPoolSize) {
        Executor threadPool = GeronimoDefaults.createThreadPool(threadPoolSize);
        GeronimoWorkManager geronimoWorkManager = new GeronimoWorkManager(threadPool, threadPool, threadPool, (XAWork)transactionManager);
        return geronimoWorkManager;
    }

    public static BootstrapContext createBootstrapContext(GeronimoTransactionManager transactionManager, int threadPoolSize) {
        WorkManager workManager = GeronimoDefaults.createWorkManager(transactionManager, threadPoolSize);
        return GeronimoDefaults.createBootstrapContext(transactionManager, workManager);
    }

    public static BootstrapContext createBootstrapContext(GeronimoTransactionManager transactionManager, WorkManager workManager) {
        GeronimoBootstrapContext bootstrapContext = new GeronimoBootstrapContext(workManager, (XATerminator)transactionManager);
        return bootstrapContext;
    }

    public static TransactionLog createTransactionLog(XidFactory xidFactory, String logDir) throws Exception {
        if (logDir == null) {
            return new UnrecoverableLog();
        }
        HowlLogFactoryBean howlLogFactoryBean = new HowlLogFactoryBean();
        howlLogFactoryBean.setXidFactory(xidFactory);
        howlLogFactoryBean.setLogFileDir(logDir);
        return (TransactionLog)howlLogFactoryBean.getObject();
    }
}

