/*
 * Decompiled with CFR 0.152.
 */
package org.jencks;

import javax.jms.Message;
import javax.jms.MessageListener;
import org.springframework.aop.TargetSource;
import org.springframework.beans.factory.InitializingBean;

public class TargetSourceMessageListener
implements MessageListener,
InitializingBean {
    private TargetSource targetSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        MessageListener delegate = null;
        try {
            delegate = (MessageListener)this.targetSource.getTarget();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        try {
            delegate.onMessage(message);
        }
        finally {
            try {
                this.targetSource.releaseTarget((Object)delegate);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.targetSource == null) {
            throw new IllegalArgumentException("targetSource must be set");
        }
    }

    public TargetSource getTargetSource() {
        return this.targetSource;
    }

    public void setTargetSource(TargetSource targetSource) {
        this.targetSource = targetSource;
    }

    protected void handleException(Exception e) {
        throw new RuntimeException(e);
    }
}

