/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bean.support;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.servicemix.expression.Expression;

public class MethodInfo {
    private Class type;
    private Method method;
    private Expression parametersExpression;

    public MethodInfo(Class type, Method method, Expression parametersExpression) {
        this.type = type;
        this.method = method;
        this.parametersExpression = parametersExpression;
    }

    public MethodInvocation createMethodInvocation(final Object pojo, final MessageExchange messageExchange) throws MessagingException {
        final Object[] arguments = (Object[])this.parametersExpression.evaluate(messageExchange, messageExchange.getMessage("in"));
        return new MethodInvocation(){

            public Method getMethod() {
                return MethodInfo.this.method;
            }

            public Object[] getArguments() {
                return arguments;
            }

            public Object proceed() throws Throwable {
                return MethodInfo.this.invoke(MethodInfo.this.method, pojo, arguments, messageExchange);
            }

            public Object getThis() {
                return pojo;
            }

            public AccessibleObject getStaticPart() {
                return MethodInfo.this.method;
            }
        };
    }

    public Class getType() {
        return this.type;
    }

    public Method getMethod() {
        return this.method;
    }

    public Expression getParametersExpression() {
        return this.parametersExpression;
    }

    protected Object invoke(Method mth, Object pojo, Object[] arguments, MessageExchange exchange) throws IllegalAccessException, InvocationTargetException {
        return mth.invoke(pojo, arguments);
    }
}

