/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bean;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.servicemix.bean.BeanComponent;
import org.apache.servicemix.bean.BeanEndpoint;
import org.apache.servicemix.bean.Endpoint;
import org.apache.servicemix.bean.support.ResolverUtil;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class EndpointFinder
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private ResolverUtil resolver = new ResolverUtil();
    private String[] packages = new String[0];
    private BeanComponent beanComponent;

    public EndpointFinder(BeanComponent beanComponent) {
        this.beanComponent = beanComponent;
        this.packages = beanComponent.getSearchPackages();
        this.applicationContext = beanComponent.getApplicationContext();
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void addEndpoints(List list) {
        this.resolver.findAnnotated(Endpoint.class, this.packages);
        Set classes = this.resolver.getClasses();
        for (Class aClass : classes) {
            if (this.shouldIgnoreBean(aClass)) continue;
            if (this.isClient(aClass)) {
                this.registerClient(aClass);
                continue;
            }
            if (Modifier.isAbstract(aClass.getModifiers())) continue;
            list.add(this.createBeanEndpoint(aClass));
        }
    }

    public void destroy() throws Exception {
    }

    protected boolean shouldIgnoreBean(Class type) {
        Map beans = this.applicationContext.getBeansOfType(type, true, true);
        return beans != null && !beans.isEmpty();
    }

    protected boolean isClient(Class type) {
        return type.isInterface() || Modifier.isAbstract(type.getModifiers());
    }

    protected void registerClient(Class type) {
    }

    protected BeanEndpoint createBeanEndpoint(Class serviceType) {
        Endpoint endpointAnnotation = serviceType.getAnnotation(Endpoint.class);
        if (endpointAnnotation == null) {
            throw new IllegalArgumentException("Could not find endpoint annotation on type: " + serviceType);
        }
        BeanEndpoint answer = new BeanEndpoint();
        answer.setBeanType(serviceType);
        answer.setEndpoint(endpointAnnotation.name());
        QName service = this.createQName(endpointAnnotation.serviceName(), endpointAnnotation.targetNamespace());
        if (service == null) {
            service = this.beanComponent.getEPRServiceName();
        }
        answer.setService(service);
        return answer;
    }

    protected QName createQName(String localName, String uri) {
        if (this.isNotNullOrBlank(localName)) {
            if (this.isNotNullOrBlank(uri)) {
                return new QName(uri, localName);
            }
            return new QName(localName);
        }
        return null;
    }

    protected boolean isNotNullOrBlank(String text) {
        return text != null && text.trim().length() > 0;
    }
}

