/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bean.support;

import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.bean.support.BeanSupport;
import org.apache.servicemix.bean.support.ExchangeTarget;
import org.apache.servicemix.components.util.CopyTransformer;

public abstract class TransformBeanSupport
extends BeanSupport
implements MessageExchangeListener {
    private ExchangeTarget target;
    private boolean copyProperties = true;
    private boolean copyAttachments = true;

    protected TransformBeanSupport() {
    }

    public ExchangeTarget getTarget() {
        return this.target;
    }

    public void setTarget(ExchangeTarget target) {
        this.target = target;
    }

    public void onMessageExchange(MessageExchange exchange) {
        block18: {
            if (exchange.getStatus() == ExchangeStatus.DONE) {
                return;
            }
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                return;
            }
            try {
                NormalizedMessage out;
                InOnly outExchange = null;
                NormalizedMessage in = this.getInMessage(exchange);
                if (this.isInAndOut(exchange)) {
                    out = exchange.createMessage();
                } else {
                    if (this.target == null) {
                        throw new IllegalStateException("An IN-ONLY TransformBean has no Target specified");
                    }
                    outExchange = this.getExchangeFactory().createInOnlyExchange();
                    this.target.configureTarget(exchange, this.getContext());
                    outExchange.setProperty("org.apache.servicemix.senderEndpoint", (Object)(this.getService() + ":" + this.getEndpoint()));
                    String processCorrelationId = (String)exchange.getProperty("org.apache.servicemix.correlationId");
                    if (processCorrelationId != null) {
                        outExchange.setProperty("org.apache.servicemix.correlationId", (Object)processCorrelationId);
                    }
                    out = outExchange.createMessage();
                }
                boolean txSync = exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
                this.copyPropertiesAndAttachments(exchange, in, out);
                if (this.transform(exchange, in, out)) {
                    if (this.isInAndOut(exchange)) {
                        exchange.setMessage(out, "out");
                        if (txSync) {
                            this.getDeliveryChannel().sendSync(exchange);
                        } else {
                            this.getDeliveryChannel().send(exchange);
                        }
                    } else {
                        outExchange.setMessage(out, "in");
                        if (txSync) {
                            this.getDeliveryChannel().sendSync((MessageExchange)outExchange);
                        } else {
                            this.getDeliveryChannel().send((MessageExchange)outExchange);
                        }
                        exchange.setStatus(ExchangeStatus.DONE);
                        this.getDeliveryChannel().send(exchange);
                    }
                } else {
                    exchange.setStatus(ExchangeStatus.DONE);
                    this.getDeliveryChannel().send(exchange);
                }
            }
            catch (Exception e) {
                try {
                    this.fail(exchange, e);
                }
                catch (Exception e2) {
                    this.logger.warn((Object)("Unable to handle error: " + e2), (Throwable)e2);
                    if (!this.logger.isDebugEnabled()) break block18;
                    this.logger.debug((Object)("Original error: " + e), (Throwable)e);
                }
            }
        }
    }

    protected abstract boolean transform(MessageExchange var1, NormalizedMessage var2, NormalizedMessage var3) throws Exception;

    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
        if (this.getMessageTransformer() instanceof CopyTransformer) {
            ((CopyTransformer)this.getMessageTransformer()).setCopyProperties(copyProperties);
        }
    }

    public boolean isCopyAttachments() {
        return this.copyAttachments;
    }

    public void setCopyAttachments(boolean copyAttachments) {
        this.copyAttachments = copyAttachments;
        if (this.getMessageTransformer() instanceof CopyTransformer) {
            ((CopyTransformer)this.getMessageTransformer()).setCopyAttachments(copyAttachments);
        }
    }

    protected void copyPropertiesAndAttachments(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        if (this.isCopyProperties()) {
            CopyTransformer.copyProperties((NormalizedMessage)in, (NormalizedMessage)out);
        }
        if (this.isCopyAttachments()) {
            CopyTransformer.copyAttachments((NormalizedMessage)in, (NormalizedMessage)out);
        }
    }
}

