/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bean;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.MBeanNames;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.bean.BeanComponent;
import org.apache.servicemix.bean.Callback;
import org.apache.servicemix.bean.Correlation;
import org.apache.servicemix.bean.ExchangeTarget;
import org.apache.servicemix.bean.MethodInvocationFailedException;
import org.apache.servicemix.bean.NoSuchBeanException;
import org.apache.servicemix.bean.UnknownMessageExchangeTypeException;
import org.apache.servicemix.bean.support.BeanInfo;
import org.apache.servicemix.bean.support.DefaultMethodInvocationStrategy;
import org.apache.servicemix.bean.support.DestinationImpl;
import org.apache.servicemix.bean.support.Holder;
import org.apache.servicemix.bean.support.MethodInvocationStrategy;
import org.apache.servicemix.bean.support.ReflectionUtils;
import org.apache.servicemix.bean.support.Request;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointComponentContext;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.expression.Expression;
import org.apache.servicemix.expression.JAXPStringXPathExpression;
import org.apache.servicemix.expression.PropertyExpression;
import org.apache.servicemix.jbi.resolver.URIResolver;
import org.apache.servicemix.jbi.util.MessageUtil;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ReflectionUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanEndpoint
extends ProviderEndpoint
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private String beanName;
    private Object bean;
    private BeanInfo beanInfo;
    private Class<?> beanType;
    private String beanClassName;
    private MethodInvocationStrategy methodInvocationStrategy;
    private Expression correlationExpression;
    private Map<String, Holder> exchanges = new ConcurrentHashMap<String, Holder>();
    private Map<Object, Request> requests = new ConcurrentHashMap<Object, Request>();
    private ThreadLocal<Request> currentRequest = new ThreadLocal();
    private ComponentContext context;
    private DeliveryChannel channel;
    private ServiceEndpoint serviceEndpoint;

    public BeanEndpoint() {
    }

    public BeanEndpoint(BeanComponent component, ServiceEndpoint serviceEndpoint) {
        super((DefaultComponent)component, serviceEndpoint);
        this.applicationContext = component.getApplicationContext();
        this.serviceEndpoint = serviceEndpoint;
    }

    public void start() throws Exception {
        Object pojo;
        super.start();
        this.context = new EndpointComponentContext((Endpoint)this);
        this.channel = this.context.getDeliveryChannel();
        if (this.serviceEndpoint == null) {
            this.serviceEndpoint = this.context.getEndpoint(this.getService(), this.getEndpoint());
        }
        if ((pojo = this.getBean()) != null) {
            this.injectBean(pojo);
            ReflectionUtils.callLifecycleMethod(pojo, PostConstruct.class);
        }
        Class<?> clazz = this.beanType = pojo != null ? pojo.getClass() : this.createBean().getClass();
        if (this.getMethodInvocationStrategy() == null) {
            throw new IllegalArgumentException("No 'methodInvocationStrategy' property set");
        }
    }

    public void stop() throws Exception {
        super.stop();
        Object pojo = this.getBean();
        if (pojo != null) {
            ReflectionUtils.callLifecycleMethod(pojo, PreDestroy.class);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public void setBeanType(Class<?> beanType) {
        this.beanType = beanType;
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }

    public void setBeanClassName(String beanClassName) {
        this.beanClassName = beanClassName;
    }

    public BeanInfo getBeanInfo() {
        if (this.beanInfo == null) {
            this.beanInfo = new BeanInfo(this.beanType, this.getMethodInvocationStrategy());
            this.beanInfo.introspect();
        }
        return this.beanInfo;
    }

    public void setBeanInfo(BeanInfo beanInfo) {
        this.beanInfo = beanInfo;
    }

    public MethodInvocationStrategy getMethodInvocationStrategy() {
        if (this.methodInvocationStrategy == null) {
            this.methodInvocationStrategy = this.createMethodInvocationStrategy();
        }
        return this.methodInvocationStrategy;
    }

    public void setMethodInvocationStrategy(MethodInvocationStrategy methodInvocationStrategy) {
        this.methodInvocationStrategy = methodInvocationStrategy;
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getRole() == MessageExchange.Role.CONSUMER) {
            this.onConsumerExchange(exchange);
        } else if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            this.onProviderExchange(exchange);
        } else {
            throw new IllegalStateException("Unknown role: " + exchange.getRole());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onProviderExchange(MessageExchange exchange) throws Exception {
        Object corId = this.getCorrelation(exchange);
        Request req = this.requests.get(corId);
        if (req == null) {
            Object pojo = this.getBean();
            if (pojo == null) {
                pojo = this.createBean();
                this.injectBean(pojo);
                ReflectionUtils.callLifecycleMethod(pojo, PostConstruct.class);
            }
            req = new Request(pojo, exchange);
            this.requests.put(corId, req);
        }
        this.currentRequest.set(req);
        Request request = req;
        synchronized (request) {
            if (req.getBean() instanceof MessageExchangeListener) {
                ((MessageExchangeListener)req.getBean()).onMessageExchange(exchange);
            } else {
                if (exchange.getStatus() == ExchangeStatus.DONE) {
                    return;
                }
                if (exchange.getStatus() == ExchangeStatus.ERROR) {
                    return;
                }
                if (exchange.getFault() != null) {
                    this.done(exchange);
                } else {
                    MethodInvocation invocation = this.getMethodInvocationStrategy().createInvocation(req.getBean(), this.getBeanInfo(), exchange, this);
                    if (invocation == null) {
                        throw new UnknownMessageExchangeTypeException(exchange, this);
                    }
                    try {
                        invocation.proceed();
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        throw new MethodInvocationFailedException(req.getBean(), invocation, exchange, this, throwable);
                    }
                    if (exchange.getStatus() == ExchangeStatus.ERROR) {
                        this.send(exchange);
                    }
                    if (exchange.getFault() == null && exchange.getMessage("out") == null) {
                        this.done(exchange);
                    }
                }
            }
            this.checkEndOfRequest(req, corId);
            this.currentRequest.set(null);
        }
    }

    protected void onConsumerExchange(MessageExchange exchange) throws Exception {
        String corId = exchange.getExchangeId();
        Request req = this.requests.remove(corId);
        if (req == null) {
            throw new IllegalStateException("Receiving unknown consumer exchange: " + exchange);
        }
        this.currentRequest.set(req);
        if (req.getBean() instanceof MessageExchangeListener) {
            ((MessageExchangeListener)req.getBean()).onMessageExchange(exchange);
        } else {
            Holder me = this.exchanges.get(exchange.getExchangeId());
            if (me == null) {
                throw new IllegalStateException("Consumer exchange not found");
            }
            me.set(exchange);
            this.evaluateCallbacks(req);
        }
        this.checkEndOfRequest(req, corId);
        this.currentRequest.set(null);
    }

    protected Object getCorrelation(MessageExchange exchange) throws MessagingException {
        return this.getCorrelationExpression().evaluate(exchange, exchange.getMessage("in"));
    }

    protected Object createBean() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.beanName == null && this.beanType == null) {
            throw new IllegalArgumentException("Property 'beanName' has not been set!");
        }
        if (this.beanType == null && this.beanClassName != null) {
            this.beanType = Class.forName(this.beanClassName, true, this.getServiceUnit().getConfigurationClassLoader());
        }
        if (this.beanType != null) {
            return this.beanType.newInstance();
        }
        if (this.beanName == null) {
            throw new IllegalArgumentException("Property 'beanName', 'beanType' or 'beanClassName' must be set!");
        }
        if (this.applicationContext == null) {
            throw new IllegalArgumentException("Property 'beanName' specified, but no BeanFactory set!");
        }
        Object answer = this.applicationContext.getBean(this.beanName);
        if (answer == null) {
            throw new NoSuchBeanException(this.beanName, this);
        }
        return answer;
    }

    protected MethodInvocationStrategy createMethodInvocationStrategy() {
        DefaultMethodInvocationStrategy st = new DefaultMethodInvocationStrategy();
        st.loadDefaultRegistry();
        return st;
    }

    protected void injectBean(final Object target) {
        final PojoContext ctx = new PojoContext();
        final DeliveryChannel ch = ctx.channel;
        ReflectionUtils.doWithFields(target.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field f) throws IllegalArgumentException, IllegalAccessException {
                ExchangeTarget et = f.getAnnotation(ExchangeTarget.class);
                if (et != null) {
                    ReflectionUtils.setField(f, target, new DestinationImpl(et.uri(), BeanEndpoint.this));
                }
                if (f.getAnnotation(Resource.class) != null) {
                    if (ComponentContext.class.isAssignableFrom(f.getType())) {
                        ReflectionUtils.setField(f, target, ctx);
                    } else if (DeliveryChannel.class.isAssignableFrom(f.getType())) {
                        ReflectionUtils.setField(f, target, ch);
                    } else if (ServiceEndpoint.class.isAssignableFrom(f.getType())) {
                        ReflectionUtils.setField(f, target, BeanEndpoint.this.serviceEndpoint);
                    }
                }
            }
        });
    }

    protected void evaluateCallbacks(final Request req) {
        final Object obj = req.getBean();
        ReflectionUtils.doWithMethods(obj.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                if (method.getAnnotation(Callback.class) != null) {
                    try {
                        org.apache.commons.jexl.Expression e = ExpressionFactory.createExpression((String)method.getAnnotation(Callback.class).condition());
                        JexlContext jc = JexlHelper.createContext();
                        jc.getVars().put("this", obj);
                        Object r = e.evaluate(jc);
                        if (!(r instanceof Boolean)) {
                            throw new RuntimeException("Expression did not returned a boolean value but: " + r);
                        }
                        Boolean oldVal = req.getCallbacks().get(method);
                        Boolean newVal = (Boolean)r;
                        if ((oldVal == null || !oldVal.booleanValue()) && newVal.booleanValue()) {
                            req.getCallbacks().put(method, newVal);
                            method.invoke(obj, new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to invoke callback", e);
                    }
                }
            }
        });
    }

    public Future<NormalizedMessage> send(String uri, NormalizedMessage message) {
        try {
            InOut me = this.getExchangeFactory().createInOutExchange();
            URIResolver.configureExchange((MessageExchange)me, (ComponentContext)this.getServiceUnit().getComponent().getComponentContext(), (String)uri);
            MessageUtil.transferTo((NormalizedMessage)message, (MessageExchange)me, (String)"in");
            Holder h = new Holder();
            this.requests.put(me.getExchangeId(), this.currentRequest.get());
            this.exchanges.put(me.getExchangeId(), h);
            this.send((MessageExchange)me);
            return h;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void checkEndOfRequest(Request request, Object corId) {
        if (request.getExchange().getStatus() != ExchangeStatus.ACTIVE) {
            Object beanFromRequest = request.getBean();
            if (beanFromRequest != this.bean) {
                ReflectionUtils.callLifecycleMethod(beanFromRequest, PreDestroy.class);
            }
            this.requests.remove(corId);
        }
    }

    public Expression getCorrelationExpression() {
        if (this.correlationExpression == null) {
            Correlation cor = this.beanType.getAnnotation(Correlation.class);
            if (cor != null) {
                if (cor.property() != null) {
                    this.correlationExpression = new PropertyExpression(cor.property());
                } else if (cor.xpath() != null) {
                    this.correlationExpression = new JAXPStringXPathExpression(cor.xpath());
                }
            }
            if (this.correlationExpression == null) {
                this.correlationExpression = new Expression(){

                    public Object evaluate(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
                        return exchange.getExchangeId();
                    }
                };
            }
        }
        return this.correlationExpression;
    }

    public void setCorrelationExpression(Expression correlationExpression) {
        this.correlationExpression = correlationExpression;
    }

    protected class PojoChannel
    implements DeliveryChannel {
        protected PojoChannel() {
        }

        public void close() throws MessagingException {
            BeanEndpoint.this.channel.close();
        }

        public MessageExchangeFactory createExchangeFactory() {
            return BeanEndpoint.this.channel.createExchangeFactory();
        }

        public MessageExchangeFactory createExchangeFactory(QName qName) {
            return BeanEndpoint.this.channel.createExchangeFactory(qName);
        }

        public MessageExchangeFactory createExchangeFactoryForService(QName qName) {
            return BeanEndpoint.this.channel.createExchangeFactoryForService(qName);
        }

        public MessageExchangeFactory createExchangeFactory(ServiceEndpoint se) {
            return BeanEndpoint.this.channel.createExchangeFactory(se);
        }

        public MessageExchange accept() throws MessagingException {
            return BeanEndpoint.this.channel.accept();
        }

        public MessageExchange accept(long l) throws MessagingException {
            return BeanEndpoint.this.channel.accept(l);
        }

        public void send(MessageExchange messageExchange) throws MessagingException {
            if (messageExchange.getRole() == MessageExchange.Role.CONSUMER && messageExchange.getStatus() == ExchangeStatus.ACTIVE) {
                BeanEndpoint.this.requests.put(messageExchange.getExchangeId(), BeanEndpoint.this.currentRequest.get());
            }
            BeanEndpoint.this.channel.send(messageExchange);
        }

        public boolean sendSync(MessageExchange messageExchange) throws MessagingException {
            return BeanEndpoint.this.channel.sendSync(messageExchange);
        }

        public boolean sendSync(MessageExchange messageExchange, long l) throws MessagingException {
            return BeanEndpoint.this.channel.sendSync(messageExchange, l);
        }
    }

    protected class PojoContext
    implements ComponentContext {
        private DeliveryChannel channel;

        protected PojoContext() {
            this.channel = new PojoChannel();
        }

        public ServiceEndpoint activateEndpoint(QName qName, String s) throws JBIException {
            return BeanEndpoint.this.context.activateEndpoint(qName, s);
        }

        public void deactivateEndpoint(ServiceEndpoint se) throws JBIException {
            BeanEndpoint.this.context.deactivateEndpoint(se);
        }

        public void registerExternalEndpoint(ServiceEndpoint se) throws JBIException {
            BeanEndpoint.this.context.registerExternalEndpoint(se);
        }

        public void deregisterExternalEndpoint(ServiceEndpoint se) throws JBIException {
            BeanEndpoint.this.context.deregisterExternalEndpoint(se);
        }

        public ServiceEndpoint resolveEndpointReference(DocumentFragment documentFragment) {
            return BeanEndpoint.this.context.resolveEndpointReference(documentFragment);
        }

        public String getComponentName() {
            return BeanEndpoint.this.context.getComponentName();
        }

        public DeliveryChannel getDeliveryChannel() throws MessagingException {
            return this.channel;
        }

        public ServiceEndpoint getEndpoint(QName qName, String s) {
            return BeanEndpoint.this.context.getEndpoint(qName, s);
        }

        public Document getEndpointDescriptor(ServiceEndpoint se) throws JBIException {
            return BeanEndpoint.this.context.getEndpointDescriptor(se);
        }

        public ServiceEndpoint[] getEndpoints(QName qName) {
            return BeanEndpoint.this.context.getEndpoints(qName);
        }

        public ServiceEndpoint[] getEndpointsForService(QName qName) {
            return BeanEndpoint.this.context.getEndpointsForService(qName);
        }

        public ServiceEndpoint[] getExternalEndpoints(QName qName) {
            return BeanEndpoint.this.context.getExternalEndpoints(qName);
        }

        public ServiceEndpoint[] getExternalEndpointsForService(QName qName) {
            return BeanEndpoint.this.context.getExternalEndpointsForService(qName);
        }

        public String getInstallRoot() {
            return BeanEndpoint.this.context.getInstallRoot();
        }

        public Logger getLogger(String s, String s1) throws MissingResourceException, JBIException {
            return BeanEndpoint.this.context.getLogger(s, s1);
        }

        public MBeanNames getMBeanNames() {
            return BeanEndpoint.this.context.getMBeanNames();
        }

        public MBeanServer getMBeanServer() {
            return BeanEndpoint.this.context.getMBeanServer();
        }

        public InitialContext getNamingContext() {
            return BeanEndpoint.this.context.getNamingContext();
        }

        public Object getTransactionManager() {
            return BeanEndpoint.this.context.getTransactionManager();
        }

        public String getWorkspaceRoot() {
            return BeanEndpoint.this.context.getWorkspaceRoot();
        }
    }
}

