/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bean.support;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.servicemix.jbi.FaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Holder
implements Future<NormalizedMessage> {
    private MessageExchange object;
    private boolean cancel;

    @Override
    public synchronized NormalizedMessage get() throws InterruptedException, ExecutionException {
        if (this.object == null) {
            this.wait();
        }
        return this.extract(this.object);
    }

    @Override
    public synchronized NormalizedMessage get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        if (this.object == null) {
            this.wait(unit.toMillis(timeout));
        }
        return this.extract(this.object);
    }

    public synchronized void set(MessageExchange t) {
        this.object = t;
        this.notifyAll();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancel = true;
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public boolean isDone() {
        return this.object != null;
    }

    protected NormalizedMessage extract(MessageExchange me) throws ExecutionException {
        if (me.getStatus() == ExchangeStatus.ERROR) {
            throw new ExecutionException(me.getError());
        }
        if (me.getFault() != null) {
            throw new ExecutionException((Throwable)new FaultException("Fault occured", me, me.getFault()));
        }
        return me.getMessage("out");
    }
}

