/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bean.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.servicemix.bean.BeanEndpoint;
import org.apache.servicemix.bean.support.BeanInfo;
import org.apache.servicemix.bean.support.MethodInvocationStrategy;
import org.apache.servicemix.expression.Expression;

public class DefaultMethodInvocationStrategy
implements MethodInvocationStrategy {
    private Map<Class, Expression> parameterTypeToExpressionMap = new ConcurrentHashMap<Class, Expression>();

    public Expression getDefaultParameterTypeExpression(Class parameterType) {
        return this.parameterTypeToExpressionMap.get(parameterType);
    }

    public void addParameterMapping(Class parameterType, Expression expression) {
        this.parameterTypeToExpressionMap.put(parameterType, expression);
    }

    public MethodInvocation createInvocation(Object pojo, BeanInfo beanInfo, MessageExchange messageExchange, BeanEndpoint pojoEndpoint) throws MessagingException {
        return beanInfo.createInvocation(pojo, messageExchange);
    }

    public void loadDefaultRegistry() {
        this.addParameterMapping(MessageExchange.class, new Expression(){

            public Object evaluate(MessageExchange messageExchange, NormalizedMessage normalizedMessage) throws MessagingException {
                return messageExchange;
            }
        });
        this.addParameterMapping(NormalizedMessage.class, new Expression(){

            public Object evaluate(MessageExchange messageExchange, NormalizedMessage normalizedMessage) throws MessagingException {
                return normalizedMessage;
            }
        });
        this.addParameterMapping(Source.class, new Expression(){

            public Object evaluate(MessageExchange messageExchange, NormalizedMessage normalizedMessage) throws MessagingException {
                return normalizedMessage.getContent();
            }
        });
    }
}

