/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.action.bpel;

import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.bpel.JaxenUtil;
import org.apache.ode.bpe.action.bpel.UnInitVariableMetaData;
import org.apache.ode.bpe.action.bpel.XPathJaxenExpression;
import org.apache.ode.bpe.action.internal.ActionException;
import org.apache.ode.bpe.action.internal.IInternalAction;
import org.apache.ode.bpe.context.resolver.ContextResolvedObject;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.context.test.SerializationContext;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.scope.service.BPRuntimeException;
import org.apache.ode.bpe.util.BPException;

public class CopyAction
implements IInternalAction {
    public static final String FROM_VARIABLE_KEY = "from_variable";
    public static final String TO_VARIABLE_KEY = "to_variable";
    public static final String EXPRESSION_VARIABLE_KEY = "expression_variable";
    public static final String LITERAL_VARIABLE_KEY = "literal_variable";
    public static final String UNINITVAR_KEY = "UNITVAR";
    protected static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$action$bpel$CopyAction == null ? (class$org$apache$ode$bpe$action$bpel$CopyAction = CopyAction.class$("org.apache.ode.bpe.action.bpel.CopyAction")) : class$org$apache$ode$bpe$action$bpel$CopyAction).getName());
    private XPathJaxenExpression expressionTree;
    protected String fromVar;
    protected String toVar;
    private UnInitVariableMetaData varMetadata;
    private String literal;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$CopyAction;

    public void init(Properties properties) throws BPException {
        if (((Hashtable)properties).get(EXPRESSION_VARIABLE_KEY) != null) {
            this.expressionTree = (XPathJaxenExpression)((Hashtable)properties).get(EXPRESSION_VARIABLE_KEY);
            this.expressionTree.getExpressionTree();
        }
        this.varMetadata = (UnInitVariableMetaData)((Hashtable)properties).get(UNINITVAR_KEY);
        if (this.varMetadata == null) {
            throw new ActionException("NULL_PROP", new Object[]{UNINITVAR_KEY, (class$org$apache$ode$bpe$action$bpel$CopyAction == null ? (class$org$apache$ode$bpe$action$bpel$CopyAction = CopyAction.class$("org.apache.ode.bpe.action.bpel.CopyAction")) : class$org$apache$ode$bpe$action$bpel$CopyAction).getName()}, null);
        }
        this.literal = properties.getProperty(LITERAL_VARIABLE_KEY);
        this.fromVar = properties.getProperty(FROM_VARIABLE_KEY);
        this.toVar = properties.getProperty(TO_VARIABLE_KEY);
    }

    public boolean execute(ContextResolver resolver, IEvaluationContext ec, IProcessCallBack pcb, IPMIProcess processInstance, IPMDProcess processDefinition) throws BPException {
        try {
            ContextResolvedObject to = (ContextResolvedObject)resolver.resolveForUpdateBPContext(this.toVar);
            if (this.fromVar != null) {
                ContextResolvedObject from = (ContextResolvedObject)resolver.resolveBPContext(this.fromVar);
                if (from.getValue() == null) {
                    throw new BPRuntimeException("uninitializedVariable", "BPEL_RT_uninitializedVariable", new Object[]{this.fromVar});
                }
                to.setObject(from.getValue());
            } else if (this.expressionTree != null) {
                to.setObject(JaxenUtil.evalString(resolver, this.expressionTree, this.varMetadata));
            } else if (this.literal != null) {
                to.setObject(this.literal);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            String sourceStr = "undefined";
            if (this.fromVar != null) {
                sourceStr = this.fromVar;
            } else if (this.expressionTree != null) {
                sourceStr = this.expressionTree.getSourceExpression();
            }
            throw new BPException("ASSIGN_ERROR", new Object[]{processDefinition.getRoot().getLabel(), processDefinition.getRoot().getKey().getValue(), processDefinition.getLabel(), sourceStr, this.toVar}, e);
        }
        if (logger.isLoggable(Level.FINE)) {
            SerializationContext sc = new SerializationContext(System.out);
            resolver.getContextService();
            try {
                sc.printComment("Copy Action Context:");
                sc.serialize(resolver.getContextService());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void release() {
        this.expressionTree = null;
        this.fromVar = null;
        this.toVar = null;
        this.varMetadata = null;
        this.literal = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

