/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.action.bpel;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.internal.IInternalAction;
import org.apache.ode.bpe.action.param.ActionParamFactory;
import org.apache.ode.bpe.action.param.IActionParam;
import org.apache.ode.bpe.client.IFormattableValue;
import org.apache.ode.bpe.context.resolver.ContextResolvedObject;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.deployment.DefinitionKey;
import org.apache.ode.bpe.deployment.bpel.BPELDeploy;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.scope.service.BPRuntimeException;
import org.apache.ode.bpe.util.BPException;
import org.apache.ode.bpe.wsdl.extensions.BPEInput;

public class DeployAction
implements IInternalAction {
    private static final String LOCATION = "location";
    private static final String FAULT_NAME = "deployFault";
    private static final String SCHEMA_LOCATION = "schemaLocation";
    private static final String ISVALIDATING = "validating";
    protected static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$action$bpel$DeployAction == null ? (class$org$apache$ode$bpe$action$bpel$DeployAction = DeployAction.class$("org.apache.ode.bpe.action.bpel.DeployAction")) : class$org$apache$ode$bpe$action$bpel$DeployAction).getName());
    private boolean isValidating;
    private String schemaLocation;
    private String defaultLocation;
    private Collection m_inputMap;
    private String m_inputVar;
    private HashMap m_input = new HashMap();
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$DeployAction;

    public void init(Properties props) throws BPRuntimeException {
        this.m_inputMap = (Collection)((Hashtable)props).get("input_map");
        this.m_inputVar = props.getProperty("input_locator");
        Properties extProps = (Properties)((Hashtable)props).get("external_action_properties");
        this.schemaLocation = extProps.getProperty(SCHEMA_LOCATION);
        this.isValidating = extProps.getProperty(ISVALIDATING) == "true";
        this.defaultLocation = extProps.getProperty(LOCATION);
    }

    public boolean execute(ContextResolver resolver, IEvaluationContext ec, IProcessCallBack pcb, IPMIProcess processInstance, IPMDProcess processDefinition) throws BPException {
        this.buildInput(resolver);
        IFormattableValue locationObj = (IFormattableValue)this.m_input.get(LOCATION);
        String location = ((Object)locationObj).toString();
        if (!(location != null && location.length() != 0 || (location = this.defaultLocation) != null && location.length() != 0)) {
            BPRuntimeException rte = new BPRuntimeException(FAULT_NAME, null, null);
            rte.addPartMessage("message", "Input location is null");
            throw rte;
        }
        InputStream bpelStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        if (bpelStream == null) {
            try {
                bpelStream = new FileInputStream(location);
            }
            catch (FileNotFoundException e1) {
                // empty catch block
            }
            if (bpelStream == null) {
                BPRuntimeException rte = new BPRuntimeException(FAULT_NAME, null, null);
                rte.addPartMessage("message", "BPE Deployer could not open location:" + location);
                throw rte;
            }
        }
        try {
            BPELDeploy d = new BPELDeploy(ec.getProcessService().getInstanceService().getDefinitionService());
            Collection keys = d.deployJar(bpelStream, this.isValidating, this.schemaLocation);
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                DefinitionKey defkey = (DefinitionKey)it.next();
                DefinitionService ds = pcb.getProcessService().getInstanceService().getDefinitionService();
                ds.loadDefintion(new ProcessDefinitionKey(defkey.getKey()), pcb);
            }
        }
        catch (BPException e) {
            e.log(logger, Level.SEVERE);
            BPRuntimeException rte = new BPRuntimeException(FAULT_NAME, null, null);
            rte.addPartMessage("message", e.getMessage());
            throw rte;
        }
        return true;
    }

    public void release() {
    }

    private void buildInput(ContextResolver resolver) throws BPException {
        ContextResolvedObject data = null;
        BPEInput inputNode = null;
        IActionParam param = null;
        String partName = null;
        Iterator inputItr = this.m_inputMap.iterator();
        while (inputItr.hasNext()) {
            inputNode = (BPEInput)inputItr.next();
            partName = inputNode.getPart() == null ? this.m_inputVar : inputNode.getPart();
            data = (ContextResolvedObject)resolver.resolveBPContext(this.m_inputVar + ":" + partName);
            if (data == null) continue;
            param = ActionParamFactory.createActionParam(data, inputNode.getType());
            this.m_input.put(partName, param.getParam());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

