/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.action.bpel;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.internal.ActionException;
import org.apache.ode.bpe.action.internal.IInternalAction;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.scope.service.IFCScopeInstance;
import org.apache.ode.bpe.scope.service.IScopeService;
import org.apache.ode.bpe.scope.service.ScopePath;
import org.apache.ode.bpe.util.BPException;

public class StartScopeAction
implements IInternalAction {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$action$bpel$StartScopeAction == null ? (class$org$apache$ode$bpe$action$bpel$StartScopeAction = StartScopeAction.class$("org.apache.ode.bpe.action.bpel.StartScopeAction")) : class$org$apache$ode$bpe$action$bpel$StartScopeAction).getName());
    public static final String SCOPE_NAME = "name";
    public static final String FAULT_OBSERVER = "observer";
    public static final String FAULT_HANDLERS = "faultHandlers";
    private Properties props;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$StartScopeAction;

    public void init(Properties properties) throws ActionException {
        this.props = properties;
    }

    public boolean execute(ContextResolver resolver, IEvaluationContext ec, IProcessCallBack pcb, IPMIProcess processInstance, IPMDProcess processDefinition) throws BPException {
        HashMap faultHandlers;
        if (logger.isLoggable(Level.FINE)) {
            Enumeration e = ((Hashtable)this.props).elements();
            StringBuffer sb = new StringBuffer();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement().toString());
                sb.append("  ");
            }
            logger.fine("StartScope Props:" + sb.toString());
        }
        IScopeService ss = resolver.getScopeService();
        ScopePath sp = processInstance.getScopePath();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Current scope: " + sp);
        }
        IFCScopeInstance scope = ss.getScope(sp);
        IFCScopeInstance newScope = scope.createScope(this.props.getProperty(SCOPE_NAME), processInstance.getKey(), processInstance.getContextContainerId());
        processInstance.setExecutionContext("process");
        processInstance.setScopePath(newScope.getScopePath());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("New scope: " + newScope.getScopePath());
        }
        if ((faultHandlers = (HashMap)((Hashtable)this.props).get(FAULT_HANDLERS)) != null) {
            Iterator it = faultHandlers.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                newScope.addFaultHandler(name, "", (String)faultHandlers.get(name));
            }
        }
        newScope.setFaultHandlerObserver(this.props.getProperty(FAULT_OBSERVER));
        return true;
    }

    public void release() {
        this.props = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

