/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.action.bpel;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.internal.ActionException;
import org.apache.ode.bpe.action.internal.IInternalAction;
import org.apache.ode.bpe.context.IContainer;
import org.apache.ode.bpe.context.IContextService;
import org.apache.ode.bpe.context.IPart;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.scope.service.BPRuntimeException;
import org.apache.ode.bpe.util.BPException;

public class ThrowAction
implements IInternalAction {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$action$bpel$ThrowAction == null ? (class$org$apache$ode$bpe$action$bpel$ThrowAction = ThrowAction.class$("org.apache.ode.bpe.action.bpel.ThrowAction")) : class$org$apache$ode$bpe$action$bpel$ThrowAction).getName());
    private Properties props;
    public static final String EXCEPTION_NAME = "ExceptionName";
    public static final String EXCEPTION_NS = "NameSpace";
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$ThrowAction;

    public void init(Properties properties) throws ActionException {
        this.props = properties;
    }

    public boolean execute(ContextResolver resolver, IEvaluationContext ec, IProcessCallBack pcb, IPMIProcess processInstance, IPMDProcess processDefinition) throws BPException {
        String err;
        if (logger.isLoggable(Level.FINE)) {
            Enumeration e = ((Hashtable)this.props).elements();
            StringBuffer sb = new StringBuffer();
            while (e.hasMoreElements()) {
                sb.append((String)e.nextElement());
                sb.append("  ");
            }
            logger.fine("ThrowAction Props:" + sb.toString());
        }
        if (this.props.getProperty(EXCEPTION_NAME) != null) {
            BPRuntimeException bpr = new BPRuntimeException(this.props.getProperty(EXCEPTION_NAME), null, null);
            bpr.setNameSpace(this.props.getProperty(EXCEPTION_NS));
            throw bpr;
        }
        IContextService cs = resolver.getContextService();
        IContainer rootCont = cs.getRoot();
        IContainer globalCont = (IContainer)rootCont.findChild(processInstance.getRootKey());
        IPart part = (IPart)globalCont.findChild("currentException");
        if (part == null) {
            part = globalCont.createPart("currentException");
        }
        if ((err = (String)part.getObjectForRead()) == null) {
            throw new ActionException("bpe:no_rethrow_exception", null);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Re-throwing:" + err);
        }
        throw new BPRuntimeException(err, null, null);
    }

    public void release() {
        this.props = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

