/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.action.external;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.external.IExternalAction;
import org.apache.ode.bpe.action.external.IURIResolver;
import org.apache.ode.bpe.client.BPEClient;
import org.apache.ode.bpe.client.IBPEMessage;
import org.apache.ode.bpe.client.IBPEMessagePart;
import org.apache.ode.bpe.client.IDescribedValue;
import org.apache.ode.bpe.client.IFormattableValue;
import org.apache.ode.bpe.client.IOperation;
import org.apache.ode.bpe.client.result.IFaultResult;
import org.apache.ode.bpe.client.result.IResult;
import org.apache.ode.bpe.client.result.ISuccessWithResponse;
import org.apache.ode.bpe.context.base.ContextUtil;
import org.apache.ode.bpe.interaction.spiadapter.SPIAdapterInteraction;
import org.apache.ode.bpe.scope.service.BPRuntimeException;

public class BusinessProcessInvocationAction
implements IExternalAction {
    static final long serialVersionUID = 8880364530453321427L;
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$action$external$BusinessProcessInvocationAction == null ? (class$org$apache$ode$bpe$action$external$BusinessProcessInvocationAction = BusinessProcessInvocationAction.class$("org.apache.ode.bpe.action.external.BusinessProcessInvocationAction")) : class$org$apache$ode$bpe$action$external$BusinessProcessInvocationAction).getName());
    public static final String FAULT_NAME = "InvocationFault";
    private Properties operationProps;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$external$BusinessProcessInvocationAction;

    public void init(Properties props) throws BPRuntimeException {
        this.operationProps = new Properties();
        this.operationProps.setProperty("port.type", props.getProperty("PortTypeName"));
        this.operationProps.setProperty("target.name.space", props.getProperty("PortTypeNameSpace"));
        this.operationProps.setProperty("operation", props.getProperty("OperationName"));
    }

    public void execute(HashMap input, HashMap output, IURIResolver resolver) throws BPRuntimeException {
        try {
            Properties props = new Properties();
            BPEClient client = new BPEClient(props);
            IBPEMessage msg = client.createMessage();
            Iterator inputIterator = input.entrySet().iterator();
            while (inputIterator.hasNext()) {
                Map.Entry entry = inputIterator.next();
                String key = (String)entry.getKey();
                Object object = entry.getValue();
                object = !(object instanceof IFormattableValue) ? ContextUtil.cloneObject(object) : this.seralizeClone(object, key);
                IDescribedValue dv = null;
                if (object instanceof SPIAdapterInteraction) {
                    SPIAdapterInteraction inter = (SPIAdapterInteraction)object;
                    dv = inter.getUserValue().getDescribedValue();
                } else if (object instanceof IFormattableValue) {
                    dv = ((IFormattableValue)object).getDescribedValue();
                }
                IBPEMessagePart part = client.createPart(key, dv);
                msg.addPart(part);
            }
            IOperation op = client.createOperation(this.operationProps);
            IResult rslt = op.invoke(msg);
            IBPEMessage rsp = null;
            if (rslt instanceof ISuccessWithResponse) {
                rsp = ((ISuccessWithResponse)rslt).getResponse();
            } else if (rslt instanceof IFaultResult) {
                IFaultResult fault = (IFaultResult)rslt;
                String name = fault.getFaultName().substring(fault.getFaultName().indexOf(":") + 1);
                BPRuntimeException bpr = new BPRuntimeException(name, null, null);
                bpr.setNameSpace(fault.getFaultNamespace());
                throw bpr;
            }
            rsp.getParts();
            Collection responseParts = rsp.getParts();
            Iterator outputIterator = responseParts.iterator();
            while (outputIterator.hasNext()) {
                IBPEMessagePart part = (IBPEMessagePart)outputIterator.next();
                Object object = part.getFormattableValue();
                object = !(object instanceof IFormattableValue) ? ContextUtil.cloneObject(object) : this.seralizeClone(object, part.getName());
                output.put(part.getName(), object);
            }
        }
        catch (Exception e) {
            if (e instanceof BPRuntimeException) {
                throw (BPRuntimeException)e;
            }
            BPRuntimeException bp = new BPRuntimeException(FAULT_NAME, "NATIVE_EXCEPTION", new Object[]{"BusinessProcessInvocationActionError"}, e);
            throw bp;
        }
    }

    private Object seralizeClone(Object obj, String key) throws ClassNotFoundException, IOException {
        Object ret = obj;
        if (obj instanceof Serializable) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            ret = ois.readObject();
        } else {
            logger.warning("Input part " + key + " not serializable; the part will not be cloned.");
        }
        return ret;
    }

    public void release() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

