/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.bped;

import org.apache.ode.bpe.bped.DeployTypeEnum;
import org.apache.ode.bpe.bped.EventDirector;
import org.apache.ode.bpe.bped.IDeployer;
import org.apache.ode.bpe.bped.IInternalEventDirector;
import org.apache.ode.bpe.client.impl.IInternalMessage;
import org.apache.ode.bpe.client.impl.IInternalResult;
import org.apache.ode.bpe.client.impl.MessageConverter;
import org.apache.ode.bpe.client.impl.def.InternalResult;
import org.apache.ode.bpe.engine.InactiveDefinitionException;
import org.apache.ode.bpe.engine.ProcessInstancePausedException;
import org.apache.ode.bpe.event.IRequestMessageEvent;
import org.apache.ode.bpe.event.IResponseMessage;
import org.apache.ode.bpe.event.IStaticKey;
import org.apache.ode.bpe.event.StateEvent;
import org.apache.ode.bpe.scope.service.BPRuntimeException;
import org.apache.ode.bpe.util.BPException;

public abstract class ExternalEventDirectorBase
implements EventDirector {
    public IInternalResult sendRequest(IStaticKey key, IInternalMessage internalRequest) {
        IInternalResult iresult;
        MessageConverter mc = new MessageConverter();
        IRequestMessageEvent rme = mc.createRequest(key, internalRequest);
        try {
            IResponseMessage response = this.sendEvent(rme, true);
            iresult = mc.createResult(response);
        }
        catch (BPRuntimeException bpre) {
            InternalResult internalResult = new InternalResult();
            MessageConverter.PopulateBusinessProcessFaultResult(internalResult, bpre);
            iresult = internalResult;
        }
        catch (ProcessInstancePausedException pipe) {
            InternalResult internalResult = new InternalResult();
            MessageConverter.PopulatePausedInstanceException(internalResult, pipe);
            iresult = internalResult;
        }
        catch (InactiveDefinitionException iade) {
            InternalResult internalResult = new InternalResult();
            MessageConverter.PopulateInactiveDefinitionException(internalResult, iade);
            iresult = internalResult;
        }
        catch (Exception e) {
            InternalResult internalResult = new InternalResult();
            MessageConverter.PopulateSystemExceptionResult(internalResult, e);
            iresult = internalResult;
        }
        return iresult;
    }

    public IDeployer getDeployer(DeployTypeEnum type) {
        return null;
    }

    public IResponseMessage sendEvent(IRequestMessageEvent msg, boolean sync) throws BPException {
        return null;
    }

    public void sendEvent(StateEvent me, boolean sync) throws BPException {
    }

    public abstract /* synthetic */ IInternalEventDirector getIInternalEventDirector();
}

