/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.bped.managed;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.bped.IDeployer;
import org.apache.ode.bpe.definition.service.managed.ProcessDefinition;
import org.apache.ode.bpe.util.BPException;

public class BPELDeployerRemote
implements IDeployer {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$bped$managed$BPELDeployerRemote == null ? (class$org$apache$ode$bpe$bped$managed$BPELDeployerRemote = BPELDeployerRemote.class$("org.apache.ode.bpe.bped.managed.BPELDeployerRemote")) : class$org$apache$ode$bpe$bped$managed$BPELDeployerRemote).getName());
    private ProcessDefinition pd;
    static /* synthetic */ Class class$org$apache$ode$bpe$bped$managed$BPELDeployerRemote;

    public BPELDeployerRemote(ProcessDefinition pd) {
        this.pd = pd;
    }

    public Collection loadDefinition(InputStream is, boolean validating) throws BPException {
        Collection keys = null;
        try {
            int len;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) >= 0) {
                bos.write(buf, 0, len);
            }
            keys = this.pd.deploy(bos.toByteArray(), validating, null);
        }
        catch (RemoteException e) {
            BPException bpx = new BPException("NATIVE_EXCEPTION", new Object[]{"RemoteException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (IOException e) {
            BPException bpx = new BPException("NATIVE_EXCEPTION", new Object[]{"IOException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        return keys;
    }

    public void removeDefinition(String defID) throws BPException {
        try {
            this.pd.removeDefinition(defID);
        }
        catch (RemoteException e) {
            BPException bpx = new BPException("NATIVE_EXCEPTION", new Object[]{"RemoteException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
    }

    public void setStateless(String defID) throws BPException {
        try {
            this.pd.setStateless(defID);
        }
        catch (RemoteException e) {
            BPException bpx = new BPException("NATIVE_EXCEPTION", new Object[]{"RemoteException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
    }

    public Collection loadDefinition(String resource, boolean validating) throws BPException {
        Collection keys = null;
        try {
            keys = this.pd.deploy(resource, validating, null);
        }
        catch (RemoteException e) {
            BPException bpx = new BPException("NATIVE_EXCEPTION", new Object[]{"RemoteException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        return keys;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

