/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.bped.managed;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import org.apache.ode.bpe.bped.EventDirectorFactory;
import org.apache.ode.bpe.bped.ExternalEventDirectorBase;
import org.apache.ode.bpe.bped.IInternalEventDirector;
import org.apache.ode.bpe.client.impl.IInternalRequestConsumer;
import org.apache.ode.bpe.context.IContainer;
import org.apache.ode.bpe.context.IContextService;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.engine.ProcessInstance;
import org.apache.ode.bpe.engine.ProcessService;
import org.apache.ode.bpe.engine.StateEnum;
import org.apache.ode.bpe.event.Fault;
import org.apache.ode.bpe.event.IRequestMessageEvent;
import org.apache.ode.bpe.event.IResponseMessage;
import org.apache.ode.bpe.event.LoadDefinitionEvent;
import org.apache.ode.bpe.event.StateEvent;
import org.apache.ode.bpe.timerservice.IBPETimer;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;

public class BPEventDirectorBean
extends ExternalEventDirectorBase
implements SessionBean,
IInternalRequestConsumer {
    static final long serialVersionUID = 8909646742595626256L;
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$bped$managed$BPEventDirectorBean == null ? (class$org$apache$ode$bpe$bped$managed$BPEventDirectorBean = BPEventDirectorBean.class$("org.apache.ode.bpe.bped.managed.BPEventDirectorBean")) : class$org$apache$ode$bpe$bped$managed$BPEventDirectorBean).getName());
    private InitialContext ic;
    private ProcessService ps;
    private IInternalEventDirector ed;
    static /* synthetic */ Class class$org$apache$ode$bpe$bped$managed$BPEventDirectorBean;

    public void startProcess(String id) {
        try {
            ProcessInstance pi = this.ps.createProcess(new ProcessDefinitionKey(id));
            IContextService ctxs = pi.getContextService();
            IContainer cont = ctxs.getRoot();
            cont.createContainer(pi.getRootKey());
            pi.processEvent(new StateEvent(pi.getRootKey(), pi.getKey(), StateEnum.STARTED), this.ed, this.ed);
        }
        catch (BPException bPException) {
            // empty catch block
        }
    }

    public IResponseMessage sendEvent(IRequestMessageEvent event, boolean sync) {
        try {
            IResponseMessage rsp = this.ed.sendEvent(event, sync);
            return rsp;
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "", ex);
            try {
                IResponseMessage resp = event.createResponseMessage();
                Fault fault = new Fault();
                fault.setFaultString(ex.getLocalizedMessage());
                fault.setFaultException(ex);
                resp.setFault(fault);
                return resp;
            }
            catch (BPException e) {
                logger.log(Level.SEVERE, "", e);
                return null;
            }
        }
    }

    public void sendEvent(StateEvent event, boolean sync) {
        try {
            this.ed.sendEvent(event, sync);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendEvent(LoadDefinitionEvent event, boolean sync) {
        try {
            this.ed.sendEvent(event, sync);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Fault sendEvent(IBPETimer event, boolean sync) {
        Fault fault = null;
        try {
            fault = this.ed.sendEvent(event, sync);
        }
        catch (Exception ex) {
            fault = new Fault();
            fault.setFaultString(ex.getLocalizedMessage());
        }
        return fault;
    }

    public void ejbCreate() {
        try {
            this.ic = new InitialContext();
            BPEProperties p = new BPEProperties(true, this.ic);
            this.ed = (IInternalEventDirector)((Object)EventDirectorFactory.createEventDirector(p));
            this.ps = this.ed.getProcessService();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "", ex);
        }
    }

    public void setSessionContext(SessionContext ctx) {
    }

    public void ejbRemove() {
        this.ed.release();
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbLoad() {
    }

    public void ejbStore() {
    }

    public IInternalEventDirector getIInternalEventDirector() {
        return this.ed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

