/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.bped.managed;

import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.ode.bpe.bped.DeployTypeEnum;
import org.apache.ode.bpe.bped.EventDirector;
import org.apache.ode.bpe.bped.EventDirectorException;
import org.apache.ode.bpe.bped.EventDirectorUtil;
import org.apache.ode.bpe.bped.IDeployer;
import org.apache.ode.bpe.bped.IInternalEventDirector;
import org.apache.ode.bpe.client.impl.IInternalMessage;
import org.apache.ode.bpe.client.impl.IInternalResult;
import org.apache.ode.bpe.correlation.CorrelationService;
import org.apache.ode.bpe.correlation.managed.CorrelationServiceEjbImpl;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.engine.ProcessInstance;
import org.apache.ode.bpe.engine.ProcessService;
import org.apache.ode.bpe.engine.ReturnMessageLocatorHolder;
import org.apache.ode.bpe.event.Fault;
import org.apache.ode.bpe.event.IRequestMessageEvent;
import org.apache.ode.bpe.event.IResponseMessage;
import org.apache.ode.bpe.event.IStaticKey;
import org.apache.ode.bpe.event.LoadDefinitionEvent;
import org.apache.ode.bpe.event.StateEvent;
import org.apache.ode.bpe.locking.LockingService;
import org.apache.ode.bpe.timerservice.IBPETimer;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;
import org.apache.ode.bpe.uuid.UUIDService;

public class EventDirectorEjbImpl
implements IInternalEventDirector,
EventDirector {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$bped$managed$EventDirectorEjbImpl == null ? (class$org$apache$ode$bpe$bped$managed$EventDirectorEjbImpl = EventDirectorEjbImpl.class$("org.apache.ode.bpe.bped.managed.EventDirectorEjbImpl")) : class$org$apache$ode$bpe$bped$managed$EventDirectorEjbImpl).getName());
    private ReturnMessageLocatorHolder rmlh;
    private IRequestMessageEvent me;
    private UUIDService us;
    private ProcessService processService;
    private CorrelationService correlationService;
    private LockingService lockingService;
    private DefinitionService definitionService;
    private Stack processInstanceStack = new Stack();
    private boolean dead;
    static /* synthetic */ Class class$org$apache$ode$bpe$bped$managed$EventDirectorEjbImpl;

    public void init(BPEProperties props, ProcessService ps, CorrelationService cs, UUIDService us, LockingService ls) throws BPException {
        try {
            InitialContext context = new InitialContext();
            props = new BPEProperties(true, context);
            this.us = us;
            this.processService = ps;
            this.correlationService = cs;
            this.lockingService = ls;
        }
        catch (NamingException e) {
            BPException bpx = new BPException("NATIVE_EXCEPTION", new Object[]{"NamingException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
    }

    public CorrelationService getCorrelationService() {
        return this.correlationService;
    }

    public LockingService getLockingService() {
        return this.lockingService;
    }

    public ProcessService getProcessService() {
        return this.processService;
    }

    public ReturnMessageLocatorHolder getReturnMessageMetadata() {
        return this.rmlh;
    }

    public void setReturnMessageMetadata(ReturnMessageLocatorHolder rmlh) {
        this.rmlh = rmlh;
    }

    public IRequestMessageEvent getMessageEvent() {
        return this.me;
    }

    public void setMessageEvent(IRequestMessageEvent me) {
        this.me = me;
    }

    public void release() {
        try {
            this.us.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "", e);
        }
        this.processService.getInstanceService().getDefinitionService().releaseExternalActions();
    }

    public IResponseMessage sendEvent(IRequestMessageEvent msg, boolean sync) throws BPException {
        CorrelationServiceEjbImpl csei;
        IResponseMessage er = null;
        logger.fine("Received message event.");
        if (this.correlationService instanceof CorrelationServiceEjbImpl) {
            csei = (CorrelationServiceEjbImpl)this.correlationService;
            csei.clearState();
        }
        this.getDefinitionService().prepare();
        er = this.correlationService.correlateEvent(msg, sync, this);
        if (this.correlationService instanceof CorrelationServiceEjbImpl) {
            csei = (CorrelationServiceEjbImpl)this.correlationService;
            csei.persistRegistrationChanges();
        }
        return er;
    }

    private DefinitionService getDefinitionService() throws BPException {
        if (this.definitionService == null) {
            this.definitionService = this.correlationService.getProcessService().getInstanceService().getDefinitionService();
        }
        return this.definitionService;
    }

    public void activate(String rootKey, String procKey) throws BPException {
        try {
            EventDirectorUtil.activate(this, rootKey, procKey);
        }
        catch (EventDirectorException ede) {
            logger.log(Level.SEVERE, "", ede);
            throw ede;
        }
    }

    public void terminate(String rootKey, String procKey) throws BPException {
        try {
            EventDirectorUtil.terminate(this, rootKey, procKey);
        }
        catch (EventDirectorException ede) {
            logger.log(Level.SEVERE, "", ede);
            throw ede;
        }
    }

    public void pause(String rootKey, String procKey) throws BPException {
        EventDirectorUtil.pause(this, rootKey, procKey);
    }

    public IDeployer getDeployer(DeployTypeEnum type) {
        return null;
    }

    public void sendEvent(StateEvent me, boolean sync) throws BPException {
        CorrelationServiceEjbImpl csei;
        if (this.correlationService instanceof CorrelationServiceEjbImpl) {
            csei = (CorrelationServiceEjbImpl)this.correlationService;
            csei.clearState();
        }
        EventDirectorUtil.handleStateEvent(this, this.processService, me);
        if (this.correlationService instanceof CorrelationServiceEjbImpl) {
            csei = (CorrelationServiceEjbImpl)this.correlationService;
            csei.persistRegistrationChanges();
        }
    }

    public void sendEvent(LoadDefinitionEvent me, boolean sync) throws BPException {
        EventDirectorUtil.handleLoadDefintionEvent(this, me);
    }

    public Fault sendEvent(IBPETimer me, boolean sync) throws BPException {
        CorrelationServiceEjbImpl csei;
        if (this.correlationService instanceof CorrelationServiceEjbImpl) {
            csei = (CorrelationServiceEjbImpl)this.correlationService;
            csei.clearState();
        }
        EventDirectorUtil.handleTimerEvent(this, me);
        if (this.correlationService instanceof CorrelationServiceEjbImpl) {
            csei = (CorrelationServiceEjbImpl)this.correlationService;
            csei.persistRegistrationChanges();
        }
        return null;
    }

    public void addProcessInstance(ProcessInstance pi) {
        this.processInstanceStack.push(pi);
    }

    public ProcessInstance getNextProcessInstance() {
        return this.processInstanceStack.size() > 0 ? (ProcessInstance)this.processInstanceStack.pop() : null;
    }

    public void initProcessInstanceCollection() {
        this.processInstanceStack.clear();
    }

    public boolean processInstanceCollectionIsEmpty() {
        return this.processInstanceStack.isEmpty();
    }

    public void setDeadProcess(boolean mark) {
        this.dead = mark;
    }

    public boolean isDeadProcess() {
        return this.dead;
    }

    public IInternalResult sendRequest(IStaticKey staticKey, IInternalMessage internalRequest) {
        return null;
    }

    public IInternalEventDirector getIInternalEventDirector() {
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

