/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.cc.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SerializationContext {
    protected PrintStream m_printStream;
    protected boolean m_bShouldIndent = true;
    protected int m_indentCount = 0;

    public SerializationContext(OutputStream iOutputStream) {
        try {
            this.m_printStream = new PrintStream(iOutputStream, false, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create PrintStream.");
        }
    }

    public void incrementIndent() {
        ++this.m_indentCount;
    }

    public void decrementIndent() {
        --this.m_indentCount;
    }

    public void startTag(String iTagName, HashMap iProperties, Object iValue) {
        this.print("<" + iTagName);
        if (iProperties != null) {
            Set props = iProperties.entrySet();
            Iterator entryIter = props.iterator();
            while (entryIter.hasNext()) {
                Map.Entry property = entryIter.next();
                this.print(" " + property.getKey() + "=" + "\"" + property.getValue() + "\"");
            }
        }
        this.println(">");
        this.incrementIndent();
        if (iValue != null) {
            this.println(iValue.toString());
        }
    }

    public void endTag(String iTagName) {
        this.decrementIndent();
        this.println("</" + iTagName + ">");
    }

    public void println(String iString) {
        if (this.m_bShouldIndent) {
            this.doIndent1();
        }
        this.m_printStream.println(iString);
        this.m_bShouldIndent = true;
    }

    protected void doIndent1() {
        for (int i = 0; i < this.m_indentCount; ++i) {
            this.m_printStream.print("    ");
        }
    }

    public void print(String iString) {
        if (this.m_bShouldIndent) {
            this.doIndent1();
            this.m_bShouldIndent = false;
        }
        this.m_printStream.print(iString);
    }

    public void startEndTag(String iTagName, String iValue) {
        this.startEndTag(iTagName, null, iValue);
    }

    public void startEndTag(String iTagName, HashMap iProperties, String iValue) {
        this.print("<" + iTagName);
        if (iProperties != null) {
            Set props = iProperties.entrySet();
            Iterator entryIter = props.iterator();
            while (entryIter.hasNext()) {
                Map.Entry property = entryIter.next();
                this.print(" " + property.getKey() + "=" + "\"" + property.getValue() + "\"");
            }
        }
        this.print(">");
        if (iValue != null) {
            this.print(iValue.toString());
        }
        this.println("</" + iTagName + ">");
    }

    public void startTag(String string) {
        this.startTag(string, null, null);
    }
}

