/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.client.impl.def;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.ode.bpe.cc.util.SerializationContext;
import org.apache.ode.bpe.client.IBPEMessage;
import org.apache.ode.bpe.client.impl.def.Message;
import org.apache.ode.bpe.client.result.IFaultResult;

public class FaultResult
implements IFaultResult {
    private String faultName;
    private String faultNamespace;
    private IBPEMessage faultMessage;

    public FaultResult(String faultName, String faultNamespace, IBPEMessage faultMessage) {
        this.faultName = faultName;
        this.faultNamespace = faultNamespace;
        this.faultMessage = faultMessage;
    }

    public IBPEMessage getFaultMessage() {
        return this.faultMessage;
    }

    public String getFaultName() {
        return this.faultName;
    }

    public String getFaultNamespace() {
        return this.faultNamespace;
    }

    public void dump(SerializationContext sc) {
        sc.startTag("FaultResult", null, null);
        sc.startEndTag("FaultNamespace", this.getFaultNamespace());
        sc.startEndTag("FaultName", this.getFaultName());
        Message message = (Message)this.getFaultMessage();
        message.dump(sc);
        sc.endTag("FaultResult");
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SerializationContext sc = new SerializationContext(baos);
        this.dump(sc);
        try {
            baos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toString();
    }
}

