/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.client.impl.def;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.ode.bpe.client.IBPEClient;
import org.apache.ode.bpe.client.IBPEMessage;
import org.apache.ode.bpe.client.IBPEMessagePart;
import org.apache.ode.bpe.client.IDescribedValue;
import org.apache.ode.bpe.client.IFormattableValue;
import org.apache.ode.bpe.client.IOperation;
import org.apache.ode.bpe.client.exceptions.BPEUserException;
import org.apache.ode.bpe.client.exceptions.SystemException;
import org.apache.ode.bpe.client.exceptions.TargetDefinitionPausedException;
import org.apache.ode.bpe.client.exceptions.TargetInstancePausedException;
import org.apache.ode.bpe.client.impl.IInternalMessage;
import org.apache.ode.bpe.client.impl.IInternalRequestConsumer;
import org.apache.ode.bpe.client.impl.IInternalResult;
import org.apache.ode.bpe.client.impl.def.BPEClientDefaultImpl;
import org.apache.ode.bpe.client.impl.def.ClientObject;
import org.apache.ode.bpe.client.impl.def.FaultResult;
import org.apache.ode.bpe.client.impl.def.InternalMessage;
import org.apache.ode.bpe.client.impl.def.Message;
import org.apache.ode.bpe.client.impl.def.Part;
import org.apache.ode.bpe.client.impl.def.SucessWithResponse;
import org.apache.ode.bpe.client.result.IResult;
import org.apache.ode.bpe.event.BPELStaticKey;

public class Operation
extends ClientObject
implements IOperation {
    private IInternalRequestConsumer requestConsumer;
    private Properties spec;

    public Operation(IBPEClient client, IInternalRequestConsumer requestConsumer, Properties spec) {
        super(client);
        this.requestConsumer = requestConsumer;
        this.spec = spec;
    }

    public IResult invoke(IBPEMessage request) throws BPEUserException {
        String operationName = this.spec.getProperty("operation");
        String portType = this.spec.getProperty("port.type");
        String portTypeNamespace = this.spec.getProperty("target.name.space");
        BPELStaticKey bpsk = new BPELStaticKey();
        bpsk.setOperation(operationName);
        bpsk.setPortType(portType);
        bpsk.setTargetNamespace(portTypeNamespace);
        IInternalMessage internalRequest = this.createInternalRequest(request);
        IInternalResult result = this.requestConsumer.sendRequest(bpsk, internalRequest);
        IResult clientResult = this.createClientResult(result);
        return clientResult;
    }

    protected IInternalMessage createInternalRequest(IBPEMessage request) {
        InternalMessage im = new InternalMessage();
        HashMap<String, IDescribedValue> internalParts = new HashMap<String, IDescribedValue>();
        Iterator iter = request.getParts().iterator();
        while (iter.hasNext()) {
            Part part = (Part)iter.next();
            internalParts.put(part.getName(), part.getDescribedValue());
        }
        im.setParts(internalParts);
        return im;
    }

    protected IResult createClientResult(IInternalResult internalResult) throws BPEUserException {
        IResult returnValue = null;
        switch (internalResult.getResultType()) {
            case 3: {
                returnValue = new SucessWithResponse(this.createResponseMessage(internalResult.getSuccessfulResponse()));
                break;
            }
            case 1: {
                IBPEMessage faultMessage = this.createResponseMessage(internalResult.getFaultMessage());
                returnValue = new FaultResult(internalResult.getFaultName(), internalResult.getFaultNamespace(), faultMessage);
                break;
            }
            case 100: {
                SystemException e = new SystemException(internalResult.getExceptionString());
                e.setStackTrace(internalResult.getExceptionStackTrace());
                e.setProperties(internalResult.getExceptionProperties());
                throw e;
            }
            case 106: {
                TargetDefinitionPausedException tdpe = new TargetDefinitionPausedException(internalResult.getID(), internalResult.getDefinitionName());
                tdpe.setStackTrace(internalResult.getExceptionStackTrace());
                throw tdpe;
            }
            case 105: {
                TargetInstancePausedException tipe = new TargetInstancePausedException(internalResult.getID());
                tipe.setStackTrace(internalResult.getExceptionStackTrace());
                throw tipe;
            }
        }
        return returnValue;
    }

    private IBPEMessage createResponseMessage(IInternalMessage message) {
        Message returnValue = (Message)this.getClient().createMessage();
        Iterator iter = message.getParts().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IFormattableValue fv = (IFormattableValue)entry.getValue();
            String name = (String)entry.getKey();
            IBPEMessagePart part = ((BPEClientDefaultImpl)this.getClient()).createPart(name, fv);
            returnValue.addPart(part);
        }
        return returnValue;
    }
}

