/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.base;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.context.IContextService;
import org.apache.ode.bpe.context.base.ContextServiceException;
import org.apache.ode.bpe.context.base.ContextTypeEnum;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.uuid.UUIDService;

public class ContextServiceFactory {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$context$base$ContextServiceFactory == null ? (class$org$apache$ode$bpe$context$base$ContextServiceFactory = ContextServiceFactory.class$("org.apache.ode.bpe.context.base.ContextServiceFactory")) : class$org$apache$ode$bpe$context$base$ContextServiceFactory).getName());
    static /* synthetic */ Class class$org$apache$ode$bpe$context$base$ContextServiceFactory;

    public static IContextService createContextService(BPEProperties props, UUIDService us) throws ContextServiceException {
        String persistence = props.getProperty("CTX_PERSISTENCE_KEY");
        if (persistence.equals("CTX_TRANSIENT")) {
            return ContextServiceFactory.createContextService(props, us, ContextTypeEnum.TRANSIENT);
        }
        return ContextServiceFactory.createContextService(props, us, ContextTypeEnum.PERSISTENT);
    }

    public static IContextService createContextService(BPEProperties props, UUIDService us, ContextTypeEnum type) throws ContextServiceException {
        IContextService cs = null;
        String className = null;
        try {
            if (type == ContextTypeEnum.TRANSIENT) {
                className = props.getTransientContextServiceClass();
            } else if (type == ContextTypeEnum.PERSISTENT) {
                className = props.getPersistentContextServiceClass();
            }
            Class<?> instClass = Class.forName(className);
            cs = (IContextService)instClass.newInstance();
            cs.init(props, us);
        }
        catch (ClassNotFoundException e) {
            ContextServiceException bpx = new ContextServiceException("CLASS_NOT_FOUND", new Object[]{className});
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (InstantiationException e) {
            ContextServiceException bpx = new ContextServiceException("NATIVE_EXCEPTION", new Object[]{"InstantiationException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (IllegalAccessException e) {
            ContextServiceException bpx = new ContextServiceException("NATIVE_EXCEPTION", new Object[]{"IllegalAccessException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        return cs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

