/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.base;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.context.IAccessControl;
import org.apache.ode.bpe.context.IContainer;
import org.apache.ode.bpe.context.IHandle;
import org.apache.ode.bpe.context.INode;
import org.apache.ode.bpe.context.IPart;
import org.apache.ode.bpe.context.base.ContextServiceException;
import org.apache.ode.bpe.context.base.ContextUtil;
import org.apache.ode.bpe.context.base.DataObject;

public abstract class SuperNode
implements INode,
Serializable,
IAccessControl {
    static final long serialVersionUID = -6214541427211735637L;
    private transient Object m_memento;
    private transient SuperNode m_parent = null;
    private transient int m_nodeType = 1;
    private transient HashMap m_childCollection = null;
    private transient String m_name = null;
    protected transient boolean m_isReadOnly = false;
    protected transient DataObject m_handle = null;
    public static final int PART = 1;
    public static final int CONTAINER = 2;
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$context$base$SuperNode == null ? (class$org$apache$ode$bpe$context$base$SuperNode = SuperNode.class$("org.apache.ode.bpe.context.base.SuperNode")) : class$org$apache$ode$bpe$context$base$SuperNode).getName());
    static /* synthetic */ Class class$org$apache$ode$bpe$context$base$SuperNode;

    protected SuperNode() {
    }

    protected SuperNode(String iName, SuperNode iContainer) throws ContextServiceException {
        this.init(iName, iContainer);
    }

    public void init(String iName, SuperNode iContainer) throws ContextServiceException {
        this.setName(iName);
        this.setContainer(iContainer);
    }

    protected void setContainer(SuperNode iContainer) throws ContextServiceException {
        if (iContainer != null) {
            INode child = iContainer.internalFindChild(this.getName());
            if (child != null && child != this) {
                iContainer.removeNode(this.getName());
            }
            iContainer.addChild(this);
        }
    }

    protected void detach() throws ContextServiceException {
        SuperNode container = (SuperNode)((Object)this.getContainer());
        if (container != null) {
            container.detachChildNode(this);
        }
    }

    protected void setName(String iName) throws ContextServiceException {
        this.m_name = iName;
    }

    public IContainer getContainer() {
        return (IContainer)((Object)this.m_parent);
    }

    public String getName() {
        return this.m_name;
    }

    protected void internalSetObject(Object iDataObject) throws ContextServiceException {
        DataObject newHandle = this.createHandle(iDataObject);
        this.setHandle(newHandle);
    }

    protected void internalSetObject(IHandle iObjectHandle) throws ContextServiceException {
        this.setHandle((DataObject)iObjectHandle);
    }

    protected Object internalGetObjectForRead() throws ContextServiceException {
        DataObject handle = this.getHandle();
        if (handle == null) {
            return null;
        }
        Object returnObject = handle.getObjectForRead();
        ContextUtil.setReadOnly(returnObject, true);
        return returnObject;
    }

    protected void cloneUponWrite() throws ContextServiceException {
        boolean weNeedToCloneDataObject;
        if (this.getHandle() == null) {
            return;
        }
        boolean bl = weNeedToCloneDataObject = this.getHandle().getRefCount() > 1L || this.getReadOnly();
        if (weNeedToCloneDataObject) {
            Object newDataObject = ContextUtil.cloneObject(this.getRawObjectForRead());
            this.internalSetObject(newDataObject);
            this.setReadOnly(false);
            this.setDirty(this);
        }
    }

    protected Object internalGetObjectClone() throws ContextServiceException {
        return ContextUtil.cloneObject(this.getRawObjectForRead());
    }

    protected Object internalGetObjectForReadWrite() throws ContextServiceException {
        this.cloneUponWrite();
        return this.getRawObjectForReadWrite();
    }

    protected DataObject getHandle() throws ContextServiceException {
        return this.m_handle;
    }

    protected DataObject getHandleForSerialization() {
        return this.m_handle;
    }

    protected void setHandleFromDeserialization(DataObject iHandle) {
        this.m_handle = iHandle;
    }

    protected Object getRawObjectForRead() throws ContextServiceException {
        return this.getHandle().getObjectForRead();
    }

    public Object getRawObjectForReadWrite() throws ContextServiceException {
        if (this.getHandle() == null) {
            return null;
        }
        Object rawObject = this.getHandle().getObjectForReadWrite();
        ContextUtil.setReadOnly(rawObject, false);
        return rawObject;
    }

    protected void setHandle(DataObject iHandle) throws ContextServiceException {
        if (this.m_handle != null) {
            this.getHandle().decrementRefCount();
        }
        this.m_handle = iHandle;
        if (this.m_handle != null) {
            this.m_handle.incrementRefCount();
        }
    }

    protected abstract DataObject createHandle(Object var1) throws ContextServiceException;

    protected abstract SuperNode createPartImpl() throws ContextServiceException;

    protected abstract SuperNode createContainerImpl() throws ContextServiceException;

    protected IContainer internalCreateContainer(String iContainerLocator) throws ContextServiceException {
        SuperNode ret = this.getChild(iContainerLocator);
        if (ret == null) {
            ret = this.createContainerImpl();
            ret.init(iContainerLocator, this);
        } else if (!(ret instanceof IContainer)) {
            ContextServiceException cse = new ContextServiceException("TYPE_CAST", new Object[]{"IContainer", "IPart"});
            cse.log(logger, Level.SEVERE);
            throw cse;
        }
        return (IContainer)((Object)ret);
    }

    protected IPart internalCreatePart(String iPartLocator) throws ContextServiceException {
        SuperNode ret = this.getChild(iPartLocator);
        if (ret == null) {
            ret = this.createPartImpl();
            ret.init(iPartLocator, this);
        } else if (!(ret instanceof IPart)) {
            ContextServiceException cse = new ContextServiceException("TYPE_CAST", new Object[]{"IContainer", "IPart"});
            cse.log(logger, Level.SEVERE);
            throw cse;
        }
        return (IPart)((Object)ret);
    }

    protected INode internalFindChild(String iChildLocator) throws ContextServiceException {
        return this.getChild(iChildLocator);
    }

    protected void internalRemoveChild(String iChildLocator) throws ContextServiceException {
        this.removeNode(iChildLocator);
    }

    protected void removeNotify() throws ContextServiceException {
        DataObject dataObject = this.getHandle();
        if (dataObject != null) {
            dataObject.decrementRefCount();
        }
        if (this.m_childCollection != null) {
            Iterator iterator = this.m_childCollection.values().iterator();
            while (iterator.hasNext()) {
                SuperNode sn = (SuperNode)iterator.next();
                sn.removeNotify();
            }
        }
    }

    protected void internalMoveNode(INode iSourceNode, String iTargetName) throws ContextServiceException {
        SuperNode aNode = (SuperNode)iSourceNode;
        aNode.detach();
        aNode.setName(iTargetName);
        aNode.setContainer(this);
    }

    protected void detachChildNode(SuperNode iChild) throws ContextServiceException {
        iChild.setContainer(null);
        this.getInternalChildCollection().remove(iChild.getName());
    }

    protected Collection internalGetChildren() throws ContextServiceException {
        return Collections.unmodifiableCollection(this.getInternalChildCollection().values());
    }

    protected void addChild(SuperNode iNode) throws ContextServiceException {
        this.getInternalChildCollection().put(iNode.getName(), iNode);
        iNode.setParent(this);
    }

    private void setParent(SuperNode iParent) {
        this.m_parent = iParent;
    }

    private SuperNode getChild(String iChildLocator) {
        if (this.m_childCollection != null) {
            return (SuperNode)this.m_childCollection.get(iChildLocator);
        }
        return null;
    }

    private void removeNode(String iChildLocator) throws ContextServiceException {
        SuperNode childNode = this.getChild(iChildLocator);
        if (childNode != null) {
            childNode.removeNotify();
        }
        this.getInternalChildCollection().remove(iChildLocator);
    }

    protected void internalCopyNode(INode iSourceNode, String iTargetName) throws ContextServiceException {
        SuperNode sourceNode = (SuperNode)iSourceNode;
        if (sourceNode instanceof IPart) {
            this.copyPart(sourceNode, iTargetName);
        } else {
            this.copyContainer(sourceNode, iTargetName);
        }
    }

    protected void copyPart(SuperNode iPart, String iTargetName) throws ContextServiceException {
        SuperNode newPart = this.createPartImpl();
        newPart.setName(iTargetName);
        SuperNode sourcePart = iPart;
        DataObject dataObject = sourcePart.getHandle();
        newPart.setHandle(dataObject);
        newPart.setContainer(this);
    }

    protected void copyContainer(SuperNode iContainer, String iTargetName) throws ContextServiceException {
        SuperNode newContainer = this.createContainerImpl();
        newContainer.setName(iTargetName);
        Iterator iterator = iContainer.internalGetChildren().iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            INode node = (INode)next;
            newContainer.internalCopyNode(node, node.getName());
        }
        newContainer.setContainer(this);
    }

    protected HashMap getInternalChildCollection() {
        if (this.m_childCollection == null) {
            this.m_childCollection = new HashMap();
        }
        return this.m_childCollection;
    }

    protected Collection getInternalChildCollectionForSerialization() {
        if (this.m_childCollection != null) {
            return this.m_childCollection.values();
        }
        return null;
    }

    public int getNodeType() {
        return this.m_nodeType;
    }

    protected void setNodeType(int iNodeType) throws ContextServiceException {
        this.m_nodeType = iNodeType;
    }

    protected void setDirty(SuperNode iNode) throws ContextServiceException {
    }

    public void setReadOnly(boolean iIsReadOnly) {
        this.m_isReadOnly = iIsReadOnly;
    }

    public boolean getReadOnly() {
        return this.m_isReadOnly;
    }

    public void setMemento(Object iMemento) {
        this.m_memento = iMemento;
    }

    public Object getMemento() {
        return this.m_memento;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

