/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.ejb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.ode.bpe.context.base.ContextServiceException;
import org.apache.ode.bpe.context.base.IDataObject;
import org.apache.ode.bpe.context.ejb.EJBDataObject;
import org.apache.ode.bpe.context.persistent.PersistentDataObjectFactory;

public abstract class EJBDataObjectFactoryBase
extends PersistentDataObjectFactory {
    private InitialContext m_ictx;
    private EJBLocalHome m_localHome;
    private HashMap m_localCache = new HashMap();
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$context$ejb$EJBDataObjectFactoryBase == null ? (class$org$apache$ode$bpe$context$ejb$EJBDataObjectFactoryBase = EJBDataObjectFactoryBase.class$("org.apache.ode.bpe.context.ejb.EJBDataObjectFactoryBase")) : class$org$apache$ode$bpe$context$ejb$EJBDataObjectFactoryBase).getName());
    static /* synthetic */ Class class$org$apache$ode$bpe$context$ejb$EJBDataObjectFactoryBase;

    public IDataObject create(Object iData) throws ContextServiceException {
        String aUUID = this.getUUID();
        IDataObject returnObject = this.createNewDataObject1(aUUID, iData);
        return returnObject;
    }

    protected abstract IDataObject createNewDataObject(String var1, EJBLocalObject var2) throws ContextServiceException;

    protected EJBLocalHome getLocalHome(String iJNDIName) throws ContextServiceException {
        if (this.m_localHome == null) {
            try {
                if (this.m_ictx == null) {
                    this.m_ictx = new InitialContext();
                }
                this.m_localHome = (EJBLocalHome)this.m_ictx.lookup(iJNDIName);
            }
            catch (NamingException e) {
                ContextServiceException cse = new ContextServiceException("JNDI_LOOKUP", new Object[]{iJNDIName}, e);
                cse.log(logger, Level.SEVERE);
                throw cse;
            }
        }
        return this.m_localHome;
    }

    protected EJBLocalObject createLocalObject(String id, Object obj) throws ContextServiceException {
        EJBLocalObject ret = null;
        try {
            ret = this.createNewLocalObject(id, obj);
        }
        catch (CreateException e) {
            ContextServiceException bpx = new ContextServiceException("NATIVE_EXCEPTION", new Object[]{"CreateException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        return ret;
    }

    public void remove(String iLocator) throws ContextServiceException {
        try {
            this.m_localCache.remove(iLocator);
            this.removeObject(iLocator);
        }
        catch (EJBException e) {
            ContextServiceException bpx = new ContextServiceException("NATIVE_EXCEPTION", new Object[]{"EJBException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (RemoveException e) {
            ContextServiceException bpx = new ContextServiceException("NATIVE_EXCEPTION", new Object[]{"RemoveException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
    }

    public IDataObject create(String iLocator, Object iData) throws ContextServiceException {
        IDataObject returnObject = this.find(iLocator);
        if (returnObject != null) {
            returnObject.setObject(iData);
        } else {
            returnObject = this.createNewDataObject1(iLocator, iData);
        }
        return returnObject;
    }

    protected IDataObject createNewDataObject1(String iLocator, Object iData) throws ContextServiceException {
        EJBLocalObject objectLocal = this.createLocalObject(iLocator, iData);
        IDataObject newDataObject = this.createNewDataObject(iLocator, objectLocal);
        this.m_localCache.put(iLocator, newDataObject);
        return newDataObject;
    }

    protected void flush() throws ContextServiceException {
        Iterator iter = this.m_localCache.values().iterator();
        while (iter.hasNext()) {
            EJBDataObject ejbdo = (EJBDataObject)iter.next();
            ejbdo.flush();
        }
    }

    public IDataObject find(String iLocator) throws ContextServiceException {
        Object foundObject = this.m_localCache.get(iLocator);
        if (foundObject != null) {
            return (IDataObject)foundObject;
        }
        EJBLocalObject objectLocal = null;
        try {
            objectLocal = this.findObject(iLocator);
            IDataObject newDataObject = this.createNewDataObject(iLocator, objectLocal);
            this.m_localCache.put(iLocator, newDataObject);
        }
        catch (FinderException e) {
            return null;
        }
        return this.createNewDataObject(iLocator, objectLocal);
    }

    protected abstract EJBLocalObject createNewLocalObject(String var1, Object var2) throws CreateException, ContextServiceException;

    protected abstract void removeObject(String var1) throws RemoveException, ContextServiceException;

    protected abstract EJBLocalObject findObject(String var1) throws ContextServiceException, FinderException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

