/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.ejb.test.performance;

import java.io.PrintStream;
import javax.transaction.UserTransaction;

public abstract class TimedTest {
    private String m_name = "noName";
    private long m_iterations = 0L;
    private long m_currentIteration = 0L;
    private long m_startTime = 0L;
    private long m_endTime = 0L;
    private long m_totalTimeMillis;
    private double m_totalTimeSeconds;
    private double m_iterationsPerSecond;
    private boolean m_exceptionOccurred = false;
    private Exception m_exception;
    private PrintStream m_ps = null;
    protected UserTransaction m_userTransaction = null;

    TimedTest() {
    }

    public void init() throws Exception {
    }

    TimedTest(String iName, long iIterations) {
        this.m_name = iName;
        this.m_iterations = iIterations;
        this.m_currentIteration = 0L;
    }

    public void setIterations(long iIterations) {
        this.m_iterations = iIterations;
    }

    public void setTransaction(UserTransaction iUserTransaction) {
        this.m_userTransaction = iUserTransaction;
    }

    public void setName(String iName) {
        this.m_name = iName;
    }

    public void printResults(PrintStream oStream) {
        this.m_ps = oStream;
        this.println("****************************" + this.m_name + " run complete.");
        this.println("Iterations = " + this.m_iterations);
        this.println("Total time in milliseconds  = " + this.m_totalTimeMillis);
        this.println("Total time in seconds = " + this.m_totalTimeSeconds);
        this.println("Iterations/second = " + this.m_iterationsPerSecond);
        if (this.m_exceptionOccurred) {
            this.println("An exception occured during iteration:" + this.m_currentIteration + ":" + this.m_exception.toString());
            this.m_exception.printStackTrace(this.m_ps);
        }
    }

    protected void println(String iValue) {
        this.m_ps.println(iValue);
    }

    public void run() throws Exception {
        this.m_exceptionOccurred = false;
        this.m_startTime = System.currentTimeMillis();
        try {
            this.m_currentIteration = 1L;
            while (this.m_currentIteration <= this.m_iterations) {
                this.runIteration();
                ++this.m_currentIteration;
            }
        }
        catch (Exception e) {
            this.m_exceptionOccurred = true;
            this.m_exception = e;
            throw e;
        }
        this.m_endTime = System.currentTimeMillis();
        this.m_totalTimeMillis = this.m_endTime - this.m_startTime;
        this.m_totalTimeSeconds = (double)this.m_totalTimeMillis / 1000.0;
        this.m_iterationsPerSecond = (double)this.m_iterations / this.m_totalTimeSeconds;
    }

    protected abstract void runIteration() throws Exception;
}

