/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.persistent;

import org.apache.ode.bpe.context.IContainer;
import org.apache.ode.bpe.context.IHandle;
import org.apache.ode.bpe.context.base.ContextService;
import org.apache.ode.bpe.context.base.ContextServiceException;
import org.apache.ode.bpe.context.base.IDataObject;
import org.apache.ode.bpe.context.base.IDataObjectFactory;
import org.apache.ode.bpe.context.ejb.EJBDataObjectFactory;
import org.apache.ode.bpe.context.nonpersistent.TransientDataObjectFactory;
import org.apache.ode.bpe.context.persistent.PersistentDataObject;
import org.apache.ode.bpe.context.persistent.PersistentDataObjectFactory;
import org.apache.ode.bpe.context.persistent.PersistentRootContainer;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.uuid.UUIDService;

public class PersistentContextService
extends ContextService {
    private UUIDService m_us;
    private PersistentRootContainer m_root;
    private IDataObjectFactory m_globalDataObjectFactory = null;
    private IDataObjectFactory m_localDataObjectFactory = null;
    private EJBDataObjectFactory m_persistentDataObjectFactory = null;
    private TransientDataObjectFactory m_transientDataObjectFactory = null;
    private BPEProperties m_props = new BPEProperties();

    public IHandle createObjectHandle(Object iObject) throws ContextServiceException {
        return (IHandle)((Object)this.createGlobalDataObject(iObject));
    }

    public void init(BPEProperties props, UUIDService us) {
        this.m_us = us;
        this.m_props = props;
    }

    public IContainer getRoot() throws ContextServiceException {
        if (this.m_root == null) {
            this.m_root = new PersistentRootContainer(this);
        }
        return this.m_root;
    }

    protected IDataObject findPersistentDataObject(String iLocator) throws ContextServiceException {
        IDataObject returnObject = this.getPersistentDataObjectFactory().find(iLocator);
        return returnObject;
    }

    protected IDataObject createPersistentDataObject(String iName, Object iObject) throws ContextServiceException {
        IDataObject newObject = this.getPersistentDataObjectFactory().create(iName, iObject);
        return (PersistentDataObject)newObject;
    }

    protected IDataObject createLocalDataObject(Object iObject) throws ContextServiceException {
        IDataObject newObject = this.getLocalDataObjectFactory().create(iObject);
        return newObject;
    }

    protected IDataObject createGlobalDataObject(Object iObject) throws ContextServiceException {
        IDataObject newObject = this.getGlobalDataObjectFactory().create(iObject);
        return newObject;
    }

    protected void removePersistentDataObject(String iLocator) throws ContextServiceException {
        this.getPersistentDataObjectFactory().remove(iLocator);
    }

    private IDataObjectFactory getLocalDataObjectFactory() throws ContextServiceException {
        if (this.m_localDataObjectFactory == null) {
            String granularity = this.m_props.getProperty("CTX_PERSISTENCE_GRANULARITY_KEY");
            this.m_localDataObjectFactory = granularity != null && granularity.equals("CTX_FINE") ? this.getPersistentDataObjectFactory() : this.getTransientDataObjectFactory();
        }
        return this.m_localDataObjectFactory;
    }

    private IDataObjectFactory getGlobalDataObjectFactory() throws ContextServiceException {
        if (this.m_globalDataObjectFactory == null) {
            this.m_globalDataObjectFactory = this.m_props.getProperty("CTX_PERSISTENCE_GRANULARITY_KEY").equals("CTX_MONOLITHIC") ? this.getTransientDataObjectFactory() : this.getPersistentDataObjectFactory();
        }
        return this.m_globalDataObjectFactory;
    }

    private IDataObjectFactory getPersistentDataObjectFactory() throws ContextServiceException {
        if (this.m_persistentDataObjectFactory == null) {
            this.m_persistentDataObjectFactory = new EJBDataObjectFactory();
            this.m_persistentDataObjectFactory.init(this.m_props, this.m_us);
        }
        return this.m_persistentDataObjectFactory;
    }

    private IDataObjectFactory getTransientDataObjectFactory() throws ContextServiceException {
        if (this.m_transientDataObjectFactory == null) {
            this.m_transientDataObjectFactory = new TransientDataObjectFactory();
            this.m_transientDataObjectFactory.init(this.m_props, this.m_us);
        }
        return this.m_transientDataObjectFactory;
    }

    public void flush() throws ContextServiceException {
        PersistentDataObjectFactory pdoFactory = (PersistentDataObjectFactory)this.getPersistentDataObjectFactory();
        pdoFactory.flush();
    }
}

