/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.resolver;

import org.apache.ode.bpe.context.INode;
import org.apache.ode.bpe.context.IPart;
import org.apache.ode.bpe.context.base.ContextServiceException;
import org.apache.ode.bpe.context.resolver.IResolvedObject;
import org.apache.ode.bpe.interaction.IInteraction;
import org.apache.ode.bpe.interaction.IInvocation;
import org.apache.ode.bpe.interaction.builders.IInteractionBuilder;
import org.apache.ode.bpe.util.BPException;

public class ContextResolvedObject
implements IResolvedObject {
    private String name;
    private Object iObj;
    private Object dataValue;
    private int type;
    private IPart part;
    private IInvocation invocation;
    private IInteractionBuilder iFactory;

    public ContextResolvedObject(String name, Object value, Object iObj, int type, IPart part, IInvocation invocation, IInteractionBuilder builder) {
        this.name = name;
        this.dataValue = value;
        this.iObj = iObj;
        this.type = type;
        this.part = part;
        this.invocation = invocation;
        this.iFactory = builder;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.dataValue;
    }

    public int getType() {
        return this.type;
    }

    public void setObject(Object obj) throws BPException {
        if (this.iObj == null && this.iFactory != null && this.invocation != null) {
            this.iObj = this.iFactory.createInteraction();
            this.part.setObject(this.iObj);
        }
        if (this.iObj instanceof IInteraction && this.invocation != null) {
            ((IInteraction)this.iObj).invoke(this.invocation, obj);
        } else {
            this.part.setObject(obj);
        }
    }

    public INode getContextNode() {
        return this.part;
    }

    public Object getObjectForUpdate() throws BPException {
        return this.part.getObjectForReadWrite();
    }

    public void copyContextNode(INode iSourceNode) throws ContextServiceException {
        this.part.getContainer().copyNode(iSourceNode, this.part.getName());
    }

    public IInteractionBuilder getInteractionFactory() {
        return this.iFactory;
    }
}

