/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.test;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.LogManager;
import org.apache.ode.bpe.context.IContainer;
import org.apache.ode.bpe.context.IContextService;
import org.apache.ode.bpe.context.INode;
import org.apache.ode.bpe.context.IPart;
import org.apache.ode.bpe.context.base.TestUtil;

public class SerializationContext {
    private long m_indent = 0L;
    private PrintStream m_printStream = null;
    private static String BPE_SERIALIZATION_CONTEXT = "bpe.serialization.context";
    private boolean enabled = Boolean.valueOf(LogManager.getLogManager().getProperty(BPE_SERIALIZATION_CONTEXT));

    public SerializationContext(OutputStream oOutputStream) {
        this.m_printStream = new PrintStream(oOutputStream);
    }

    public void printBytes(byte[] iBytes) {
        if (!this.enabled) {
            return;
        }
        int position = 0;
        char[] line = new char[80];
        while (position < iBytes.length) {
            byte currentByte = iBytes[position];
            int currentChar = currentByte;
            if (!Character.isLetterOrDigit((char)currentChar)) {
                currentChar = 46;
            }
            line[position % 80] = currentChar;
            if (++position % 80 != 0) continue;
            this.m_printStream.println(line);
        }
        this.m_printStream.println(line);
    }

    public void serialize(IContextService iService) throws Exception {
        if (!this.enabled) {
            return;
        }
        this.println("Context Service hashcode: " + iService.hashCode());
        this.writeContainer(iService.getRoot());
    }

    private void writePart(IPart iPart) throws Exception {
        this.println("<" + iPart.getName() + ">");
        this.incrementIndent();
        Object obj = iPart.getObjectForRead();
        this.println("" + iPart.getObjectForRead());
        if (obj != null) {
            this.println("RawObject hash code = " + obj.hashCode());
            this.println("RawObject type = " + obj.getClass().getName());
        }
        this.println("RefCount = " + TestUtil.getRefCount(iPart));
        this.println("DataObjectImpl = " + TestUtil.getDataObjectImp(iPart));
        this.println("DataObjectID = " + TestUtil.getDataObjectID(iPart));
        this.decrementIndent();
        this.println("</" + iPart.getName() + ">");
    }

    private void writeContainer(IContainer iContainer) throws Exception {
        this.println("<" + iContainer.getName() + ">");
        this.incrementIndent();
        this.println("Container hash code = " + iContainer.hashCode());
        Collection children = iContainer.getChildren();
        if (children != null) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                INode node = (INode)iter.next();
                if (node instanceof IContainer) {
                    this.writeContainer((IContainer)node);
                    continue;
                }
                this.writePart((IPart)node);
            }
        }
        this.decrementIndent();
        this.println("</" + iContainer.getName() + ">");
    }

    public void printComment(String iValue) {
        if (!this.enabled) {
            return;
        }
        this.doIndent();
        this.m_printStream.println("\n" + iValue + "\n");
    }

    public void println(String iValue) {
        if (!this.enabled) {
            return;
        }
        this.doIndent();
        this.m_printStream.println(iValue);
    }

    public void print(String iValue) {
        if (!this.enabled) {
            return;
        }
        this.m_printStream.print(iValue);
    }

    private void incrementIndent() {
        ++this.m_indent;
    }

    private void decrementIndent() {
        --this.m_indent;
    }

    private void doIndent() {
        int i = 0;
        while ((long)i < this.m_indent) {
            this.m_printStream.print("     ");
            ++i;
        }
    }
}

