/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.correlation.unmanaged;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.ode.bpe.correlation.CorrelationService;
import org.apache.ode.bpe.correlation.CorrelationServiceException;
import org.apache.ode.bpe.correlation.Registration;
import org.apache.ode.bpe.engine.ProcessService;
import org.apache.ode.bpe.event.IStaticKey;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;

public class CorrelationServiceSLImpl
extends CorrelationService {
    private ProcessService ps;
    private boolean isBPELCompliant;
    private HashMap hashByStaticKey = new HashMap();
    private HashMap hashByStatcKeyandKeyValue = new HashMap();
    private HashMap hashByStaticKeyandOperationIdandProcId = new HashMap();
    private HashMap hashByProcId = new HashMap();

    public synchronized void createRegistration(Registration regisration) throws CorrelationServiceException {
        HashMap<String, Registration> procsHash;
        String key = regisration.getStaticKeyValue();
        ArrayList<Registration> regs = (ArrayList<Registration>)this.hashByStaticKey.get(key);
        if (regs == null) {
            regs = new ArrayList<Registration>();
            this.hashByStaticKey.put(key, regs);
        }
        regs.add(regisration);
        String keyValue = regisration.getKeyValue();
        if (keyValue != null) {
            HashMap<String, ArrayList<Registration>> keyHash = (HashMap<String, ArrayList<Registration>>)this.hashByStatcKeyandKeyValue.get(key);
            if (keyHash == null) {
                keyHash = new HashMap<String, ArrayList<Registration>>();
                this.hashByStatcKeyandKeyValue.put(key, keyHash);
            }
            if ((regs = (ArrayList<Registration>)keyHash.get(keyValue)) == null) {
                regs = new ArrayList<Registration>();
                keyHash.put(keyValue, regs);
            }
            regs.add(regisration);
        }
        String opId = regisration.getOperationId();
        String procId = regisration.getRootProcId();
        HashMap<String, HashMap<String, Registration>> opHash = (HashMap<String, HashMap<String, Registration>>)this.hashByStaticKeyandOperationIdandProcId.get(key);
        if (opHash == null) {
            opHash = new HashMap<String, HashMap<String, Registration>>();
            this.hashByStaticKeyandOperationIdandProcId.put(key, opHash);
        }
        if ((procsHash = (HashMap<String, Registration>)opHash.get(opId)) == null) {
            procsHash = new HashMap<String, Registration>();
            opHash.put(opId, procsHash);
        }
        procsHash.put(procId, regisration);
        ArrayList<Registration> regList = (ArrayList<Registration>)this.hashByProcId.get(procId);
        if (regList == null) {
            regList = new ArrayList<Registration>();
            this.hashByProcId.put(procId, regList);
        }
        regList.add(regisration);
    }

    public synchronized Collection getRegistrations(IPMIProcess key) throws CorrelationServiceException {
        return (ArrayList)this.hashByProcId.get(key.getKey());
    }

    public synchronized Collection getRegistrations(IStaticKey key, Collection keyValues) throws CorrelationServiceException {
        ArrayList regs = new ArrayList();
        HashMap keyHash = (HashMap)this.hashByStatcKeyandKeyValue.get(((Object)key).toString());
        ArrayList keyList = (ArrayList)this.hashByStaticKey.get(((Object)key).toString());
        if (keyHash != null || keyList != null) {
            Iterator it = keyValues.iterator();
            while (it.hasNext()) {
                String keyValue = (String)it.next();
                if (keyValue != null) {
                    ArrayList regsSublist;
                    if (keyHash == null || (regsSublist = (ArrayList)keyHash.get(keyValue)) == null || regs.containsAll(regsSublist)) continue;
                    regs.addAll(regsSublist);
                    continue;
                }
                if (keyList == null || regs.containsAll(keyList)) continue;
                regs.addAll(keyList);
            }
        }
        return regs;
    }

    public synchronized Collection getRegistrations(IStaticKey key) throws CorrelationServiceException {
        ArrayList regs = (ArrayList)this.hashByStaticKey.get(((Object)key).toString());
        if (regs == null) {
            return new ArrayList();
        }
        return regs;
    }

    public void update() throws BPException {
    }

    public void init(BPEProperties props, ProcessService ps) throws CorrelationServiceException {
        this.ps = ps;
        if (props.getBPELCompliant().equals("TRUE")) {
            this.isBPELCompliant = true;
        }
    }

    public ProcessService getProcessService() throws BPException {
        return this.ps;
    }

    public boolean isBPELCompliant() {
        return this.isBPELCompliant;
    }

    public synchronized Registration getRegistration(IStaticKey key, String operationId, String processId) throws CorrelationServiceException {
        HashMap opHash = (HashMap)this.hashByStaticKeyandOperationIdandProcId.get(((Object)key).toString());
        if (opHash == null) {
            return null;
        }
        HashMap procsHash = (HashMap)opHash.get(operationId);
        if (procsHash == null) {
            return null;
        }
        return (Registration)procsHash.get(processId);
    }

    public synchronized void removeRegistration(Registration registration) throws CorrelationServiceException {
        String key = registration.getStaticKeyValue();
        ArrayList regs = (ArrayList)this.hashByStaticKey.get(key);
        if (regs != null) {
            regs.remove(registration);
        }
        String keyValue = registration.getKeyValue();
        HashMap keyHash = (HashMap)this.hashByStatcKeyandKeyValue.get(key);
        if (keyHash != null) {
            regs = (ArrayList)keyHash.get(keyValue);
        }
        if (regs != null) {
            regs.remove(registration);
        }
        String opId = registration.getOperationId();
        String procId = registration.getRootProcId();
        HashMap procsHash = null;
        HashMap opHash = (HashMap)this.hashByStaticKeyandOperationIdandProcId.get(key);
        if (opHash != null) {
            procsHash = (HashMap)opHash.get(opId);
        }
        if (procsHash != null) {
            procsHash.remove(procId);
        }
        if ((regs = (ArrayList)this.hashByProcId.get(procId)) != null) {
            regs.remove(registration);
        }
    }
}

