/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.definition.service.managed;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.ode.bpe.bped.EventDirectorFactory;
import org.apache.ode.bpe.bped.IInternalEventDirector;
import org.apache.ode.bpe.client.DescribedValue;
import org.apache.ode.bpe.client.formats.INativeFormat;
import org.apache.ode.bpe.client.spi.interaction.ISPIInteraction;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.deployment.DefinitionKey;
import org.apache.ode.bpe.deployment.ResourceDeployer;
import org.apache.ode.bpe.deployment.bpel.BPELDeploy;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.engine.ProcessService;
import org.apache.ode.bpe.event.BPELStaticKey;
import org.apache.ode.bpe.event.LoadDefinitionEvent;
import org.apache.ode.bpe.event.SimpleRequestMessageEvent;
import org.apache.ode.bpe.info.PackageInfo;
import org.apache.ode.bpe.info.PackageInfoHome;
import org.apache.ode.bpe.interaction.spiadapter.SPIAdapterInteraction;
import org.apache.ode.bpe.interaction.spiimpl.MasterInteractionFactory;
import org.apache.ode.bpe.lang.ResourceGetter;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;

public class ProcessDefinitionBean
implements SessionBean {
    static final long serialVersionUID = 8156751383598063747L;
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$definition$service$managed$ProcessDefinitionBean == null ? (class$org$apache$ode$bpe$definition$service$managed$ProcessDefinitionBean = ProcessDefinitionBean.class$("org.apache.ode.bpe.definition.service.managed.ProcessDefinitionBean")) : class$org$apache$ode$bpe$definition$service$managed$ProcessDefinitionBean).getName());
    private DefinitionService ds;
    private IInternalEventDirector ed;
    private static String[] BPETABLES = new String[]{"{0}_BPE_CMPBLOB", "{0}_EngineStateCoarse", "{0}_RegistrationEntity"};
    private static String DROP_TABLE = "DROP TABLE ";
    private static final String DATASOURCE = "java:comp/env/jdbc/theDB";
    private static final String PKG_INFO = "java:comp/env/thePackageInfo";
    private static final String TABLE_PREFIX = "TABLE_PREFIX";
    static /* synthetic */ Class class$org$apache$ode$bpe$definition$service$managed$ProcessDefinitionBean;

    public void undeploy() {
        Connection conn = null;
        Statement stmt = null;
        try {
            InitialContext context = new InitialContext();
            PackageInfoHome pih = (PackageInfoHome)context.lookup(PKG_INFO);
            PackageInfo pi = pih.create();
            String pkgName = pi.getProperties().getProperty(TABLE_PREFIX);
            DataSource datasource = (DataSource)context.lookup(DATASOURCE);
            conn = datasource.getConnection();
            stmt = conn.createStatement();
            for (int i = 0; i < BPETABLES.length; ++i) {
                String table = ResourceGetter.getFormatted(BPETABLES[i], new Object[]{pkgName});
                stmt.execute(DROP_TABLE + table);
            }
        }
        catch (Exception e) {
            throw new EJBException(e.getLocalizedMessage(), e);
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException se) {
                // empty catch block
            }
            stmt = null;
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            conn = null;
        }
    }

    public void fireBootstrap() {
        try {
            BPELStaticKey bsk = new BPELStaticKey();
            bsk.setTargetNamespace("urn:com:sybase:uo:deployService");
            bsk.setPortType("deployServicePT");
            bsk.setOperation("deploy");
            SimpleRequestMessageEvent msgEvent = new SimpleRequestMessageEvent();
            msgEvent.setStaticKey(bsk);
            DescribedValue dv = new DescribedValue("", INativeFormat.ATOMIC, new Properties());
            ISPIInteraction spi = MasterInteractionFactory.newInstance().createInteraction(dv);
            SPIAdapterInteraction spiai = new SPIAdapterInteraction(spi);
            msgEvent.setPart("location", spiai);
            this.ed.sendEvent(msgEvent, true);
        }
        catch (Exception e) {
            throw new EJBException(e.getLocalizedMessage(), e);
        }
    }

    public Collection deploy(String resource, boolean validating, String schemaPath) {
        try {
            ResourceDeployer rd = new ResourceDeployer(new BPELDeploy(this.ds));
            Collection keys = rd.deployResource(resource, validating, schemaPath);
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                DefinitionKey defkey = (DefinitionKey)it.next();
                IPMDRoot rootDef = this.ds.getRootDefinition(new ProcessDefinitionKey(defkey.getKey()));
                this.ed.sendEvent(new LoadDefinitionEvent(rootDef.getProcess().getKey().getValue()), true);
            }
            return keys;
        }
        catch (Exception e) {
            throw new EJBException(e.getLocalizedMessage(), e);
        }
    }

    public Collection deploy(byte[] buff, boolean validating, String schemaPath) {
        Collection keys = null;
        ByteArrayInputStream is = new ByteArrayInputStream(buff);
        BPELDeploy deployer = new BPELDeploy(this.ds);
        try {
            keys = deployer.deployJar(is, validating, null);
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                DefinitionKey defkey = (DefinitionKey)it.next();
                IPMDRoot rootDef = this.ds.getRootDefinition(new ProcessDefinitionKey(defkey.getKey()));
                this.ed.sendEvent(new LoadDefinitionEvent(rootDef.getProcess().getKey().getValue()), true);
            }
        }
        catch (DeploymentException e) {
            logger.log(Level.SEVERE, "", e);
        }
        catch (DefinitionServiceException e) {
            logger.log(Level.SEVERE, "", e);
        }
        catch (BPException e) {
            logger.log(Level.SEVERE, "", e);
        }
        return keys;
    }

    public void removeDefinition(String id) {
        try {
            this.ds.deleteDefinition(new ProcessDefinitionKey(id));
        }
        catch (BPException e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public void setStateless(String id) {
        try {
            IPMDRoot root = this.ds.getRootDefinition(new ProcessDefinitionKey(id));
            root.setIsStateless(true);
        }
        catch (BPException e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public void ejbCreate() {
        try {
            InitialContext context = new InitialContext();
            BPEProperties p = new BPEProperties(true, context);
            this.ed = (IInternalEventDirector)((Object)EventDirectorFactory.createEventDirector(p));
            ProcessService ps = this.ed.getProcessService();
            this.ds = ps.getInstanceService().getDefinitionService();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "", ex);
        }
    }

    public void setSessionContext(SessionContext ctx) {
    }

    public void ejbRemove() {
        this.ed.release();
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbLoad() {
    }

    public void ejbStore() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

