/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.definition.service.unmanaged;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.ode.bpe.context.ejb.BPE_ObjectLocal;
import org.apache.ode.bpe.context.ejb.BPE_ObjectLocalHome;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.serialimpl.PMDOperation_SerialImpl;
import org.apache.ode.bpe.definition.service.DefinitionNotFoundException;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.definition.service.unmanaged.DefinitionServiceBase;
import org.apache.ode.bpe.definition.service.unmanaged.DefinitionStateEnum;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.event.IStaticKey;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;
import org.apache.ode.bpe.uuid.UUIDService;

public class PersistentDefinitionService
extends DefinitionServiceBase {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$definition$service$unmanaged$PersistentDefinitionService == null ? (class$org$apache$ode$bpe$definition$service$unmanaged$PersistentDefinitionService = PersistentDefinitionService.class$("org.apache.ode.bpe.definition.service.unmanaged.PersistentDefinitionService")) : class$org$apache$ode$bpe$definition$service$unmanaged$PersistentDefinitionService).getName());
    private boolean prepared = false;
    private static final String JNDI_BLOB_NAME = "java:comp/env/theCMPObjectBean";
    private static final String DEF_REGS_BLOB_NAME = "instanceCreatingRegistrations";
    private static final String NON_INST_BLOB_NAME = "metaNonInstanceCreatingOperations";
    private BPE_ObjectLocal regsBlob;
    private BPE_ObjectLocal nonInstBlob;
    static /* synthetic */ Class class$org$apache$ode$bpe$definition$service$unmanaged$PersistentDefinitionService;

    public void init(BPEProperties props, UUIDService us) {
        super.init(props, us);
        try {
            InitialContext ic = new InitialContext();
            BPE_ObjectLocalHome blobHome = (BPE_ObjectLocalHome)ic.lookup(JNDI_BLOB_NAME);
            try {
                this.regsBlob = blobHome.findByPrimaryKey(DEF_REGS_BLOB_NAME);
            }
            catch (FinderException e1) {
                this.regsBlob = blobHome.create(DEF_REGS_BLOB_NAME, this.defRegistrations);
            }
            catch (EJBException e2) {
                logger.log(Level.SEVERE, "", e2);
            }
            try {
                this.nonInstBlob = blobHome.findByPrimaryKey(NON_INST_BLOB_NAME);
            }
            catch (FinderException e1) {
                this.nonInstBlob = blobHome.create(NON_INST_BLOB_NAME, this.metaNonInstanceCreatingOperations);
            }
            catch (EJBException e2) {
                logger.log(Level.SEVERE, "", e2);
            }
        }
        catch (NamingException e) {
            logger.log(Level.SEVERE, "", e);
        }
        catch (CreateException e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public IPMDRoot createRootDefinition(String label, String version, boolean isStateless) throws BPException {
        this.refreshCachedMetadata();
        IPMDRoot retVal = super.createRootDefinition(label, version, isStateless);
        this.persistCachedMetadata();
        return retVal;
    }

    public void loadDefintion(ProcessDefinitionKey procKey, IProcessCallBack pcb) throws BPException {
        this.refreshCachedMetadata();
        super.loadDefintion(procKey, pcb);
        this.persistCachedMetadata();
    }

    public void deleteDefinition(ProcessDefinitionKey rootKey) throws BPException {
        this.refreshCachedMetadata();
        super.deleteDefinition(rootKey);
        try {
            BPE_ObjectLocal blobProxy = this.getBlob(rootKey.getValue());
            if (blobProxy != null) {
                blobProxy.remove();
            }
        }
        catch (RemoveException re) {
            DefinitionServiceException bpx = new DefinitionServiceException("NATIVE_EXCEPTION", new Object[]{"RemoveException"}, re);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        this.persistCachedMetadata();
    }

    public Collection getCorrelations(IStaticKey key) throws BPException {
        if (this.shouldRefreshCache()) {
            this.refreshCachedMetadata();
        }
        return super.getCorrelations(key);
    }

    public IPMDRoot getRootDefinition(ProcessDefinitionKey definitionKey) throws BPException {
        IPMDRoot root = this.getDefinitionFromCache(definitionKey);
        if (root == null) {
            BPE_ObjectLocalHome blobHome = null;
            try {
                InitialContext ic = new InitialContext();
                blobHome = (BPE_ObjectLocalHome)ic.lookup(JNDI_BLOB_NAME);
            }
            catch (NamingException ne) {
                DefinitionServiceException bpx = new DefinitionServiceException("NATIVE_EXCEPTION", new Object[]{"NamingException"}, ne);
                bpx.log(logger, Level.SEVERE);
                throw bpx;
            }
            try {
                BPE_ObjectLocal blobProxy = blobHome.findByPrimaryKey(definitionKey.getValue());
                root = (IPMDRoot)blobProxy.getObjectForRead();
                this.addDefinitionToCache(definitionKey, root);
            }
            catch (FinderException fe) {
                root = null;
            }
        }
        return root;
    }

    public void prepare() throws BPException {
        if (this.shouldRefreshCache()) {
            this.refreshCachedMetadata();
            this.prepared = true;
        }
    }

    public Collection getRootDefinitions() throws BPException {
        if (this.shouldRefreshCache()) {
            this.refreshCachedMetadata();
        }
        return super.getRootDefinitions();
    }

    public void deactivateDefinition(String id) throws BPException {
        this.setDefinitionState(id, DefinitionStateEnum.INACTIVE);
    }

    public void activateDefinition(String id) throws BPException {
        this.setDefinitionState(id, DefinitionStateEnum.ACTIVE);
    }

    public void update() throws BPException {
        this.persistCachedMetadata();
    }

    protected void persistCachedOperations() {
        this.regsBlob.setObject(this.defRegistrations);
        this.nonInstBlob.setObject(this.metaNonInstanceCreatingOperations);
    }

    protected void deleteOperations(IPMDRoot root) throws BPException {
        super.deleteOperations(root);
        this.persistCachedOperations();
    }

    private BPE_ObjectLocal getBlob(String blobID) throws DefinitionServiceException {
        BPE_ObjectLocalHome blobHome = null;
        try {
            InitialContext ic = new InitialContext();
            blobHome = (BPE_ObjectLocalHome)ic.lookup(JNDI_BLOB_NAME);
            BPE_ObjectLocal blobProxy = blobHome.findByPrimaryKey(blobID);
            return blobProxy;
        }
        catch (NamingException ne) {
            DefinitionServiceException bpx = new DefinitionServiceException("NATIVE_EXCEPTION", new Object[]{"NamingException"}, ne);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (FinderException e) {
            return null;
        }
    }

    private void persistCachedMetadata() throws BPException {
        this.persistNewDefinitions();
        this.persistCachedOperations();
    }

    private void persistNewDefinitions() throws BPException {
        try {
            InitialContext ic = new InitialContext();
            BPE_ObjectLocalHome blobHome = (BPE_ObjectLocalHome)ic.lookup(JNDI_BLOB_NAME);
            Enumeration e = this.getNewDefinitionsCache();
            while (e.hasMoreElements()) {
                IPMDRoot rbi = (IPMDRoot)e.nextElement();
                blobHome.create(rbi.getProcess().getKey().getValue(), rbi);
            }
            this.regsBlob.setObject(this.defRegistrations);
            this.nonInstBlob.setObject(this.metaNonInstanceCreatingOperations);
            this.clearNewDefinitionsCache();
        }
        catch (NamingException e) {
            DefinitionServiceException bpx = new DefinitionServiceException("NATIVE_EXCEPTION", new Object[]{"NamingException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (CreateException e) {
            DefinitionServiceException bpx = new DefinitionServiceException("NATIVE_EXCEPTION", new Object[]{"CreateException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
    }

    private void refreshCachedMetadata() throws BPException {
        this.refreshCachedOperations();
        this.refreshCachedDefinitions();
    }

    private boolean shouldRefreshCache() {
        return !this.prepared;
    }

    private void refreshCachedDefinitions() throws BPException {
        this.clearDefinitionCache();
        HashSet<String> rootDefIds = new HashSet<String>();
        Iterator<Object> it = this.defRegistrations.values().iterator();
        while (it.hasNext()) {
            ArrayList al = (ArrayList)it.next();
            Iterator it2 = ((AbstractList)al).iterator();
            while (it2.hasNext()) {
                PMDOperation_SerialImpl op = (PMDOperation_SerialImpl)it2.next();
                rootDefIds.add(op.getRootDefId());
            }
        }
        it = rootDefIds.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            this.getRootDefinition(new ProcessDefinitionKey(id));
        }
    }

    private void refreshCachedOperations() {
        try {
            InitialContext ic = new InitialContext();
            BPE_ObjectLocalHome blobHome = (BPE_ObjectLocalHome)ic.lookup(JNDI_BLOB_NAME);
            this.nonInstBlob = blobHome.findByPrimaryKey(NON_INST_BLOB_NAME);
            this.regsBlob = blobHome.findByPrimaryKey(DEF_REGS_BLOB_NAME);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.metaNonInstanceCreatingOperations = (HashMap)this.nonInstBlob.getObjectForRead();
        this.defRegistrations = (HashMap)this.regsBlob.getObjectForRead();
    }

    private IPMDRoot getRootDefinitionForUpdate(String rootDefinitionID) throws DefinitionServiceException {
        BPE_ObjectLocal defBlob = this.getBlob(rootDefinitionID);
        if (defBlob == null) {
            throw new DefinitionNotFoundException(rootDefinitionID);
        }
        return (IPMDRoot)defBlob.getObjectForReadWrite();
    }

    private void setDefinitionState(String id, DefinitionStateEnum state) throws BPException {
        IPMDRoot rootDef = this.getRootDefinitionForUpdate(id);
        rootDef.setState(state.intValue());
        this.removeCachedDefinition(id);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

