/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.definition.service.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.ode.bpe.bped.DeployTypeEnum;
import org.apache.ode.bpe.bped.EventDirector;
import org.apache.ode.bpe.bped.EventDirectorFactory;
import org.apache.ode.bpe.bped.IDeployer;
import org.apache.ode.bpe.bped.IInternalEventDirector;
import org.apache.ode.bpe.definition.IPMDAction;
import org.apache.ode.bpe.definition.IPMDChangeCondition;
import org.apache.ode.bpe.definition.IPMDOperation;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.serialimpl.PMDRoot_SerialImpl;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.deployment.DefinitionKey;

public class DefViewer
extends JPanel {
    static final long serialVersionUID = 4444550675865822961L;

    public static void main(String[] args) {
        DefViewer viewer = new DefViewer(args[0]);
        JFrame f = new JFrame("Def Tree");
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.getContentPane().add((Component)viewer, "Center");
        ((Component)f).setSize(300, 100);
        f.show();
    }

    DefViewer(String filename) {
        try {
            DefinitionService ds = this.load(filename);
            this.setLayout(new BorderLayout());
            DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode("Definitions");
            Collection rootdefs = ds.getRootDefinitions();
            Iterator it = rootdefs.iterator();
            while (it.hasNext()) {
                IPMDRoot rootdef = (IPMDRoot)it.next();
                DefaultMutableTreeNode level1 = new DefaultMutableTreeNode("IPMDRoot:" + rootdef.getLabel());
                treeRoot.add(level1);
                IPMDProcess rootProc = rootdef.getProcess();
                DefaultMutableTreeNode level2 = new DefaultMutableTreeNode("IPMDProcess:" + rootProc.getLabel());
                level1.add(level2);
                this.addChangeConditions(level2, rootProc);
                this.addProcess(level2, rootProc);
                DefaultMutableTreeNode level3 = new DefaultMutableTreeNode("All Procs for IPMDRoot:" + rootdef.getLabel());
                treeRoot.add(level3);
                Iterator it2 = ((PMDRoot_SerialImpl)rootdef).getProcessIndex().values().iterator();
                while (it2.hasNext()) {
                    IPMDProcess proc = (IPMDProcess)it2.next();
                    DefaultMutableTreeNode level4 = new DefaultMutableTreeNode("IPMDProcess:" + proc.getLabel());
                    level3.add(level4);
                    this.addChangeConditions(level4, proc);
                    this.addProcess(level4, proc);
                }
                DefaultMutableTreeNode level5 = new DefaultMutableTreeNode("Instance Creating Ops");
                level1.add(level5);
                Iterator it3 = ((PMDRoot_SerialImpl)rootdef).getInstanceCreatingOperations().iterator();
                while (it3.hasNext()) {
                    IPMDOperation op = (IPMDOperation)it3.next();
                    DefaultMutableTreeNode level6 = new DefaultMutableTreeNode("IPMDOperation:" + op.getOperationId());
                    level5.add(level6);
                }
            }
            JTree tree = new JTree(treeRoot);
            JScrollPane pane = new JScrollPane(tree);
            this.add((Component)pane, "Center");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DefinitionService load(String filename) {
        try {
            File defJar = new File(filename);
            EventDirector ed = EventDirectorFactory.createEventDirector();
            IDeployer deployer = ed.getDeployer(DeployTypeEnum.BPEL);
            Collection keys = deployer.loadDefinition(new FileInputStream(defJar), false);
            Iterator it = keys.iterator();
            if (it.hasNext()) {
                DefinitionKey key = (DefinitionKey)it.next();
                System.out.println("Id for deployed defintion " + key.getLabel() + " is " + key.getKey());
                deployer.setStateless(key.getKey());
                return ((IInternalEventDirector)((Object)ed)).getProcessService().getInstanceService().getDefinitionService();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void addProcess(DefaultMutableTreeNode level, IPMDProcess rootProc) {
        Iterator it2 = rootProc.getObserverProcessPC();
        while (it2.hasNext()) {
            IPMDProcess proc = (IPMDProcess)it2.next();
            DefaultMutableTreeNode procObserverlevel = new DefaultMutableTreeNode("IPMDProcess:" + proc.getLabel());
            level.add(procObserverlevel);
            this.addChangeConditions(procObserverlevel, proc);
            this.addProcess(procObserverlevel, proc);
        }
    }

    private void addChangeConditions(DefaultMutableTreeNode level, IPMDProcess proc) {
        DefaultMutableTreeNode CClevel;
        Iterator it = proc.getChangeConditions();
        while (it.hasNext()) {
            IPMDChangeCondition cc = (IPMDChangeCondition)it.next();
            CClevel = new DefaultMutableTreeNode("IPMDChangeCondition:" + proc.getLabel());
            this.addActions(CClevel, cc);
            level.add(CClevel);
        }
        IPMDChangeCondition pc = proc.getPrecondition();
        if (pc != null) {
            CClevel = new DefaultMutableTreeNode("IPMDChangeCondition(PreCond):" + proc.getLabel());
            this.addActions(CClevel, pc);
            level.add(CClevel);
        }
    }

    private void addActions(DefaultMutableTreeNode cclevel, IPMDChangeCondition cc) {
        Iterator it2 = cc.getActions();
        while (it2.hasNext()) {
            IPMDAction action = (IPMDAction)it2.next();
            DefaultMutableTreeNode level = new DefaultMutableTreeNode("IPMDAction:" + action.getActionClass());
            cclevel.add(level);
        }
    }
}

