/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.definition.service.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.ode.bpe.action.bpel.XPathJaxenExpression;
import org.apache.ode.bpe.action.bpel.XPathSwitchTuple;
import org.apache.ode.bpe.bped.DeployTypeEnum;
import org.apache.ode.bpe.bped.EventDirector;
import org.apache.ode.bpe.bped.EventDirectorFactory;
import org.apache.ode.bpe.bped.IDeployer;
import org.apache.ode.bpe.bped.IInternalEventDirector;
import org.apache.ode.bpe.definition.IPMDAction;
import org.apache.ode.bpe.definition.IPMDChangeCondition;
import org.apache.ode.bpe.definition.IPMDOperation;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.serialimpl.PMDRoot_SerialImpl;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.deployment.DefinitionKey;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.util.BPException;

public class DefViewer2
extends JPanel {
    static final long serialVersionUID = 4444550675865822961L;
    IPMDRoot rootdef;
    DefinitionService ds;

    public static void main(String[] args) {
        DefViewer2 viewer = new DefViewer2(args[0], null);
        JFrame f = new JFrame("Def Tree");
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.getContentPane().add((Component)viewer, "Center");
        ((Component)f).setSize(300, 100);
        f.show();
    }

    public static void show(DefinitionService ds) {
    }

    DefViewer2(String filename, DefinitionService defService) {
        try {
            this.ds = defService == null ? this.load(filename) : defService;
            this.setLayout(new BorderLayout());
            DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode("Definitions");
            Collection rootdefs = this.ds.getRootDefinitions();
            Iterator it = rootdefs.iterator();
            while (it.hasNext()) {
                this.rootdef = (IPMDRoot)it.next();
                DefaultMutableTreeNode level1 = new DefaultMutableTreeNode("Root Definition:" + this.rootdef.getLabel());
                treeRoot.add(level1);
                IPMDProcess rootProc = this.rootdef.getProcess();
                this.addProcess("Root Proccess", level1, rootProc);
                DefaultMutableTreeNode level5 = new DefaultMutableTreeNode("Instance Creating Ops");
                level1.add(level5);
                Iterator it3 = ((PMDRoot_SerialImpl)this.rootdef).getInstanceCreatingOperations().iterator();
                while (it3.hasNext()) {
                    IPMDOperation op = (IPMDOperation)it3.next();
                    DefaultMutableTreeNode level6 = new DefaultMutableTreeNode("IPMDOperation:" + op.getOperationId());
                    level5.add(level6);
                }
            }
            JTree tree = new JTree(treeRoot);
            JScrollPane pane = new JScrollPane(tree);
            this.add((Component)pane, "Center");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DefinitionService load(String filename) {
        try {
            File defJar = new File(filename);
            EventDirector ed = EventDirectorFactory.createEventDirector();
            IDeployer deployer = ed.getDeployer(DeployTypeEnum.BPEL);
            Collection keys = deployer.loadDefinition(new FileInputStream(defJar), false);
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                DefinitionKey key = (DefinitionKey)it.next();
                System.out.println("Id for deployed defintion " + key.getLabel() + " is " + key.getKey());
                deployer.setStateless(key.getKey());
            }
            return ((IInternalEventDirector)((Object)ed)).getProcessService().getInstanceService().getDefinitionService();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void addProcess(String type, DefaultMutableTreeNode level, IPMDProcess rootProc) throws BPException {
        DefaultMutableTreeNode procLevel = new DefaultMutableTreeNode(type);
        level.add(procLevel);
        this.addChangeConditions(procLevel, rootProc);
        Iterator it2 = rootProc.getObserverProcessPC();
        while (it2.hasNext()) {
            IPMDProcess proc = (IPMDProcess)it2.next();
            this.addProcess("Observer Process " + proc.getLabel(), procLevel, proc);
        }
    }

    private void addChangeConditions(DefaultMutableTreeNode level, IPMDProcess proc) throws BPException {
        IPMDChangeCondition pc = proc.getPrecondition();
        if (pc != null) {
            DefaultMutableTreeNode CClevel = new DefaultMutableTreeNode("PC:" + this.getClass(pc.getConditionalClass()) + " - Actions:" + this.listActions(pc));
            this.addActions(CClevel, pc, proc);
            level.add(CClevel);
        }
        Iterator it = proc.getChangeConditions();
        while (it.hasNext()) {
            IPMDChangeCondition cc = (IPMDChangeCondition)it.next();
            DefaultMutableTreeNode CClevel = new DefaultMutableTreeNode("CC:" + this.getClass(cc.getConditionalClass()) + " - Actions:" + this.listActions(cc));
            this.addActions(CClevel, cc, proc);
            level.add(CClevel);
        }
    }

    private String getClass(String clazz) {
        String[] str = clazz.split("\\.");
        return str[str.length - 1];
    }

    private String listActions(IPMDChangeCondition cc) {
        StringBuffer actions = new StringBuffer();
        Iterator it2 = cc.getActions();
        while (it2.hasNext()) {
            IPMDAction action = (IPMDAction)it2.next();
            actions.append(this.getClass(action.getActionClass()));
            if (action.getActionClass().equals("org.apache.ode.bpe.action.bpel.MergeAction")) {
                actions.append("(Threads to join:" + action.getMetadata().getProperty("SyncThreadCount") + ")");
            }
            if (!it2.hasNext()) continue;
            actions.append(",");
        }
        return actions.toString();
    }

    private void addActions(DefaultMutableTreeNode cclevel, IPMDChangeCondition cc, IPMDProcess observerProc) throws BPException {
        Iterator it2 = cc.getActions();
        while (it2.hasNext()) {
            HashMap faultHandlers;
            IPMDProcess proc;
            IPMDAction action = (IPMDAction)it2.next();
            if (action.getActionClass().equals("org.apache.ode.bpe.action.bpel.StartSequenceAction")) {
                ProcessDefinitionKey startKey = (ProcessDefinitionKey)((Hashtable)action.getMetadata()).get("START_DEF_KEY");
                proc = (IPMDProcess)((PMDRoot_SerialImpl)this.rootdef).getProcessIndex().get(startKey);
                XPathJaxenExpression exp = (XPathJaxenExpression)((Hashtable)action.getMetadata()).get("JoinExpression");
                String expStr = exp == null ? "true" : exp.getSourceExpression();
                this.addProcess("Process by StartSequenceAction(" + expStr + ")" + " " + proc.getLabel(), cclevel, proc);
                continue;
            }
            if (action.getActionClass().equals("org.apache.ode.bpe.action.bpel.XPathSwitchAction")) {
                ProcessDefinitionKey defaultKey = (ProcessDefinitionKey)((Hashtable)action.getMetadata()).get("DEFAULT");
                proc = (IPMDProcess)((PMDRoot_SerialImpl)this.rootdef).getProcessIndex().get(defaultKey);
                this.addProcess("Process by XPathSwitchAction(default) " + proc.getLabel(), cclevel, proc);
                Vector cases = (Vector)((Hashtable)action.getMetadata()).get("CASES");
                Iterator i = ((AbstractList)cases).iterator();
                while (i.hasNext()) {
                    XPathSwitchTuple st = (XPathSwitchTuple)i.next();
                    IPMDProcess proc2 = (IPMDProcess)((PMDRoot_SerialImpl)this.rootdef).getProcessIndex().get(st.getKey());
                    this.addProcess("Process by XPathSwitchAction(" + st.getExpression().getExpression() + ")" + " " + proc.getLabel(), cclevel, proc2);
                }
                continue;
            }
            if (!action.getActionClass().equals("org.apache.ode.bpe.action.bpel.StartScopeAction") || (faultHandlers = (HashMap)((Hashtable)action.getMetadata()).get("faultHandlers")) == null) continue;
            Iterator it = faultHandlers.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                ProcessDefinitionKey pdk = new ProcessDefinitionKey((String)faultHandlers.get(name));
                IPMDProcess fproc = this.ds.getProcessDefintion(pdk, observerProc.getRootKey());
                this.addProcess("faultHandler:" + name, cclevel, fproc);
            }
        }
    }
}

