/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ode.bpe.action.bpel.XPathJaxenExpression;
import org.apache.ode.bpe.definition.IPMDLocator;
import org.apache.ode.bpe.definition.IPMDLocatorHolder;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.BPELExpressionTuple;
import org.apache.ode.bpe.deployment.bpel.BPELExpressionType;
import org.apache.ode.bpe.deployment.bpel.BPELInvocationType;
import org.apache.ode.bpe.deployment.bpel.BPELNode;
import org.apache.ode.bpe.deployment.bpel.BPELScopePath;
import org.apache.ode.bpe.deployment.bpel.BPELUtil;
import org.apache.ode.bpe.deployment.bpel.BPELVariable;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;
import org.apache.ode.bpe.interaction.IInvocationFactory;
import org.apache.ode.bpe.lang.ResourceGetter;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;

class BPELExpressionVariable
extends BPELVariable {
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$deployment$bpel$BPELCopy == null ? (class$org$apache$ode$bpe$deployment$bpel$BPELCopy = BPELExpressionVariable.class$("org.apache.ode.bpe.deployment.bpel.BPELCopy")) : class$org$apache$ode$bpe$deployment$bpel$BPELCopy).getName());
    private static final String LOCATOR_NAME = "var";
    private static final Pattern oneParamPattern = Pattern.compile(".*?\\(\\s*'(.*?)'\\s*\\).*");
    private static final Pattern twoParamPattern = Pattern.compile(".*?\\(\\s*'(.*?)'\\s*,\\s*'(.*?)'\\s*\\).*");
    private static final Pattern threeParamPattern = Pattern.compile(".*?\\(\\s*'(.*?)'\\s*,\\s*'(.*?)'\\s*,\\s*'(.*?)'\\s*\\).*");
    private String m_bpelExpression;
    private String m_bpeExpression;
    private int m_varCounter;
    private HashMap varMap;
    static /* synthetic */ Class class$org$apache$ode$bpe$deployment$bpel$BPELCopy;

    BPELExpressionVariable(String bpelExpression) {
        super(new BPELAttributes(), logger);
        this.m_bpelExpression = bpelExpression;
    }

    private void parseBpelFunctionCalls() {
        int openGetVariableData = this.m_bpeExpression.lastIndexOf("getVariableData(");
        int openGetVariableProperty = this.m_bpeExpression.lastIndexOf("getVariableProperty(");
        int openGetLinkStatus = this.m_bpeExpression.lastIndexOf("getLinkStatus(");
        while (openGetVariableData > -1 || openGetVariableProperty > -1 || openGetLinkStatus > -1) {
            BPELExpressionType type;
            int open = -1;
            int endOpen = -1;
            if (openGetVariableData > openGetVariableProperty && openGetVariableData > openGetLinkStatus) {
                open = openGetVariableData;
                type = BPELExpressionType.VARIABLE_DATA;
                endOpen = open + 16;
            } else if (openGetVariableProperty > openGetVariableData && openGetVariableProperty > openGetLinkStatus) {
                open = openGetVariableProperty;
                type = BPELExpressionType.VARIABLE_PROPERTY;
                endOpen = open + 20;
            } else {
                open = openGetLinkStatus;
                type = BPELExpressionType.LINK_STATUS;
                endOpen = open + 14;
            }
            int close = this.m_bpeExpression.indexOf(")", open + 1);
            int nextcall = this.m_bpeExpression.indexOf("(", endOpen);
            while (nextcall > -1 && nextcall < close) {
                close = this.m_bpeExpression.indexOf(")", close + 1);
                nextcall = this.m_bpeExpression.indexOf("(", nextcall + 1);
            }
            String temp = this.m_bpeExpression.substring(open, close + 1);
            this.varMap.put(String.valueOf(this.m_varCounter), new BPELExpressionTuple(type, temp));
            this.m_bpeExpression = this.m_bpeExpression.substring(0, open) + "$var" + String.valueOf(this.m_varCounter) + this.m_bpeExpression.substring(close + 1, this.m_bpeExpression.length());
            ++this.m_varCounter;
            openGetVariableData = this.m_bpeExpression.lastIndexOf("getVariableData(");
            openGetVariableProperty = this.m_bpeExpression.lastIndexOf("getVariableProperty(");
            openGetLinkStatus = this.m_bpeExpression.lastIndexOf("getLinkStatus(");
        }
    }

    private Matcher matchParamPatterns(String expression) {
        Matcher m = null;
        m = threeParamPattern.matcher(expression);
        if (m.matches()) {
            return m;
        }
        m = twoParamPattern.matcher(expression);
        if (m.matches()) {
            return m;
        }
        m = oneParamPattern.matcher(expression);
        if (m.matches()) {
            return m;
        }
        return null;
    }

    private void handleData(Matcher m, String expression, String locatorName, BPELNode node, BPELNode tagNode, IPMDLocatorHolder locator, BPELInvocationType type) throws DeploymentException {
        String locationPath = null;
        String processName = node.getProcess().getAttributes().getName();
        String variableName = null;
        String partName = null;
        IInvocationFactory invFactory = null;
        try {
            variableName = expression.substring(m.start(1), m.end(1));
        }
        catch (Exception e) {
            variableName = null;
        }
        if (variableName == null) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_NULLVARPARM", new Object[]{node.getProcess().getAttributes().getName(), expression}, null);
        }
        BPELVariable var = node.getVariable(variableName);
        StringBuffer bpePath = new StringBuffer(var.getScopePath(new BPELScopePath(node.inCompensationHandler())).toString());
        bpePath.append("/" + variableName);
        if (m.groupCount() > 2) {
            locationPath = expression.substring(m.start(3), m.end(3));
        }
        try {
            if (m.groupCount() > 1) {
                partName = expression.substring(m.start(2), m.end(2));
                bpePath.append("/" + partName);
                invFactory = var.getInvFactory(processName, partName);
            } else {
                invFactory = var.getInvFactory(processName);
            }
        }
        catch (DeploymentException e) {
            logger.log(Level.SEVERE, ResourceGetter.getFormatted("BPEL_EXP_INVALID", new Object[]{node.getProcess().getAttributes().getName(), expression}));
            throw e;
        }
        this.addUsedInActivity(node);
        try {
            IPMDLocator loc = node.createLocator(true, locator, locatorName, bpePath.toString(), this.getInvocation(locationPath, tagNode, type, invFactory), null, 0, false, false);
            this.addUsedInLocator(loc);
        }
        catch (Exception e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATELOCATOR", new Object[]{node.getProcess().getAttributes().getName(), locatorName, bpePath.toString(), locationPath}, e);
        }
    }

    private void handleProperty(Matcher m, String expression, String locatorName, BPELNode node, BPELNode tagNode, IPMDLocatorHolder locator, BPELInvocationType type) throws DeploymentException {
        if (m.groupCount() != 2) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_PROPIVALID", new Object[]{node.getProcess().getAttributes().getName(), expression}, null);
        }
        String processName = node.getProcess().getAttributes().getName();
        String locationPath = null;
        String variableName = expression.substring(m.start(1), m.end(1));
        BPELVariable var = node.getVariable(variableName);
        StringBuffer bpePath = new StringBuffer(var.getScopePath(new BPELScopePath(node.inCompensationHandler())).toString());
        bpePath.append("/" + variableName);
        BPELAttributes attr = node.getPropertyAttributes(node.getQName(expression.substring(m.start(2), m.end(2))), node.getQName(var.getAttributes().getMessageType()));
        IInvocationFactory invFactory = null;
        if (attr.getPart() != null) {
            bpePath.append("/" + attr.getPart());
            invFactory = var.getInvFactory(processName, attr.getPart());
        } else {
            invFactory = var.getInvFactory(processName);
        }
        locationPath = attr.getQuery();
        this.addUsedInActivity(node);
        try {
            IPMDLocator loc = node.createLocator(true, locator, locatorName, bpePath.toString(), this.getInvocation(locationPath, tagNode, type, invFactory), null, 0, false, false);
            this.addUsedInLocator(loc);
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATELOCATOR", new Object[]{node.getProcess().getAttributes().getName(), locatorName, bpePath.toString(), locationPath}, e);
        }
    }

    private void handleLinkStatus(Matcher m, String expression, String locatorName, BPELNode node, IPMDLocatorHolder locator) throws DeploymentException {
        if (m.groupCount() != 1) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_LINKINVALID", new Object[]{node.getProcess().getAttributes().getName(), expression}, null);
        }
        this.addUsedInActivity(node);
        try {
            IPMDLocator loc = node.createLocator(true, locator, locatorName, expression.substring(m.start(1), m.end(1)), null, null, 0, false, false);
            this.addUsedInLocator(loc);
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATELOCATOR", new Object[]{node.getProcess().getAttributes().getName(), locatorName, expression.substring(m.start(1), m.end(1)), "no query specified"}, e);
        }
    }

    Object createLocator(IPMDLocatorHolder locator, BPELNode node, BPELNode tagNode, BPELAttributes attrs, BPELInvocationType type, boolean forOutPut) throws DeploymentException {
        this.m_varCounter = locator.getLocatorSize() + 1;
        this.m_bpeExpression = this.m_bpelExpression;
        XPathJaxenExpression retVal = null;
        this.varMap = new HashMap();
        this.parseBpelFunctionCalls();
        try {
            new DOMXPath(this.m_bpeExpression);
        }
        catch (JaxenException je) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_XPATH_INVALID", new Object[]{node.getProcess().getAttributes().getName(), this.m_bpelExpression, this.m_bpeExpression}, je);
        }
        Matcher m = null;
        retVal = new XPathJaxenExpression(this.m_bpeExpression, this.m_bpelExpression);
        String locatorName = null;
        Iterator mapItr = this.varMap.entrySet().iterator();
        while (mapItr.hasNext()) {
            Map.Entry me = mapItr.next();
            BPELExpressionTuple et = (BPELExpressionTuple)me.getValue();
            m = this.matchParamPatterns(et.getExpression());
            locatorName = LOCATOR_NAME + (String)me.getKey();
            retVal.addVariableMap(locatorName, et.getExpression());
            if (et.getType() == BPELExpressionType.LINK_STATUS) {
                this.handleLinkStatus(m, et.getExpression(), locatorName, node, locator);
            }
            if (et.getType() == BPELExpressionType.VARIABLE_DATA) {
                this.handleData(m, et.getExpression(), locatorName, node, tagNode, locator, type);
            }
            if (et.getType() != BPELExpressionType.VARIABLE_PROPERTY) continue;
            this.handleProperty(m, et.getExpression(), locatorName, node, tagNode, locator, type);
        }
        return retVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

