/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.bpel.UnInitVariableMetaData;
import org.apache.ode.bpe.definition.IPMDChangeCondition;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.BPELBoolean;
import org.apache.ode.bpe.deployment.bpel.BPELExpressionVariable;
import org.apache.ode.bpe.deployment.bpel.BPELInvocationType;
import org.apache.ode.bpe.deployment.bpel.BPELLink;
import org.apache.ode.bpe.deployment.bpel.BPELLinkType;
import org.apache.ode.bpe.deployment.bpel.BPELLinkedActivity;
import org.apache.ode.bpe.deployment.bpel.BPELNode;
import org.apache.ode.bpe.deployment.bpel.BPELProcessType;
import org.apache.ode.bpe.deployment.bpel.BPELSchema;
import org.apache.ode.bpe.deployment.bpel.BPELStructuredActivity;
import org.apache.ode.bpe.deployment.bpel.BPELUtil;
import org.apache.ode.bpe.deployment.bpel.BPELVariable;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;

class BPELFlow
extends BPELStructuredActivity {
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$deployment$bpel$BPELFlow == null ? (class$org$apache$ode$bpe$deployment$bpel$BPELFlow = BPELFlow.class$("org.apache.ode.bpe.deployment.bpel.BPELFlow")) : class$org$apache$ode$bpe$deployment$bpel$BPELFlow).getName());
    private static final MessageFormat linkStatusFormat = new MessageFormat("getLinkStatus({0})");
    private static final String OR = " or ";
    private Object[] m_linkNameVar = new Object[1];
    protected static final String XPATH_JOIN_COND_CLASS = (class$org$apache$ode$bpe$condition$XPathJoinConditional == null ? (class$org$apache$ode$bpe$condition$XPathJoinConditional = BPELFlow.class$("org.apache.ode.bpe.condition.XPathJoinConditional")) : class$org$apache$ode$bpe$condition$XPathJoinConditional).getName();
    private static final String XPATH_TRAN_COND_CLASS = (class$org$apache$ode$bpe$condition$XPathTransitionConditional == null ? (class$org$apache$ode$bpe$condition$XPathTransitionConditional = BPELFlow.class$("org.apache.ode.bpe.condition.XPathTransitionConditional")) : class$org$apache$ode$bpe$condition$XPathTransitionConditional).getName();
    protected static final String UNINITVAR_KEY = "UNINITVAR";
    protected static final String JOIN_EXPRESSION_KEY = "JoinExpression";
    private static final String TRAN_EXPRESSION_KEY = "TransitionExpression";
    protected static final String SUPPRESS_KEY = "SuppressJoinFault";
    private static final String DEFAULT_CONDITION = "default_condition";
    private HashMap m_links = new HashMap();
    private HashSet m_activities = new HashSet();
    static /* synthetic */ Class class$org$apache$ode$bpe$deployment$bpel$BPELFlow;
    static /* synthetic */ Class class$org$apache$ode$bpe$condition$XPathJoinConditional;
    static /* synthetic */ Class class$org$apache$ode$bpe$condition$XPathTransitionConditional;

    BPELFlow(BPELNode node, BPELAttributes attrs) throws DeploymentException {
        super(node, BPELSchema.FLOW, attrs, logger);
    }

    void addLinkTag(BPELLink link) {
        this.m_links.put(link.getName(), link);
    }

    BPELNode pop() throws DeploymentException {
        this.validateLinks();
        this.createLinks();
        this.setConditionals();
        return super.pop();
    }

    BPELLink setLink(String name, BPELNode node, BPELLinkType linkType, String tCondition) throws DeploymentException {
        BPELLink ret = null;
        ret = (BPELLink)this.m_links.get(name);
        if (ret == null) {
            ret = this.m_parserStack.setLink(name, node, linkType, tCondition);
        } else if (node instanceof BPELLinkedActivity) {
            if (linkType == BPELLinkType.TARGET) {
                ret.setTarget((BPELLinkedActivity)node);
            } else {
                ret.setSource((BPELLinkedActivity)node);
            }
            if (tCondition != null) {
                ret.setTransitionCondition(tCondition);
            }
            ((BPELLinkedActivity)node).addLink(ret, linkType);
            node.notifyLink(ret, this);
        }
        return ret;
    }

    BPELLink notifyLink(BPELLink link, BPELFlow node) throws DeploymentException {
        if (this == node) {
            return link;
        }
        if (this.m_parserStack != null) {
            return this.m_parserStack.notifyLink(link, node);
        }
        return null;
    }

    void addActivity(BPELNode activity) throws DeploymentException {
        this.m_activities.add(activity);
    }

    private void createRTLink(BPELLinkedActivity source, BPELLinkedActivity target, BPELProcessType sourceType) throws DeploymentException {
        this.createProcessSequence(target.getAttributes(), target.getStartProcess());
        source.linkProcess(sourceType, target, BPELProcessType.START, true);
    }

    private void createMerge(BPELLinkedActivity la) throws DeploymentException {
        this.createProcessSync(la.getStartProcess(), la.getAttributes().getName(), String.valueOf(la.getLinkCounter(BPELLinkType.TARGET)));
        Iterator itr = la.getLinks(BPELLinkType.TARGET);
        while (itr.hasNext()) {
            BPELLink link = (BPELLink)itr.next();
            link.consumed(true);
            BPELLinkedActivity proxySource = (BPELLinkedActivity)link.getSource().getProxy(this, link.getSource());
            proxySource.linkProcess(BPELProcessType.END, la, BPELProcessType.START, true);
        }
    }

    private void buildTransitionCondition(BPELLinkedActivity la, BPELExpressionVariable joinExp) throws DeploymentException {
        HashMap<String, Object> condLinks = new HashMap<String, Object>();
        IPMDChangeCondition cc = null;
        try {
            cc = la.getEndProcess().createChangeCondition("BPEL transitionCondition", XPATH_TRAN_COND_CLASS);
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATEACTION", new Object[]{this.getProcess().getAttributes().getName(), this.getAttributes().getName()}, e);
        }
        Iterator linkItr = la.getLinks(BPELLinkType.SOURCE);
        while (linkItr.hasNext()) {
            BPELLink link = (BPELLink)linkItr.next();
            if (link.getTransitionCondition() != null) {
                condLinks.put(link.getName(), link.getTransitionCondition().createLocator(cc, la, link.getSource(), null, BPELInvocationType.SELECT_VALUE, false));
            } else {
                condLinks.put(link.getName(), DEFAULT_CONDITION);
            }
            link.getTransitionCondVar().createLocator(cc, la, null, null, true);
            link.consumed(true);
        }
        Properties md = new Properties();
        ((Hashtable)md).put(UNINITVAR_KEY, new UnInitVariableMetaData("http://schemas.xmlsoap.org/ws/2003/03/business-process/", "uninitializedVariable"));
        ((Hashtable)md).put(TRAN_EXPRESSION_KEY, condLinks);
        if (joinExp != null) {
            ((Hashtable)md).put(JOIN_EXPRESSION_KEY, joinExp.createLocator(cc, la, null, BPELInvocationType.SELECT_VALUE, false));
            ((Hashtable)md).put(SUPPRESS_KEY, BPELBoolean.NO.equals(la.getAttributes().getSuppressJoin()) ? BPELBoolean.NO.getBooleanValue() : la.getSuppressJoinFailure().getBooleanValue());
        }
        cc.setMetadata(md);
    }

    private BPELExpressionVariable buildJoinCondition(BPELLinkedActivity la) throws DeploymentException {
        String joinCondition = la.getAttributes().getJoinCondition();
        if (joinCondition == null) {
            int cntr = 0;
            StringBuffer buff = new StringBuffer();
            Iterator linkItr = la.getLinks(BPELLinkType.TARGET);
            while (linkItr.hasNext()) {
                if (cntr != 0) {
                    buff.append(OR);
                }
                this.m_linkNameVar[0] = "'" + ((BPELLink)linkItr.next()).getName() + "'";
                buff.append(linkStatusFormat.format(this.m_linkNameVar));
                ++cntr;
            }
            joinCondition = buff.toString();
        }
        BPELExpressionVariable expVar = new BPELExpressionVariable(joinCondition);
        la.addJoinCondtion(expVar);
        return expVar;
    }

    void addJoinCondtion(BPELVariable var) throws DeploymentException {
        super.addJoinCondtion(var);
    }

    String getActivityDescription() {
        return "The flow activity starts logical threads of execution within a business process. It is a container for executing other activities and thus it does not have an action implementation.";
    }

    private void validateLinks() throws DeploymentException {
        Iterator linksItr = this.m_links.values().iterator();
        while (linksItr.hasNext()) {
            BPELLink link = (BPELLink)linksItr.next();
            if (link.getSource() == link.getTarget()) {
                BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_LINKREF", new Object[]{this.getProcess().getAttributes().getName(), link.getName()}, null);
            }
            if (link.getSource() != null && link.getTarget() != null) continue;
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_NULLLINKREF", new Object[]{this.getProcess().getAttributes().getName(), link.getName()}, null);
        }
    }

    private void createLinks() throws DeploymentException {
        Vector<BPELLinkedActivity> mergeNodes = new Vector<BPELLinkedActivity>();
        Iterator activitiesItr = this.m_activities.iterator();
        while (activitiesItr.hasNext()) {
            BPELLinkedActivity la = (BPELLinkedActivity)activitiesItr.next();
            if (la.getLinkCounter(BPELLinkType.TARGET) == 0) {
                this.createRTLink(this, la, BPELProcessType.START);
                if (la.getLinkCounter(BPELLinkType.SOURCE) != 0) continue;
                mergeNodes.add(la);
                continue;
            }
            if (la.getLinkCounter(BPELLinkType.TARGET) == 1) {
                BPELLink tLink = (BPELLink)la.getLinks(BPELLinkType.TARGET).next();
                tLink.consumed(true);
                BPELLinkedActivity proxySource = (BPELLinkedActivity)tLink.getSource().getProxy(this, tLink.getSource());
                this.createRTLink(proxySource, la, BPELProcessType.END);
            } else {
                this.createMerge(la);
            }
            if (la.getLinkCounter(BPELLinkType.SOURCE) != 0) continue;
            mergeNodes.add(la);
        }
        this.createProcessSync(this.getEndProcess(), this.getAttributes().getName(), String.valueOf(mergeNodes.size()));
        Iterator mergeNodeItr = ((AbstractList)mergeNodes).iterator();
        while (mergeNodeItr.hasNext()) {
            ((BPELLinkedActivity)mergeNodeItr.next()).linkProcess(BPELProcessType.END, this, BPELProcessType.END, false);
        }
    }

    private void setConditionals() throws DeploymentException {
        BPELExpressionVariable joinExp;
        HashMap<String, BPELExpressionVariable> linkMap = new HashMap<String, BPELExpressionVariable>();
        Iterator condItr = this.m_activities.iterator();
        while (condItr.hasNext()) {
            BPELLinkedActivity condActivity = (BPELLinkedActivity)condItr.next();
            joinExp = null;
            if (condActivity.getLinkCounter(BPELLinkType.TARGET) <= 0) continue;
            joinExp = this.buildJoinCondition(condActivity);
            if (condActivity.getLinkCounter(BPELLinkType.SOURCE) <= 0) continue;
            Iterator iter = condActivity.getLinks(BPELLinkType.SOURCE);
            while (iter.hasNext()) {
                BPELLink link = (BPELLink)iter.next();
                linkMap.put(link.getName(), joinExp);
            }
        }
        Iterator linkItr = this.m_links.values().iterator();
        while (linkItr.hasNext()) {
            BPELLink link = (BPELLink)linkItr.next();
            joinExp = (BPELExpressionVariable)linkMap.get(link.getName());
            this.buildTransitionCondition(link.getSource(), joinExp);
            if (link.isConsumed()) continue;
            ((BPELLinkedActivity)link.getSource().getProxy(this, link.getSource())).linkProcess(BPELProcessType.END, link.getTarget(), BPELProcessType.START, true);
        }
    }

    BPELNode getProxy(BPELFlow linkOwner, BPELNode source) {
        if (linkOwner == this) {
            return source;
        }
        if (this.m_parserStack != null) {
            return this.m_parserStack.getProxy(linkOwner, source);
        }
        return source;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

