/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.ode.bpe.definition.IPMDLocator;
import org.apache.ode.bpe.definition.IPMDLocatorHolder;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.BPELBoolean;
import org.apache.ode.bpe.deployment.bpel.BPELCorrelation;
import org.apache.ode.bpe.deployment.bpel.BPELCorrelationSet;
import org.apache.ode.bpe.deployment.bpel.BPELEvent;
import org.apache.ode.bpe.deployment.bpel.BPELFlow;
import org.apache.ode.bpe.deployment.bpel.BPELLink;
import org.apache.ode.bpe.deployment.bpel.BPELLinkType;
import org.apache.ode.bpe.deployment.bpel.BPELProcess;
import org.apache.ode.bpe.deployment.bpel.BPELSchema;
import org.apache.ode.bpe.deployment.bpel.BPELScope;
import org.apache.ode.bpe.deployment.bpel.BPELScopePath;
import org.apache.ode.bpe.deployment.bpel.BPELUtil;
import org.apache.ode.bpe.deployment.bpel.BPELVariable;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;
import org.apache.ode.bpe.interaction.IInvocation;
import org.apache.ode.bpe.interaction.builders.IInteractionBuilder;
import org.apache.ode.bpe.util.NamespaceUtil;

abstract class BPELNode {
    BPELSchema m_tag;
    BPELNode m_parserStack;
    BPELAttributes m_attributes;
    Vector m_parent = new Vector();
    Logger m_logger;

    BPELNode(BPELNode previous, BPELSchema tag, BPELAttributes attrs, Logger logger) {
        this.m_tag = tag;
        this.m_attributes = attrs;
        this.m_parserStack = previous;
        this.m_logger = logger;
    }

    IPMDProcess getStartProcess() {
        if (this.m_parserStack != null) {
            return this.m_parserStack.getStartProcess();
        }
        return null;
    }

    IPMDProcess getEndProcess() {
        if (this.m_parserStack != null) {
            return this.m_parserStack.getEndProcess();
        }
        return null;
    }

    BPELNode pop() throws DeploymentException {
        return this.m_parserStack;
    }

    IPMDProcess createProcess(String label) throws DeploymentException {
        if (this.m_parserStack != null) {
            return this.m_parserStack.createProcess(label);
        }
        return null;
    }

    BPELAttributes getAttributes() {
        return this.m_attributes;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("Tag: " + this.m_tag.getValue());
        Enumeration e = ((Hashtable)this.m_attributes).keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            buff.append("\n\t qname: " + key);
            buff.append(" ---> " + this.m_attributes.getProperty(key));
        }
        return buff.toString();
    }

    void addActivity(BPELNode activity) throws DeploymentException {
        if (this.m_parserStack != null) {
            this.m_parserStack.addActivity(activity);
        }
    }

    BPELVariable getVariable(String varName) throws DeploymentException {
        if (this.m_parserStack != null) {
            return this.m_parserStack.getVariable(varName);
        }
        return null;
    }

    BPELAttributes getPropertyAttributes(QName qn, QName varMsgType) throws DeploymentException {
        if (this.m_parserStack != null) {
            return this.m_parserStack.getPropertyAttributes(qn, varMsgType);
        }
        return null;
    }

    void addVariable(BPELVariable var) {
        if (this.m_parserStack != null) {
            this.m_parserStack.addVariable(var);
        }
    }

    BPELLink setLink(String name, BPELNode node, BPELLinkType linkType, String tCondition) throws DeploymentException {
        if (this.m_parserStack != null) {
            return this.m_parserStack.setLink(name, node, linkType, tCondition);
        }
        return null;
    }

    BPELLink notifyLink(BPELLink link, BPELFlow node) throws DeploymentException {
        if (this.m_parserStack != null) {
            return this.m_parserStack.notifyLink(link, node);
        }
        return null;
    }

    int getScopeCounter() {
        if (this.m_parserStack != null) {
            return this.m_parserStack.getScopeCounter();
        }
        return 0;
    }

    BPELScope getScope() {
        if (this.m_parserStack != null) {
            return this.m_parserStack.getScope();
        }
        return null;
    }

    BPELScopePath getScopePath(BPELScopePath path) {
        if (this.m_parserStack != null) {
            return this.m_parserStack.getScopePath(path);
        }
        return null;
    }

    void addCorrelation(BPELCorrelation correlation) {
        if (this.m_parserStack != null) {
            this.m_parserStack.addCorrelation(correlation);
        }
    }

    void addEventHandler(BPELEvent event) {
        if (this.m_parserStack != null) {
            this.m_parserStack.addEventHandler(event);
        }
    }

    BPELCorrelationSet getCorrelationSet(String name) {
        if (this.m_parserStack != null) {
            return this.m_parserStack.getCorrelationSet(name);
        }
        return null;
    }

    void addParent(BPELNode node) {
        this.m_parent.add(node);
    }

    void addData(String data) {
    }

    String getData() {
        return null;
    }

    BPELNode getProxy(BPELFlow linkOwner, BPELNode source) {
        if (this.m_parserStack != null) {
            return this.m_parserStack.getProxy(linkOwner, source);
        }
        return source;
    }

    HashSet collectThreadBoundries(HashSet hs) {
        Iterator i = ((AbstractList)this.m_parent).iterator();
        while (i.hasNext()) {
            ((BPELNode)i.next()).collectThreadBoundries(hs);
        }
        return hs;
    }

    BPELBoolean getSuppressJoinFailure() {
        if (BPELBoolean.YES.equals(this.m_attributes.getSuppressJoin())) {
            return BPELBoolean.YES;
        }
        if (this.m_parserStack != null) {
            return this.m_parserStack.getSuppressJoinFailure();
        }
        return BPELBoolean.NO;
    }

    BPELProcess getProcess() {
        return this.m_parserStack.getProcess();
    }

    boolean inCompensationHandler() {
        if (this.m_parserStack != null) {
            return this.m_parserStack.inCompensationHandler();
        }
        return false;
    }

    void setIsStateFull() {
        if (this.m_parserStack != null) {
            this.m_parserStack.setIsStateFull();
        }
    }

    String getNamespace(String prefix) throws DeploymentException {
        String uri = null;
        uri = prefix == null ? this.getAttributes().getProperty("xmlns") : this.getAttributes().getProperty("xmlns:" + prefix);
        if (uri == null && this.m_parserStack != null) {
            uri = this.m_parserStack.getNamespace(prefix);
        }
        return uri;
    }

    HashMap getNamespaceMap(String locationPath) throws DeploymentException {
        HashMap<String, String> locationNS = null;
        if (locationPath != null) {
            Collection prefs = NamespaceUtil.getNamespacePrefixes(locationPath);
            locationNS = new HashMap<String, String>();
            Iterator prefsItr = prefs.iterator();
            while (prefsItr.hasNext()) {
                String prefix = (String)prefsItr.next();
                String uri = this.getNamespace(prefix);
                if (uri == null) {
                    BPELUtil.throwNewException(this.m_logger, Level.SEVERE, "DEPLOY_UNKNOWN_NS", new Object[]{this.getProcess().getAttributes().getName(), prefix}, null);
                }
                locationNS.put(prefix, uri);
            }
        }
        return locationNS;
    }

    String getTargetNamespace() throws DeploymentException {
        if (this.m_parserStack != null) {
            return this.m_parserStack.getTargetNamespace();
        }
        return null;
    }

    QName getQName(String qname) throws DeploymentException {
        if (qname == null) {
            return null;
        }
        String[] qname_split = qname.split(":");
        String uri = null;
        String localName = null;
        switch (qname_split.length) {
            case 1: {
                localName = qname_split[0];
                uri = this.getNamespace(null);
                break;
            }
            case 2: {
                localName = qname_split[1];
                uri = this.getNamespace(qname_split[0]);
                break;
            }
            default: {
                BPELUtil.throwNewException(this.m_logger, Level.SEVERE, "DEPLOY_UNKNOWN_QN", new Object[]{qname}, null);
            }
        }
        return new QName(uri, localName);
    }

    void addJoinCondtion(BPELVariable var) throws DeploymentException {
    }

    String getQueryLanguage() {
        return this.m_parserStack.getQueryLanguage();
    }

    String getExpressionLanguage() {
        return this.m_parserStack.getExpressionLanguage();
    }

    IPMDLocator createLocator(boolean capture, IPMDLocatorHolder locatorHolder, String name, String path, IInvocation query, IInteractionBuilder interactionBuilder, int type, boolean forOutput, boolean contentious) throws DefinitionServiceException {
        IPMDLocator loc = locatorHolder.createLocator(name, path, query, interactionBuilder, type, forOutput, contentious);
        if (this.inCompensationHandler() && capture) {
            this.getScope().setCompLocatorCapture(loc);
        }
        return loc;
    }
}

