/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.deployment.bpel.BPELDefinitionKey;
import org.apache.ode.bpe.deployment.bpel.BPELSAXHandler;
import org.apache.ode.bpe.deployment.bpel.BPELUtil;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;
import org.apache.ode.bpe.util.BPException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class BPELParser {
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$deployment$bpel$BPELParser == null ? (class$org$apache$ode$bpe$deployment$bpel$BPELParser = BPELParser.class$("org.apache.ode.bpe.deployment.bpel.BPELParser")) : class$org$apache$ode$bpe$deployment$bpel$BPELParser).getName());
    private static final String JAXP_NAMESPACE_INCLUDE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String DEFAULT_BPELSCHEMA_NAME = "BPEL4WS.xsd";
    static /* synthetic */ Class class$org$apache$ode$bpe$deployment$bpel$BPELParser;

    BPELParser() {
    }

    static BPELDefinitionKey parseBPEL(String documentName, byte[] bpelDoc, HashMap supportDoc, DefinitionService ds, boolean validating, String schemaPath) throws BPException {
        try {
            SAXParserFactory factory;
            if (schemaPath == null) {
                schemaPath = DEFAULT_BPELSCHEMA_NAME;
            }
            if ((factory = SAXParserFactory.newInstance()) == null) {
                BPELUtil.throwNewException(logger, Level.SEVERE, "JAXP_SAX_FACTORY_NOTFOUND", null, null);
            }
            factory.setValidating(validating);
            factory.setNamespaceAware(true);
            factory.setFeature(JAXP_NAMESPACE_INCLUDE, true);
            SAXParser saxParser = factory.newSAXParser();
            if (saxParser == null) {
                BPELUtil.throwNewException(logger, Level.SEVERE, "JAXP_SAX_PARSER_INVALID", null, null);
            }
            if (validating) {
                saxParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                saxParser.setProperty(JAXP_SCHEMA_SOURCE, new File(schemaPath));
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(bpelDoc);
            InputSource is = new InputSource(bais);
            bais.close();
            BPELSAXHandler sh = new BPELSAXHandler(documentName, supportDoc, ds);
            saxParser.parse(is, (DefaultHandler)sh);
            return sh.getDefKey();
        }
        catch (ParserConfigurationException e) {
            DeploymentException bpx = new DeploymentException("NATIVE_EXCEPTION", new Object[]{"ParserConfigurationException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (SAXException e) {
            if (e.getException() instanceof BPException) {
                throw (BPException)e.getException();
            }
            DeploymentException bpx = new DeploymentException("NATIVE_EXCEPTION", new Object[]{"SAXException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (IOException e) {
            DeploymentException bpx = new DeploymentException("NATIVE_EXCEPTION", new Object[]{"IOException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

