/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.BPELDefinitionKey;
import org.apache.ode.bpe.deployment.bpel.BPELRepositoryHandler;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;
import org.apache.ode.bpe.lang.ResourceGetter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class BPELSAXHandler
extends DefaultHandler {
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$deployment$bpel$BPELSAXHandler == null ? (class$org$apache$ode$bpe$deployment$bpel$BPELSAXHandler = BPELSAXHandler.class$("org.apache.ode.bpe.deployment.bpel.BPELSAXHandler")) : class$org$apache$ode$bpe$deployment$bpel$BPELSAXHandler).getName());
    private BPELRepositoryHandler m_rh;
    private Class[] m_paramType = new Class[]{class$org$apache$ode$bpe$deployment$bpel$BPELAttributes == null ? (class$org$apache$ode$bpe$deployment$bpel$BPELAttributes = BPELSAXHandler.class$("org.apache.ode.bpe.deployment.bpel.BPELAttributes")) : class$org$apache$ode$bpe$deployment$bpel$BPELAttributes};
    private static final String BUILD_PREFIX = "build";
    private static final String CLOSE_PREFIX = "close";
    static /* synthetic */ Class class$org$apache$ode$bpe$deployment$bpel$BPELSAXHandler;
    static /* synthetic */ Class class$org$apache$ode$bpe$deployment$bpel$BPELAttributes;
    static /* synthetic */ Class class$java$lang$Exception;

    BPELSAXHandler(String documentName, HashMap supportDoc, DefinitionService ds) throws DeploymentException {
        this.m_rh = new BPELRepositoryHandler(documentName, supportDoc, ds);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        try {
            logger.fine("Start Element: " + localName);
            BPELAttributes ba = new BPELAttributes(attributes);
            String methodSuffix = localName;
            String activityName = ba.getName();
            String interpretation = this.m_rh.getInterpretation(activityName);
            if (interpretation != null) {
                logger.fine("Interpretation found: " + interpretation);
                methodSuffix = interpretation;
            }
            Method m = this.m_rh.getClass().getMethod(this.getMethodName(methodSuffix, BUILD_PREFIX), this.m_paramType);
            m.invoke((Object)this.m_rh, ba);
        }
        catch (SecurityException e) {
            logger.log(Level.SEVERE, "", e);
            throw new SAXException(e);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.FINE, ResourceGetter.getFormatted("DEPLOY_UNHANDLED_TAG", new Object[]{localName}));
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, "", e);
            throw new SAXException(e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "", e);
            throw new SAXException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if ((class$java$lang$Exception == null ? (class$java$lang$Exception = BPELSAXHandler.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(t.getClass())) {
                throw new SAXException((Exception)t);
            }
            throw new SAXException(t.getLocalizedMessage());
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        try {
            logger.fine("End Element: " + localName);
            Method m = this.m_rh.getClass().getMethod(this.getMethodName(localName, CLOSE_PREFIX), new Class[0]);
            m.invoke((Object)this.m_rh, new Object[0]);
        }
        catch (SecurityException e) {
            logger.log(Level.SEVERE, "", e);
            throw new SAXException(e);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.FINE, ResourceGetter.getFormatted("DEPLOY_UNHANDLED_TAG", new Object[]{qName}));
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, "", e);
            throw new SAXException(e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "", e);
            throw new SAXException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if ((class$java$lang$Exception == null ? (class$java$lang$Exception = BPELSAXHandler.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(t.getClass())) {
                throw new SAXException((Exception)t);
            }
            throw new SAXException(t.getLocalizedMessage());
        }
    }

    private String getMethodName(String tag, String prefix) {
        char[] chars = tag.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        StringBuffer buff = new StringBuffer(prefix);
        buff.append(chars);
        return buff.toString();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_rh.buildData(new String(ch, start, length));
    }

    public void fatalError(SAXParseException e) throws SAXException {
        logger.log(Level.SEVERE, "SAXParser Error", e);
        throw e;
    }

    public void error(SAXParseException e) throws SAXException {
        logger.log(Level.SEVERE, "SAXParser Error", e);
        throw e;
    }

    public void warning(SAXParseException e) throws SAXException {
        logger.log(Level.WARNING, "SAXParser Warning", e);
    }

    public BPELDefinitionKey getDefKey() {
        return this.m_rh.getDefKey();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

