/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.definition.IPMDAction;
import org.apache.ode.bpe.definition.IPMDChangeCondition;
import org.apache.ode.bpe.definition.IPMDLocator;
import org.apache.ode.bpe.definition.IPMDOperation;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.BPELCatch;
import org.apache.ode.bpe.deployment.bpel.BPELCompensationHandler;
import org.apache.ode.bpe.deployment.bpel.BPELCorrelationSet;
import org.apache.ode.bpe.deployment.bpel.BPELEvent;
import org.apache.ode.bpe.deployment.bpel.BPELLinkedActivity;
import org.apache.ode.bpe.deployment.bpel.BPELNode;
import org.apache.ode.bpe.deployment.bpel.BPELProcessType;
import org.apache.ode.bpe.deployment.bpel.BPELSchema;
import org.apache.ode.bpe.deployment.bpel.BPELScopePath;
import org.apache.ode.bpe.deployment.bpel.BPELStructuredActivity;
import org.apache.ode.bpe.deployment.bpel.BPELUtil;
import org.apache.ode.bpe.deployment.bpel.BPELVariable;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;

class BPELScope
extends BPELStructuredActivity {
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$deployment$bpel$BPELScope == null ? (class$org$apache$ode$bpe$deployment$bpel$BPELScope = BPELScope.class$("org.apache.ode.bpe.deployment.bpel.BPELScope")) : class$org$apache$ode$bpe$deployment$bpel$BPELScope).getName());
    private HashMap m_variables = new HashMap();
    private HashMap m_correlationSets = new HashMap();
    private HashMap m_faultHandlers = new HashMap();
    private Vector m_eventHandlers = new Vector();
    private ArrayList m_compLocators = new ArrayList();
    private BPELCompensationHandler m_compHandler;
    private String name;
    private BPELNode m_activity;
    static /* synthetic */ Class class$org$apache$ode$bpe$deployment$bpel$BPELScope;
    static /* synthetic */ Class class$org$apache$ode$bpe$condition$DefaultConditional;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$StartScopeAction;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$EndScopeAction;

    BPELScope(BPELNode node, BPELAttributes attrs) throws DeploymentException {
        super(node, BPELSchema.SCOPE, attrs, logger);
        this.createProcessSequence(this.getAttributes(), this.getEndProcess());
        this.name = attrs.getName() + "_" + this.getScopeCounter();
    }

    void setCompensationHandler(BPELCompensationHandler handler) {
        this.m_compHandler = handler;
    }

    void addVariable(BPELVariable var) {
        this.m_variables.put(var.getName(), var);
        var.setScope(this);
    }

    void addCorrelationSet(BPELCorrelationSet corr) {
        this.m_correlationSets.put(corr.getName(), corr);
    }

    void addFaultHandler(BPELCatch fault) throws DeploymentException {
        this.m_faultHandlers.put(fault.getName(), fault);
    }

    void addEventHandler(BPELEvent event) {
        this.m_eventHandlers.add(event);
    }

    BPELVariable getVariable(String varName) throws DeploymentException {
        BPELVariable ret = null;
        ret = (BPELVariable)this.m_variables.get(varName);
        if (ret == null) {
            ret = this.m_parserStack.getVariable(varName);
        }
        return ret;
    }

    void addActivity(BPELNode activity) throws DeploymentException {
        this.createProcessSequence(activity.getAttributes(), activity.getStartProcess());
        this.linkProcess(BPELProcessType.START, (BPELLinkedActivity)activity, BPELProcessType.START, true);
        ((BPELLinkedActivity)activity).linkProcess(BPELProcessType.END, this, BPELProcessType.END, false);
        this.m_activity = activity;
    }

    String getScopeName() {
        return this.name;
    }

    BPELScopePath getScopePath(BPELScopePath path) {
        path.pushScope(this);
        return this.m_parserStack.getScopePath(path);
    }

    BPELCorrelationSet getCorrelationSet(String name) {
        BPELCorrelationSet ret = (BPELCorrelationSet)this.m_correlationSets.get(name);
        if (ret == null) {
            ret = this.m_parserStack.getCorrelationSet(name);
        }
        return ret;
    }

    BPELNode pop() throws DeploymentException {
        try {
            IPMDChangeCondition ccB = this.getStartProcess().createChangeCondition("Start Scope: " + this.getScopeName(), (class$org$apache$ode$bpe$condition$DefaultConditional == null ? (class$org$apache$ode$bpe$condition$DefaultConditional = BPELScope.class$("org.apache.ode.bpe.condition.DefaultConditional")) : class$org$apache$ode$bpe$condition$DefaultConditional).getName());
            IPMDAction ss = ccB.createAction("Start Scope: " + this.getScopeName(), (class$org$apache$ode$bpe$action$bpel$StartScopeAction == null ? (class$org$apache$ode$bpe$action$bpel$StartScopeAction = BPELScope.class$("org.apache.ode.bpe.action.bpel.StartScopeAction")) : class$org$apache$ode$bpe$action$bpel$StartScopeAction).getName());
            ss.addMetadata("name", this.getScopeName());
            IPMDChangeCondition ccE = this.getEndProcess().createChangeCondition("End Scope: " + this.getScopeName(), (class$org$apache$ode$bpe$condition$DefaultConditional == null ? (class$org$apache$ode$bpe$condition$DefaultConditional = BPELScope.class$("org.apache.ode.bpe.condition.DefaultConditional")) : class$org$apache$ode$bpe$condition$DefaultConditional).getName());
            IPMDAction es = ccE.createAction("End Scope: " + this.getScopeName(), (class$org$apache$ode$bpe$action$bpel$EndScopeAction == null ? (class$org$apache$ode$bpe$action$bpel$EndScopeAction = BPELScope.class$("org.apache.ode.bpe.action.bpel.EndScopeAction")) : class$org$apache$ode$bpe$action$bpel$EndScopeAction).getName());
            this.setEventHandlers(ccB, ccE);
            this.setFaultHandlers(ss);
            this.setCompensationHandler(es);
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATEACTION", new Object[]{this.getProcess().getAttributes().getName(), this.getScopeName()}, e);
        }
        return super.pop();
    }

    void setCompLocatorCapture(IPMDLocator loc) {
        this.m_compLocators.add(loc);
    }

    private void setFaultHandlers(IPMDAction ssa) throws DeploymentException {
        HashMap faultHandlers = new HashMap();
        Iterator itr = this.m_faultHandlers.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry me = itr.next();
            BPELCatch bpelCatch = (BPELCatch)me.getValue();
            faultHandlers.put(me.getKey(), bpelCatch.getStartProcess().getKey().getValue());
            try {
                bpelCatch.getEndProcess().addObserverProcessPC(this.getEndProcess());
            }
            catch (DefinitionServiceException e) {
                BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_ADDOBSERVER", new Object[]{this.getProcess().getAttributes().getName()}, e);
            }
        }
        try {
            ssa.addMetadata("faultHandlers", faultHandlers);
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATEPROP", new Object[]{this.getProcess().getAttributes().getName(), "faultHandlers"}, e);
        }
    }

    private void setCompensationHandler(IPMDAction esa) throws DeploymentException {
        if (this.m_compHandler != null) {
            try {
                esa.addMetadata("compHandler", this.m_compHandler.getStartProcess().getKey().getValue());
                esa.addMetadata("end_scope_locators", this.m_compLocators);
            }
            catch (DefinitionServiceException e) {
                BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATEPROP", new Object[]{this.getProcess().getAttributes().getName(), "compHandler"}, e);
            }
        }
    }

    private void setEventHandlers(IPMDChangeCondition ccB, IPMDChangeCondition ccE) throws DeploymentException {
        ArrayList<IPMDOperation> ops = new ArrayList<IPMDOperation>();
        IPMDOperation op = null;
        IPMDAction regAct = null;
        IPMDAction unRegAct = null;
        if (!this.m_eventHandlers.isEmpty()) {
            regAct = this.createRegisterAction(ccB, this.getScopeName());
            unRegAct = this.createUnRegisterAction(ccE, this.getScopeName());
        }
        Iterator itr = ((AbstractList)this.m_eventHandlers).iterator();
        while (itr.hasNext()) {
            op = ((BPELEvent)itr.next()).getOperation(regAct, ccB);
            if (op != null) {
                this.getProcess().addNonInstanceCreatingStaticKey(op.getKey());
            }
            if (op == null) continue;
            ops.add(op);
        }
        if (regAct != null && unRegAct != null) {
            try {
                regAct.addMetadata("operations", ops);
                regAct.addMetadata("block", new Boolean("false"));
                unRegAct.addMetadata("operations", ops);
            }
            catch (DefinitionServiceException e) {
                BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATEACTION", new Object[]{this.getProcess().getAttributes().getName(), this.getAttributes().getName()}, e);
            }
        }
    }

    BPELScope getScope() {
        if (this.inCompensationHandler()) {
            return this.m_parserStack.getScope();
        }
        return this;
    }

    Vector getEventHandlers() {
        return this.m_eventHandlers;
    }

    void addJoinCondtion(BPELVariable var) throws DeploymentException {
        super.addJoinCondtion(var);
        this.m_activity.addJoinCondtion(var);
    }

    String getActivityDescription() {
        return "scope is implemented by: " + (class$org$apache$ode$bpe$action$bpel$StartScopeAction == null ? (class$org$apache$ode$bpe$action$bpel$StartScopeAction = BPELScope.class$("org.apache.ode.bpe.action.bpel.StartScopeAction")) : class$org$apache$ode$bpe$action$bpel$StartScopeAction).getName() + ". It is used to initailize/destroy a container which holds a named execution context.";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

