/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.bpel.UnInitVariableMetaData;
import org.apache.ode.bpe.action.internal.IInternalAction;
import org.apache.ode.bpe.definition.IPMDAction;
import org.apache.ode.bpe.definition.IPMDChangeCondition;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.BPELBoolean;
import org.apache.ode.bpe.deployment.bpel.BPELFlow;
import org.apache.ode.bpe.deployment.bpel.BPELLink;
import org.apache.ode.bpe.deployment.bpel.BPELLinkType;
import org.apache.ode.bpe.deployment.bpel.BPELLinkedActivity;
import org.apache.ode.bpe.deployment.bpel.BPELNode;
import org.apache.ode.bpe.deployment.bpel.BPELProcessType;
import org.apache.ode.bpe.deployment.bpel.BPELSchema;
import org.apache.ode.bpe.deployment.bpel.BPELStructuredActivity;
import org.apache.ode.bpe.deployment.bpel.BPELUtil;
import org.apache.ode.bpe.deployment.bpel.BPELVariable;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;
import org.apache.ode.bpe.util.BPException;

class BPELSequence
extends BPELStructuredActivity {
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$deployment$bpel$BPELSequence == null ? (class$org$apache$ode$bpe$deployment$bpel$BPELSequence = BPELSequence.class$("org.apache.ode.bpe.deployment.bpel.BPELSequence")) : class$org$apache$ode$bpe$deployment$bpel$BPELSequence).getName());
    private Vector m_activities = new Vector();
    private Vector m_links = new Vector();
    private IPMDAction m_ss;
    private Properties m_ssProps = new Properties();
    static /* synthetic */ Class class$org$apache$ode$bpe$deployment$bpel$BPELSequence;
    static /* synthetic */ Class class$org$apache$ode$bpe$condition$DefaultConditional;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$EndSequenceAction;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$StartSequenceAction;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$SequenceAction;

    BPELSequence(BPELNode node, BPELAttributes attrs) throws DeploymentException {
        super(node, BPELSchema.SEQUENCE, attrs, logger);
        this.createProcessSequence(this.getAttributes(), this.getEndProcess());
    }

    void addActivity(BPELNode activity) throws DeploymentException {
        this.m_activities.add(activity);
    }

    BPELNode pop() throws DeploymentException {
        BPELLinkedActivity current = this;
        BPELLinkedActivity la = null;
        this.createSeqStart();
        Iterator itr = ((AbstractList)this.m_activities).iterator();
        while (itr.hasNext()) {
            la = (BPELLinkedActivity)itr.next();
            if (la.getLinkCounter(BPELLinkType.TARGET) == 0) {
                this.createProcessSequence(la.getAttributes(), la.getStartProcess());
            } else {
                la.incrementLink(BPELLinkType.TARGET);
                this.createProcessSync(la.getStartProcess(), la.getAttributes().getName(), String.valueOf(la.getLinkCounter(BPELLinkType.TARGET)));
            }
            if (current == this) {
                this.linkStartProcess(la);
            } else {
                ((BPELLinkedActivity)current).linkProcess(BPELProcessType.END, la, BPELProcessType.START, true);
            }
            if (la.getLinkCounter(BPELLinkType.SOURCE) > 0) {
                la.incrementLink(BPELLinkType.SOURCE);
            }
            current = la;
        }
        ((BPELLinkedActivity)current).linkProcess(BPELProcessType.END, this, BPELProcessType.END, false);
        this.createSeqEnd();
        this.m_ss.setMetadata(this.m_ssProps);
        return super.pop();
    }

    void addJoinCondtion(BPELVariable var) throws DeploymentException {
        ((Hashtable)this.m_ssProps).put("JoinExpression", var.createLocator(this.m_ss, this, null, null, false));
        ((Hashtable)this.m_ssProps).put("SuppressJoinFault", BPELBoolean.NO.equals(this.getAttributes().getSuppressJoin()) ? BPELBoolean.NO.getBooleanValue() : this.getSuppressJoinFailure().getBooleanValue());
        try {
            IInternalAction tmp = this.m_ss.getActionImpl();
            if (tmp != null) {
                tmp.init(this.m_ssProps);
            }
        }
        catch (BPException bPException) {
            // empty catch block
        }
    }

    BPELLink notifyLink(BPELLink link, BPELFlow node) throws DeploymentException {
        if (link.getSource() != this && link.getTarget() != this) {
            this.m_links.add(link);
        }
        if (this.m_parserStack != null) {
            return this.m_parserStack.notifyLink(link, node);
        }
        return null;
    }

    private void createSeqEnd() throws DeploymentException {
        Vector<Object> linkLocators = new Vector<Object>();
        IPMDChangeCondition ccE = null;
        IPMDAction es = null;
        try {
            ccE = this.getEndProcess().createChangeCondition("End Sequence: " + this.getAttributes().getName(), (class$org$apache$ode$bpe$condition$DefaultConditional == null ? (class$org$apache$ode$bpe$condition$DefaultConditional = BPELSequence.class$("org.apache.ode.bpe.condition.DefaultConditional")) : class$org$apache$ode$bpe$condition$DefaultConditional).getName());
            es = ccE.createAction("End Sequence: " + this.getAttributes().getName(), (class$org$apache$ode$bpe$action$bpel$EndSequenceAction == null ? (class$org$apache$ode$bpe$action$bpel$EndSequenceAction = BPELSequence.class$("org.apache.ode.bpe.action.bpel.EndSequenceAction")) : class$org$apache$ode$bpe$action$bpel$EndSequenceAction).getName());
        }
        catch (DefinitionServiceException e1) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATEACTION", new Object[]{this.getProcess().getAttributes().getName(), this.getAttributes().getName()}, e1);
        }
        Iterator linkItr = ((AbstractList)this.m_links).iterator();
        while (linkItr.hasNext()) {
            BPELLink link = (BPELLink)linkItr.next();
            BPELVariable var = link.getTransitionCondVar();
            linkLocators.add(var.createLocator(es, this, null, null, true));
        }
        Properties md = new Properties();
        ((Hashtable)md).put("links", linkLocators);
        es.setMetadata(md);
        ((Hashtable)this.m_ssProps).put("END_DEF_KEY", this.getEndProcess().getKey());
    }

    private void createSeqStart() throws DeploymentException {
        try {
            IPMDChangeCondition ccB = this.getStartProcess().createChangeCondition("ChangeCondition: " + this.getAttributes().getName(), (class$org$apache$ode$bpe$condition$DefaultConditional == null ? (class$org$apache$ode$bpe$condition$DefaultConditional = BPELSequence.class$("org.apache.ode.bpe.condition.DefaultConditional")) : class$org$apache$ode$bpe$condition$DefaultConditional).getName());
            this.m_ss = ccB.createAction("Start Sequence: " + this.getAttributes().getName(), (class$org$apache$ode$bpe$action$bpel$StartSequenceAction == null ? (class$org$apache$ode$bpe$action$bpel$StartSequenceAction = BPELSequence.class$("org.apache.ode.bpe.action.bpel.StartSequenceAction")) : class$org$apache$ode$bpe$action$bpel$StartSequenceAction).getName());
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATEACTION", new Object[]{this.getProcess().getAttributes().getName(), this.getAttributes().getName()}, e);
        }
    }

    private void linkStartProcess(BPELLinkedActivity la) {
        ((Hashtable)this.m_ssProps).put("START_DEF_KEY", la.getStartProcess().getKey());
        ((Hashtable)this.m_ssProps).put("UNINITVAR", new UnInitVariableMetaData("http://schemas.xmlsoap.org/ws/2003/03/business-process/", "uninitializedVariable"));
    }

    String getActivityDescription() {
        return "sequence is implemented by: " + (class$org$apache$ode$bpe$action$bpel$SequenceAction == null ? (class$org$apache$ode$bpe$action$bpel$SequenceAction = BPELSequence.class$("org.apache.ode.bpe.action.bpel.SequenceAction")) : class$org$apache$ode$bpe$action$bpel$SequenceAction).getName() + ". It is a container used to execute a series of activites.";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

