/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.ode.bpe.definition.IPMDLocator;
import org.apache.ode.bpe.definition.IPMDLocatorHolder;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.BPELExpressionTuple;
import org.apache.ode.bpe.deployment.bpel.BPELExpressionType;
import org.apache.ode.bpe.deployment.bpel.BPELInvocationType;
import org.apache.ode.bpe.deployment.bpel.BPELNode;
import org.apache.ode.bpe.deployment.bpel.BPELScopePath;
import org.apache.ode.bpe.deployment.bpel.BPELUtil;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;
import org.apache.ode.bpe.interaction.IInvocation;
import org.apache.ode.bpe.interaction.IInvocationFactory;
import org.apache.ode.bpe.interaction.InteractionException;
import org.apache.ode.bpe.interaction.InvocationFactory;
import org.apache.ode.bpe.interaction.builders.DefaultInteractionBuilder;
import org.apache.ode.bpe.interaction.builders.IInteractionBuilder;
import org.apache.ode.bpe.lang.ResourceGetter;

abstract class BPELVariable {
    BPELAttributes m_attributes;
    HashSet usedInActivity = new HashSet();
    HashSet usedInLocator = new HashSet();
    HashMap containerMap;
    BPELNode m_ownedBy;
    Logger m_logger;
    private static int _varCtr = 1;
    private HashMap _varMap;
    private static final Pattern oneParamPattern = Pattern.compile(".*?\\(\\s*'(.*?)'\\s*\\).*");
    private static final Pattern twoParamPattern = Pattern.compile(".*?\\(\\s*'(.*?)'\\s*,\\s*'(.*?)'\\s*\\).*");
    private static final Pattern threeParamPattern = Pattern.compile(".*?\\(\\s*'(.*?)'\\s*,\\s*'(.*?)'\\s*,\\s*'(.*?)'\\s*\\).*");
    private static String[] simpleSoapTypes = new String[]{"string", "boolean", "base64Binary", "hexBinary", "float", "double", "normalizedString", "decimal", "integer", "nonPositiveInteger", "negativeInteger", "long", "int", "short", "byte", "nonNegativeInteger", "unsignedLong", "unsignedInt", "unsignedShort", "unsignedByte", "positiveInteger"};

    BPELVariable(BPELAttributes attrs, Logger logger) {
        this.m_attributes = attrs;
        this.m_logger = logger;
        if (_varCtr > 100) {
            _varCtr = 1;
        }
    }

    BPELVariable(BPELAttributes attrs, HashMap containerMap, Logger logger) {
        this(attrs, logger);
        this.containerMap = containerMap;
        if (_varCtr > 100) {
            _varCtr = 1;
        }
    }

    void addUsedInActivity(BPELNode node) {
        this.usedInActivity.add(node);
    }

    void addUsedInLocator(IPMDLocator locator) {
        this.usedInLocator.add(locator);
    }

    Collection getUsedInActivities() {
        return this.usedInActivity;
    }

    Collection getUsedInLocators() {
        return this.usedInLocator;
    }

    String getName() {
        return this.m_attributes.getName();
    }

    void setName(String name) {
        this.m_attributes.setName(name);
    }

    void setScope(BPELNode scope) {
        this.m_ownedBy = scope;
    }

    BPELScopePath getScopePath(BPELScopePath path) {
        return this.m_ownedBy.getScopePath(path);
    }

    BPELAttributes getAttributes() {
        return this.m_attributes;
    }

    IInvocation getInvocation(String locationPath, BPELNode node, BPELInvocationType type, IInvocationFactory factory) throws DeploymentException {
        IInvocation inv = null;
        if (type == BPELInvocationType.NO_INVOCATION) {
            return null;
        }
        try {
            if (locationPath != null) {
                HashMap locationNS = new HashMap();
                if (node != null) {
                    locationNS = node.getNamespaceMap(locationPath);
                }
                if (type == BPELInvocationType.SELECT_VALUE) {
                    inv = factory.createXPathQueryNodeValueInvocation(locationPath, locationNS);
                } else if (type == BPELInvocationType.SELECT_NODE) {
                    inv = factory.createXPathSelectTreeInvocation(locationPath == null ? "/" : locationPath, locationNS);
                } else if (type == BPELInvocationType.GRAFT_BENEATH_NODE) {
                    inv = factory.createXPathCopyTreeInvocation(locationPath == null ? "/" : locationPath, locationNS);
                } else if (type == BPELInvocationType.UPDATE_VALUE) {
                    inv = factory.createXPathSetNodeValueInvocation(locationPath, locationNS);
                } else if (type == BPELInvocationType.GRAFT_CHILDREN_BENEATH_NODE) {
                    inv = factory.createXPathCopyChildrenInvocation(locationPath, locationNS);
                }
            } else if (type == BPELInvocationType.UPDATE_OBJECT) {
                inv = factory.createSetObjectInvocation();
            } else if (type == BPELInvocationType.SELECT_OBJECT) {
                inv = factory.createGetObjectInvocation();
            }
        }
        catch (InteractionException e) {
            BPELUtil.throwNewException(this.m_logger, Level.SEVERE, "DEPLOY_INVOCATION_CREATE", null, e);
        }
        return inv;
    }

    boolean isPartSimpleType(String partName) {
        return true;
    }

    boolean isSimpleType() {
        return true;
    }

    abstract Object createLocator(IPMDLocatorHolder var1, BPELNode var2, BPELNode var3, BPELAttributes var4, BPELInvocationType var5, boolean var6) throws DeploymentException;

    Object createLocator(IPMDLocatorHolder locator, BPELNode node, BPELAttributes attrs, BPELInvocationType type, boolean forOutPut) throws DeploymentException {
        return this.createLocator(locator, node, node, attrs, type, forOutPut);
    }

    protected IInteractionBuilder getIntBuilder(String processName) throws DeploymentException {
        return this.getIntBuilder(processName, this.m_attributes.getName());
    }

    protected IInteractionBuilder getIntBuilder(String processName, String key) throws DeploymentException {
        return new DefaultInteractionBuilder();
    }

    protected IInvocationFactory getInvFactory(String processName) throws DeploymentException {
        return this.getInvFactory(processName, this.m_attributes.getName());
    }

    protected IInvocationFactory getInvFactory(String processName, String key) throws DeploymentException {
        return new InvocationFactory();
    }

    public static boolean IsSimpleType(QName dataType) {
        if (dataType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || dataType.getNamespaceURI().equals("http://www.w3.org/1999/XMLSchema")) {
            return true;
        }
        if (dataType.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            for (int i = 0; i < simpleSoapTypes.length; ++i) {
                if (!dataType.getLocalPart().equalsIgnoreCase(simpleSoapTypes[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected String parseBpelFunctionCalls(String xpath) {
        this._varMap = new HashMap();
        if (xpath == null) {
            return null;
        }
        int openGetVariableData = xpath.lastIndexOf("getVariableData(");
        int openGetVariableProperty = xpath.lastIndexOf("getVariableProperty(");
        int openGetLinkStatus = xpath.lastIndexOf("getLinkStatus(");
        while (openGetVariableData > -1 || openGetVariableProperty > -1 || openGetLinkStatus > -1) {
            BPELExpressionType type;
            int open = -1;
            int endOpen = -1;
            if (openGetVariableData > openGetVariableProperty && openGetVariableData > openGetLinkStatus) {
                open = openGetVariableData;
                type = BPELExpressionType.VARIABLE_DATA;
                endOpen = open + 16;
            } else if (openGetVariableProperty > openGetVariableData && openGetVariableProperty > openGetLinkStatus) {
                open = openGetVariableProperty;
                type = BPELExpressionType.VARIABLE_PROPERTY;
                endOpen = open + 20;
            } else {
                open = openGetLinkStatus;
                type = BPELExpressionType.LINK_STATUS;
                endOpen = open + 14;
            }
            int close = xpath.indexOf(")", open + 1);
            int nextcall = xpath.indexOf("(", endOpen);
            while (nextcall > -1 && nextcall < close) {
                close = xpath.indexOf(")", close + 1);
                nextcall = xpath.indexOf("(", nextcall + 1);
            }
            String temp = xpath.substring(open, close + 1);
            this._varMap.put(String.valueOf(_varCtr), new BPELExpressionTuple(type, temp));
            xpath = xpath.substring(0, open) + "$var" + String.valueOf(_varCtr) + xpath.substring(close + 1, xpath.length());
            ++_varCtr;
            openGetVariableData = xpath.lastIndexOf("getVariableData(");
            openGetVariableProperty = xpath.lastIndexOf("getVariableProperty(");
            openGetLinkStatus = xpath.lastIndexOf("getLinkStatus(");
        }
        return xpath;
    }

    protected void handleNestedVariables(BPELNode node, BPELNode tagNode, IPMDLocatorHolder locator, BPELInvocationType type) throws DeploymentException {
        String varLocatorName = null;
        Iterator mapItr = this._varMap.entrySet().iterator();
        while (mapItr.hasNext()) {
            Map.Entry me = mapItr.next();
            BPELExpressionTuple et = (BPELExpressionTuple)me.getValue();
            Matcher m = this.matchParamPatterns(et.getExpression());
            varLocatorName = "var" + (String)me.getKey();
            if (et.getType() == BPELExpressionType.LINK_STATUS) {
                // empty if block
            }
            if (et.getType() == BPELExpressionType.VARIABLE_DATA) {
                this.handleData(m, et.getExpression(), varLocatorName, node, tagNode, locator, type);
            }
            if (et.getType() != BPELExpressionType.VARIABLE_PROPERTY) continue;
        }
    }

    private Matcher matchParamPatterns(String expression) {
        Matcher m = null;
        m = threeParamPattern.matcher(expression);
        if (m.matches()) {
            return m;
        }
        m = twoParamPattern.matcher(expression);
        if (m.matches()) {
            return m;
        }
        m = oneParamPattern.matcher(expression);
        if (m.matches()) {
            return m;
        }
        return null;
    }

    private void handleData(Matcher m, String expression, String locatorName, BPELNode node, BPELNode tagNode, IPMDLocatorHolder locator, BPELInvocationType type) throws DeploymentException {
        String locationPath = null;
        String processName = node.getProcess().getAttributes().getName();
        String variableName = null;
        String partName = null;
        IInvocationFactory invFactory = null;
        try {
            variableName = expression.substring(m.start(1), m.end(1));
        }
        catch (Exception e) {
            variableName = null;
        }
        if (variableName == null) {
            BPELUtil.throwNewException(this.m_logger, Level.SEVERE, "BPEL_NULLVARPARM", new Object[]{node.getProcess().getAttributes().getName(), expression}, null);
        }
        BPELVariable var = node.getVariable(variableName);
        StringBuffer bpePath = new StringBuffer(var.getScopePath(new BPELScopePath(node.inCompensationHandler())).toString());
        bpePath.append("/" + variableName);
        if (m.groupCount() > 2) {
            locationPath = expression.substring(m.start(3), m.end(3));
        }
        try {
            if (m.groupCount() > 1) {
                partName = expression.substring(m.start(2), m.end(2));
                bpePath.append("/" + partName);
                invFactory = var.getInvFactory(processName, partName);
            } else {
                invFactory = var.getInvFactory(processName);
            }
        }
        catch (DeploymentException e) {
            this.m_logger.log(Level.SEVERE, ResourceGetter.getFormatted("BPEL_EXP_INVALID", new Object[]{node.getProcess().getAttributes().getName(), expression}));
            throw e;
        }
        this.addUsedInActivity(node);
        try {
            IPMDLocator loc = node.createLocator(true, locator, locatorName, bpePath.toString(), this.getInvocation(locationPath, tagNode, type, invFactory), null, 0, false, false);
            this.addUsedInLocator(loc);
        }
        catch (Exception e) {
            BPELUtil.throwNewException(this.m_logger, Level.SEVERE, "BPEL_CREATELOCATOR", new Object[]{node.getProcess().getAttributes().getName(), locatorName, bpePath.toString(), locationPath}, e);
        }
    }
}

