/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import com.ibm.wsdl.extensions.PopulatedExtensionRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.ode.bpe.binding.bpe.BPEBindingDocument;
import org.apache.ode.bpe.binding.bpe.TActivityBinding;
import org.apache.ode.bpe.binding.bpe.TActivityBindings;
import org.apache.ode.bpe.binding.bpe.TBinding;
import org.apache.ode.bpe.binding.bpe.TOperation;
import org.apache.ode.bpe.binding.bpe.TSchema;
import org.apache.ode.bpe.deployment.bpel.BPELAction;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.BPELNode;
import org.apache.ode.bpe.deployment.bpel.BPELProcess;
import org.apache.ode.bpe.deployment.bpel.BPELPropertyDefinition;
import org.apache.ode.bpe.deployment.bpel.BPELUtil;
import org.apache.ode.bpe.deployment.bpel.BPELVariable;
import org.apache.ode.bpe.deployment.bpel.BPELWSDLLocator;
import org.apache.ode.bpe.deployment.bpel.BPELWSDLVariable;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;
import org.apache.ode.bpe.deployment.bpel.WSDLOperationKey;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.wsdl.extensions.BPEAction;
import org.apache.ode.bpe.wsdl.extensions.BPEActionSerializer;
import org.apache.ode.bpe.wsdl.extensions.BPEFault;
import org.apache.ode.bpe.wsdl.extensions.BPEFaultSerializer;
import org.apache.ode.bpe.wsdl.extensions.BPEInput;
import org.apache.ode.bpe.wsdl.extensions.BPEInputSerializer;
import org.apache.ode.bpe.wsdl.extensions.BPELProperty;
import org.apache.ode.bpe.wsdl.extensions.BPELPropertyAlias;
import org.apache.ode.bpe.wsdl.extensions.BPELPropertyAliasSerializer;
import org.apache.ode.bpe.wsdl.extensions.BPELPropertySerializer;
import org.apache.ode.bpe.wsdl.extensions.BPEOutput;
import org.apache.ode.bpe.wsdl.extensions.BPEOutputSerializer;
import org.apache.ode.bpe.wsdl.extensions.BPEVariableMap;
import org.apache.ode.bpe.wsdl.extensions.BPEVariableMapSerializer;
import org.apache.ode.bpe.wsdl.extensions.ExtentionConstants;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.InputSource;

public class ExtensibilityArtifacts {
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$deployment$bpel$ExtensibilityArtifacts == null ? (class$org$apache$ode$bpe$deployment$bpel$ExtensibilityArtifacts = ExtensibilityArtifacts.class$("org.apache.ode.bpe.deployment.bpel.ExtensibilityArtifacts")) : class$org$apache$ode$bpe$deployment$bpel$ExtensibilityArtifacts).getName());
    private static final Pattern wsdlPattern = Pattern.compile(".*\\.wsdl");
    private static final String DEFAULT_TYPE = "";
    private BPELProcess process;
    private Definition rootDef;
    private List wsdlDefs;
    private HashMap repos = new HashMap();
    private TSchema bpeBinding;
    private HashMap activityBindingMap;
    private BPEProperties properties;
    static /* synthetic */ Class class$org$apache$ode$bpe$deployment$bpel$ExtensibilityArtifacts;
    static /* synthetic */ Class class$javax$wsdl$Definition;
    static /* synthetic */ Class class$org$apache$ode$bpe$wsdl$extensions$BPELProperty;
    static /* synthetic */ Class class$org$apache$ode$bpe$wsdl$extensions$BPELPropertyAlias;
    static /* synthetic */ Class class$javax$wsdl$BindingOperation;
    static /* synthetic */ Class class$org$apache$ode$bpe$wsdl$extensions$BPEAction;
    static /* synthetic */ Class class$javax$wsdl$BindingInput;
    static /* synthetic */ Class class$org$apache$ode$bpe$wsdl$extensions$BPEInput;
    static /* synthetic */ Class class$javax$wsdl$BindingOutput;
    static /* synthetic */ Class class$org$apache$ode$bpe$wsdl$extensions$BPEOutput;
    static /* synthetic */ Class class$javax$wsdl$BindingFault;
    static /* synthetic */ Class class$org$apache$ode$bpe$wsdl$extensions$BPEFault;
    static /* synthetic */ Class class$org$apache$ode$bpe$wsdl$extensions$BPEVariableMap;

    public ExtensibilityArtifacts(String bpelDocName, HashMap artifacts, BPEProperties props) throws DeploymentException {
        this.rootDef = this.getRootWSDL(bpelDocName, artifacts);
        this.bpeBinding = this.getBPEBindings(bpelDocName, artifacts);
        this.properties = props;
        Pattern bindingPattern = Pattern.compile(bpelDocName + ".xml");
        this.wsdlDefs = BPELUtil.getDefinitionList(this.rootDef, new ArrayList());
        Iterator itr = artifacts.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry me = itr.next();
            Matcher m1 = wsdlPattern.matcher((String)me.getKey());
            Matcher m2 = bindingPattern.matcher((String)me.getKey());
            if (m1.matches() || m2.matches()) continue;
            this.repos.put((String)me.getKey(), new String((byte[])me.getValue()));
        }
    }

    public BPEProperties getBPEProperties() {
        return this.properties;
    }

    private void buildActivityBindingMap() {
        TActivityBinding[] activityBindingList;
        this.activityBindingMap = new HashMap();
        TActivityBindings abs = this.bpeBinding.getActivityBindings();
        if (abs != null && (activityBindingList = abs.getActivityBindingArray()).length > 0) {
            for (int iter = 0; iter < activityBindingList.length; ++iter) {
                TActivityBinding ab = activityBindingList[iter];
                if (ab == null) continue;
                String activityName = ab.getActivityName();
                this.activityBindingMap.put(activityName, ab);
            }
        }
    }

    public String getActivityInterpretation(String activityID) {
        TActivityBinding ab;
        if (this.bpeBinding == null) {
            return null;
        }
        if (this.activityBindingMap == null) {
            this.buildActivityBindingMap();
        }
        if ((ab = (TActivityBinding)this.activityBindingMap.get(activityID)) != null) {
            return ab.getInterpretation();
        }
        return null;
    }

    public BPELVariable getFaultVariable(QName faultName, String faultVariable, HashMap faultMap) throws DeploymentException {
        BPELWSDLVariable retVal = null;
        Iterator defIter = this.wsdlDefs.iterator();
        block0: while (defIter.hasNext()) {
            Definition defCur = (Definition)defIter.next();
            if (!defCur.getTargetNamespace().equals(faultName.getNamespaceURI())) continue;
            Iterator portItr = defCur.getPortTypes().values().iterator();
            while (portItr.hasNext()) {
                PortType pt = (PortType)portItr.next();
                Iterator operItr = pt.getOperations().iterator();
                while (operItr.hasNext()) {
                    Operation oper = (Operation)operItr.next();
                    Fault wsdlFault = oper.getFault(faultName.getLocalPart());
                    if (wsdlFault == null) continue;
                    BPELAttributes wsdlVarAttrs = new BPELAttributes();
                    wsdlVarAttrs.setName(faultVariable);
                    QName msgName = wsdlFault.getMessage().getQName();
                    wsdlVarAttrs.setMessageType(defCur.getPrefix(msgName.getNamespaceURI()) + ":" + msgName.getLocalPart());
                    retVal = new BPELWSDLVariable(wsdlVarAttrs, this.getContainerMap(faultVariable), wsdlFault.getMessage());
                    this.getBPEFault(oper, pt, faultName.getLocalPart(), faultMap);
                    break block0;
                }
            }
        }
        return retVal;
    }

    public HashMap getContainerMap(String varName) {
        HashMap<String, BPEVariableMap> retVal = new HashMap<String, BPEVariableMap>();
        boolean found = false;
        Iterator defsItr = this.wsdlDefs.iterator();
        while (defsItr.hasNext()) {
            Definition wsdlDef = (Definition)defsItr.next();
            List elems = wsdlDef.getExtensibilityElements();
            ExtensibilityElement extElem = null;
            BPEVariableMap varMap = null;
            Iterator elem = elems.iterator();
            while (elem.hasNext()) {
                extElem = (ExtensibilityElement)elem.next();
                if (!(extElem instanceof BPEVariableMap) || !(varMap = (BPEVariableMap)extElem).getName().getLocalPart().equals(varName)) continue;
                if (varMap.getPart() != null) {
                    retVal.put(varMap.getPart(), varMap);
                    found = true;
                    continue;
                }
                retVal.put(varMap.getName().getLocalPart(), varMap);
                found = true;
            }
            if (!found) continue;
            break;
        }
        return retVal;
    }

    private HashMap getBPEFault(Operation opr, PortType pt, String faultName, HashMap faultHM) {
        Iterator partItr = opr.getFault(faultName).getMessage().getParts().keySet().iterator();
        while (partItr.hasNext()) {
            String partName = (String)partItr.next();
            BPEFault bpeFault = new BPEFault();
            bpeFault.setPart(partName);
            bpeFault.setType(DEFAULT_TYPE);
            faultHM.put(partName, bpeFault);
        }
        Binding binding = null;
        Iterator defItr = this.wsdlDefs.iterator();
        while (defItr.hasNext()) {
            Definition id = (Definition)defItr.next();
            Iterator bindingItr = id.getBindings().values().iterator();
            while (bindingItr.hasNext()) {
                binding = (Binding)bindingItr.next();
                if (binding.getPortType() != pt) continue;
                List opers = binding.getBindingOperations();
                Iterator operIter = opers.iterator();
                while (operIter.hasNext()) {
                    BindingFault bf;
                    BindingOperation bopr = (BindingOperation)operIter.next();
                    if (!ExtensibilityArtifacts.isOperationMatch(opr, bopr) || (bf = bopr.getBindingFault(faultName)) == null) continue;
                    List bfexts = bf.getExtensibilityElements();
                    Iterator bfextsItr = bfexts.iterator();
                    while (bfextsItr.hasNext()) {
                        Object bpeFault = bfextsItr.next();
                        if (!(bpeFault instanceof BPEFault) || !faultHM.containsKey(((BPEFault)bpeFault).getPart())) continue;
                        faultHM.put(((BPEFault)bpeFault).getPart(), bpeFault);
                    }
                }
            }
        }
        return faultHM;
    }

    private BPELProcess getProcess() {
        return this.process;
    }

    public void setProcess(BPELProcess process) {
        this.process = process;
        Iterator itr = this.repos.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry me = itr.next();
            process.addSupportingDocument((String)me.getKey(), (String)me.getValue());
        }
    }

    public Message getMessage(String msgName, BPELNode node) throws DeploymentException {
        return this.rootDef.getMessage(node.getQName(msgName));
    }

    public HashMap buildProperties() throws DeploymentException {
        HashMap<QName, BPELPropertyDefinition> retVal = new HashMap<QName, BPELPropertyDefinition>();
        Iterator wsdlItr = this.wsdlDefs.iterator();
        while (wsdlItr.hasNext()) {
            Definition wsdlDef = (Definition)wsdlItr.next();
            List el = wsdlDef.getExtensibilityElements();
            BPELProperty prop = null;
            Iterator itr = el.iterator();
            while (itr.hasNext()) {
                Object eo = itr.next();
                if (!(eo instanceof BPELProperty)) continue;
                prop = (BPELProperty)eo;
                retVal.put(new QName(wsdlDef.getTargetNamespace(), prop.getName()), new BPELPropertyDefinition(prop));
            }
        }
        this.buildPropertyAliases(retVal);
        return retVal;
    }

    private void buildPropertyAliases(HashMap props) throws DeploymentException {
        BPELPropertyAlias alias = null;
        BPELPropertyDefinition propDef = null;
        Iterator wsdlItr = this.wsdlDefs.iterator();
        while (wsdlItr.hasNext()) {
            Definition wsdlDef = (Definition)wsdlItr.next();
            List el = wsdlDef.getExtensibilityElements();
            Iterator itr = el.iterator();
            while (itr.hasNext()) {
                Object eo = itr.next();
                if (!(eo instanceof BPELPropertyAlias)) continue;
                alias = (BPELPropertyAlias)eo;
                propDef = (BPELPropertyDefinition)props.get(alias.getPropertyName());
                if (propDef == null) {
                    BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_PROPERTY_NOTFOUND", new Object[]{this.getProcess().getAttributes().getName(), alias.getPropertyName().toString()}, null);
                }
                propDef.addAlias(alias);
            }
        }
    }

    public BPELAction getBindingInvokeAction(String portType, String operationName, String invokeName, BPELVariable input, BPELVariable output, BPELNode node) throws DeploymentException {
        String partName;
        Operation opr;
        BPELAction retVal = new BPELAction();
        BPEAction bpeAction = null;
        QName qnPort = node.getQName(portType);
        PortType pt = this.rootDef.getPortType(qnPort);
        if (pt == null) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_PT_NOTFOUND", new Object[]{this.getProcess().getAttributes().getName(), portType}, null);
        }
        if ((opr = this.matchOperation(pt, input, output, invokeName, operationName)) == null) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_OPR_NOTFOUND", new Object[]{this.getProcess().getAttributes().getName(), portType}, null);
        }
        WSDLOperationKey sk = new WSDLOperationKey(qnPort.getNamespaceURI(), qnPort.getLocalPart(), opr.getName(), opr.getInput() == null ? "default" : opr.getInput().getName(), opr.getOutput() == null ? "default" : opr.getOutput().getName());
        HashMap<String, BPEInput> inputHM = new HashMap<String, BPEInput>();
        HashMap<String, BPEOutput> outputHM = new HashMap<String, BPEOutput>();
        if (opr.getInput() != null) {
            Iterator inpItr = opr.getInput().getMessage().getParts().keySet().iterator();
            while (inpItr.hasNext()) {
                partName = (String)inpItr.next();
                BPEInput bpeInput = new BPEInput();
                bpeInput.setPart(partName);
                bpeInput.setType(DEFAULT_TYPE);
                inputHM.put(partName, bpeInput);
            }
        }
        if (opr.getOutput() != null) {
            Iterator outItr = opr.getOutput().getMessage().getParts().keySet().iterator();
            while (outItr.hasNext()) {
                partName = (String)outItr.next();
                BPEOutput bpeOutput = new BPEOutput();
                bpeOutput.setPart(partName);
                bpeOutput.setType(DEFAULT_TYPE);
                outputHM.put(partName, bpeOutput);
            }
        }
        if ((bpeAction = this.getBPEActionBPEBinding(pt, opr)) == null) {
            bpeAction = this.getBPEActionWSDL(pt, opr, inputHM, outputHM);
        }
        if (bpeAction == null) {
            if (this.properties.getExternalActionDefaultImplementation() == null) {
                throw new RuntimeException("Could not find action binding for: pt = " + pt.getQName() + ", oper = " + opr.getName());
            }
            bpeAction = new BPEAction();
            bpeAction.setBPEImplementation(this.properties.getExternalActionBPEImplementation());
            bpeAction.setImplementation(this.properties.getExternalActionDefaultImplementation());
        }
        retVal.setAction(bpeAction);
        retVal.setOk(sk);
        retVal.setInput(new Vector(inputHM.values()));
        retVal.setOutput(new Vector(outputHM.values()));
        return retVal;
    }

    private BPEAction getBPEActionBPEBinding(PortType pt, Operation opr) throws DeploymentException {
        BPEAction bpeAction = null;
        if (this.bpeBinding != null) {
            TBinding[] bindingArray = this.bpeBinding.getActionBindings().getBindingArray();
            block0: for (int bdItr = 0; bdItr < bindingArray.length; ++bdItr) {
                TBinding b = bindingArray[bdItr];
                QName tPort = new QName(b.getNameSpace(), b.getPortType());
                if (!tPort.equals(pt.getQName())) continue;
                TOperation[] operationArray = b.getOperationArray();
                for (int opItr = 0; opItr < operationArray.length; ++opItr) {
                    TOperation tOp = operationArray[opItr];
                    if (!tOp.getName().equals(opr.getName())) continue;
                    bpeAction = new BPEAction();
                    bpeAction.setImplementation(tOp.getAction().getImplementation());
                    if (tOp.getAction().getBpeImplementation() != null) {
                        bpeAction.setBPEImplementation(tOp.getAction().getBpeImplementation());
                    }
                    XmlCursor cur = tOp.getAction().newCursor();
                    boolean hasAttr = cur.toFirstAttribute();
                    String bpeNS = tOp.getAction().schemaType().getName().getNamespaceURI();
                    while (hasAttr) {
                        if (!bpeNS.equals(cur.getName().getNamespaceURI()) && cur.getName().getNamespaceURI().length() != 0) {
                            bpeAction.addProp(cur.getName().getLocalPart(), cur.getTextValue());
                        }
                        hasAttr = cur.toNextAttribute();
                    }
                    break block0;
                }
            }
        }
        return bpeAction;
    }

    private BPEAction getBPEActionWSDL(PortType pt, Operation opr, HashMap inputHM, HashMap outputHM) throws DeploymentException {
        Vector<Definition> defs = new Vector<Definition>();
        defs.add(this.rootDef);
        List impList = this.rootDef.getImports(this.rootDef.getTargetNamespace());
        if (impList != null) {
            Iterator impItr = impList.iterator();
            while (impItr.hasNext()) {
                Import imp = (Import)impItr.next();
                defs.add(imp.getDefinition());
            }
        }
        defs.addAll(this.wsdlDefs);
        Binding binding = null;
        BPEAction bpeAction = null;
        Iterator defItr = defs.iterator();
        block1: while (defItr.hasNext()) {
            Definition id = (Definition)defItr.next();
            Iterator bindingItr = id.getBindings().values().iterator();
            while (bindingItr.hasNext()) {
                binding = (Binding)bindingItr.next();
                if (!binding.getPortType().getQName().equals(pt.getQName())) continue;
                List opers = binding.getBindingOperations();
                Iterator operIter = opers.iterator();
                while (operIter.hasNext()) {
                    BindingOutput bo;
                    BindingOperation bopr = (BindingOperation)operIter.next();
                    if (!ExtensibilityArtifacts.isOperationMatch(opr, bopr)) continue;
                    List exts = bopr.getExtensibilityElements();
                    Iterator extItr = exts.iterator();
                    while (extItr.hasNext()) {
                        Object ext = extItr.next();
                        if (!(ext instanceof BPEAction) || (bpeAction = (BPEAction)ext).getImplementation() != null) continue;
                        BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_IMPL_REQ", new Object[]{this.getProcess().getAttributes().getName()}, null);
                    }
                    BindingInput bi = bopr.getBindingInput();
                    if (bi != null) {
                        List biexts = bi.getExtensibilityElements();
                        Iterator biextsItr = biexts.iterator();
                        while (biextsItr.hasNext()) {
                            Object bpeInput = biextsItr.next();
                            if (!(bpeInput instanceof BPEInput) || !inputHM.containsKey(((BPEInput)bpeInput).getPart())) continue;
                            inputHM.put(((BPEInput)bpeInput).getPart(), bpeInput);
                        }
                    }
                    if ((bo = bopr.getBindingOutput()) == null) break block1;
                    List boexts = bo.getExtensibilityElements();
                    Iterator boextsItr = boexts.iterator();
                    while (boextsItr.hasNext()) {
                        Object bpeOutput = boextsItr.next();
                        if (!(bpeOutput instanceof BPEOutput) || !outputHM.containsKey(((BPEOutput)bpeOutput).getPart())) continue;
                        outputHM.put(((BPEOutput)bpeOutput).getPart(), bpeOutput);
                    }
                    break block1;
                }
            }
        }
        return bpeAction;
    }

    private Operation matchOperation(PortType pt, BPELVariable inputVar, BPELVariable outputVar, String invokeName, String operationName) throws DeploymentException {
        QName inputMsg = null;
        QName outputMsg = null;
        if (inputVar != null) {
            if (inputVar instanceof BPELWSDLVariable) {
                inputMsg = ((BPELWSDLVariable)inputVar).getMessageName();
            } else {
                BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_VAR_NOTWSDL", new Object[]{this.getProcess().getAttributes().getName(), invokeName, inputVar.getName()}, null);
            }
        }
        if (outputVar != null) {
            if (outputVar instanceof BPELWSDLVariable) {
                outputMsg = ((BPELWSDLVariable)outputVar).getMessageName();
            } else {
                BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_VAR_NOTWSDL", new Object[]{this.getProcess().getAttributes().getName(), invokeName, outputVar.getName()}, null);
            }
        }
        Operation retop = null;
        boolean inputMatch = false;
        boolean outputMatch = false;
        Iterator opItr = pt.getOperations().iterator();
        while (opItr.hasNext()) {
            Operation opr = (Operation)opItr.next();
            Input inp = opr.getInput();
            Output outp = opr.getOutput();
            if (opr.getName().equals(operationName)) {
                if (inp != null && inputMsg != null) {
                    if (inp.getMessage().getQName().equals(inputMsg)) {
                        inputMatch = true;
                    }
                } else if (inp == null && inputMsg == null) {
                    inputMatch = true;
                }
                if (outp != null && outputMsg != null) {
                    if (outp.getMessage().getQName().equals(outputMsg)) {
                        outputMatch = true;
                    }
                } else if (outp == null && outputMsg == null) {
                    outputMatch = true;
                }
            }
            if (!inputMatch || !outputMatch) continue;
            retop = opr;
            break;
        }
        return retop;
    }

    private static boolean isOperationMatch(Operation ptOper, BindingOperation bOper) {
        boolean input = false;
        boolean output = false;
        if (ptOper.getName().equals(bOper.getName())) {
            input = true;
            output = true;
            if (ptOper.getInput() != null && bOper.getBindingInput() != null && ptOper.getInput().getName() != null && bOper.getBindingInput().getName() != null) {
                input = ptOper.getInput().getName().equals(bOper.getBindingInput().getName());
            }
            if (ptOper.getOutput() != null && bOper.getBindingOutput() != null && ptOper.getOutput().getName() != null && bOper.getBindingOutput().getName() != null) {
                output = ptOper.getOutput().getName().equals(bOper.getBindingOutput().getName());
            }
        }
        return input && output;
    }

    private Definition getRootWSDL(String bpelName, HashMap artifacts) throws DeploymentException {
        Definition ret = null;
        InputSource is = null;
        byte[] data = (byte[])artifacts.get(bpelName + ".wsdl");
        if (data != null) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                is = new InputSource(bais);
                bais.close();
            }
            catch (IOException e1) {
                BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_IOERR", new Object[]{bpelName, bpelName + ".wsdl"}, e1);
            }
        }
        if (is == null) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "DEPLOY_WSDL_NOTFOUND", new Object[]{bpelName, bpelName + ".wsdl"}, null);
        }
        try {
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", true);
            reader.setFeature("javax.wsdl.importDocuments", true);
            reader.setExtensionRegistry(this.getExtentionRegistry());
            ret = reader.readWSDL((WSDLLocator)new BPELWSDLLocator(bpelName, is, artifacts));
        }
        catch (WSDLException e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_WSDLREADER", new Object[]{bpelName, bpelName + ".wsdl", e.getMessage()}, e);
        }
        return ret;
    }

    private TSchema getBPEBindings(String bpelName, HashMap artifacts) throws DeploymentException {
        TSchema ret = null;
        byte[] data = (byte[])artifacts.get(bpelName + ".xml");
        if (data != null) {
            ByteArrayInputStream bpeBinding = new ByteArrayInputStream(data);
            BPEBindingDocument bbd = null;
            try {
                bbd = BPEBindingDocument.Factory.parse(bpeBinding);
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ret = bbd.getBPEBinding();
        }
        return ret;
    }

    private ExtensionRegistry getExtentionRegistry() {
        PopulatedExtensionRegistry er = new PopulatedExtensionRegistry();
        BPELPropertySerializer bpelPropSerializer = new BPELPropertySerializer();
        BPELPropertyAliasSerializer bpelPropAliasSerializer = new BPELPropertyAliasSerializer();
        BPEActionSerializer bpeActionSerializer = new BPEActionSerializer();
        BPEInputSerializer bpeInputSerializer = new BPEInputSerializer();
        BPEOutputSerializer bpeOutputSerializer = new BPEOutputSerializer();
        BPEFaultSerializer bpeFaultSerializer = new BPEFaultSerializer();
        BPEVariableMapSerializer bpeVariableSerializer = new BPEVariableMapSerializer();
        er.registerSerializer(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = ExtensibilityArtifacts.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPEL_PROPERTY, (ExtensionSerializer)bpelPropSerializer);
        er.registerDeserializer(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = ExtensibilityArtifacts.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPEL_PROPERTY, (ExtensionDeserializer)bpelPropSerializer);
        er.mapExtensionTypes(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = ExtensibilityArtifacts.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPEL_PROPERTY, class$org$apache$ode$bpe$wsdl$extensions$BPELProperty == null ? (class$org$apache$ode$bpe$wsdl$extensions$BPELProperty = ExtensibilityArtifacts.class$("org.apache.ode.bpe.wsdl.extensions.BPELProperty")) : class$org$apache$ode$bpe$wsdl$extensions$BPELProperty);
        er.registerSerializer(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = ExtensibilityArtifacts.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPEL_PROPERTY_ALIAS, (ExtensionSerializer)bpelPropAliasSerializer);
        er.registerDeserializer(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = ExtensibilityArtifacts.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPEL_PROPERTY_ALIAS, (ExtensionDeserializer)bpelPropAliasSerializer);
        er.mapExtensionTypes(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = ExtensibilityArtifacts.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPEL_PROPERTY_ALIAS, class$org$apache$ode$bpe$wsdl$extensions$BPELPropertyAlias == null ? (class$org$apache$ode$bpe$wsdl$extensions$BPELPropertyAlias = ExtensibilityArtifacts.class$("org.apache.ode.bpe.wsdl.extensions.BPELPropertyAlias")) : class$org$apache$ode$bpe$wsdl$extensions$BPELPropertyAlias);
        er.registerSerializer(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = ExtensibilityArtifacts.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, ExtentionConstants.Q_ELEM_BPE_ACTION, (ExtensionSerializer)bpeActionSerializer);
        er.registerDeserializer(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = ExtensibilityArtifacts.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, ExtentionConstants.Q_ELEM_BPE_ACTION, (ExtensionDeserializer)bpeActionSerializer);
        er.mapExtensionTypes(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = ExtensibilityArtifacts.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, ExtentionConstants.Q_ELEM_BPE_ACTION, class$org$apache$ode$bpe$wsdl$extensions$BPEAction == null ? (class$org$apache$ode$bpe$wsdl$extensions$BPEAction = ExtensibilityArtifacts.class$("org.apache.ode.bpe.wsdl.extensions.BPEAction")) : class$org$apache$ode$bpe$wsdl$extensions$BPEAction);
        er.registerSerializer(class$javax$wsdl$BindingInput == null ? (class$javax$wsdl$BindingInput = ExtensibilityArtifacts.class$("javax.wsdl.BindingInput")) : class$javax$wsdl$BindingInput, ExtentionConstants.Q_ELEM_BPE_INPUT, (ExtensionSerializer)bpeInputSerializer);
        er.registerDeserializer(class$javax$wsdl$BindingInput == null ? (class$javax$wsdl$BindingInput = ExtensibilityArtifacts.class$("javax.wsdl.BindingInput")) : class$javax$wsdl$BindingInput, ExtentionConstants.Q_ELEM_BPE_INPUT, (ExtensionDeserializer)bpeInputSerializer);
        er.mapExtensionTypes(class$javax$wsdl$BindingInput == null ? (class$javax$wsdl$BindingInput = ExtensibilityArtifacts.class$("javax.wsdl.BindingInput")) : class$javax$wsdl$BindingInput, ExtentionConstants.Q_ELEM_BPE_INPUT, class$org$apache$ode$bpe$wsdl$extensions$BPEInput == null ? (class$org$apache$ode$bpe$wsdl$extensions$BPEInput = ExtensibilityArtifacts.class$("org.apache.ode.bpe.wsdl.extensions.BPEInput")) : class$org$apache$ode$bpe$wsdl$extensions$BPEInput);
        er.registerSerializer(class$javax$wsdl$BindingOutput == null ? (class$javax$wsdl$BindingOutput = ExtensibilityArtifacts.class$("javax.wsdl.BindingOutput")) : class$javax$wsdl$BindingOutput, ExtentionConstants.Q_ELEM_BPE_OUTPUT, (ExtensionSerializer)bpeOutputSerializer);
        er.registerDeserializer(class$javax$wsdl$BindingOutput == null ? (class$javax$wsdl$BindingOutput = ExtensibilityArtifacts.class$("javax.wsdl.BindingOutput")) : class$javax$wsdl$BindingOutput, ExtentionConstants.Q_ELEM_BPE_OUTPUT, (ExtensionDeserializer)bpeOutputSerializer);
        er.mapExtensionTypes(class$javax$wsdl$BindingOutput == null ? (class$javax$wsdl$BindingOutput = ExtensibilityArtifacts.class$("javax.wsdl.BindingOutput")) : class$javax$wsdl$BindingOutput, ExtentionConstants.Q_ELEM_BPE_OUTPUT, class$org$apache$ode$bpe$wsdl$extensions$BPEOutput == null ? (class$org$apache$ode$bpe$wsdl$extensions$BPEOutput = ExtensibilityArtifacts.class$("org.apache.ode.bpe.wsdl.extensions.BPEOutput")) : class$org$apache$ode$bpe$wsdl$extensions$BPEOutput);
        er.registerSerializer(class$javax$wsdl$BindingFault == null ? (class$javax$wsdl$BindingFault = ExtensibilityArtifacts.class$("javax.wsdl.BindingFault")) : class$javax$wsdl$BindingFault, ExtentionConstants.Q_ELEM_BPE_FAULT, (ExtensionSerializer)bpeFaultSerializer);
        er.registerDeserializer(class$javax$wsdl$BindingFault == null ? (class$javax$wsdl$BindingFault = ExtensibilityArtifacts.class$("javax.wsdl.BindingFault")) : class$javax$wsdl$BindingFault, ExtentionConstants.Q_ELEM_BPE_FAULT, (ExtensionDeserializer)bpeFaultSerializer);
        er.mapExtensionTypes(class$javax$wsdl$BindingFault == null ? (class$javax$wsdl$BindingFault = ExtensibilityArtifacts.class$("javax.wsdl.BindingFault")) : class$javax$wsdl$BindingFault, ExtentionConstants.Q_ELEM_BPE_FAULT, class$org$apache$ode$bpe$wsdl$extensions$BPEFault == null ? (class$org$apache$ode$bpe$wsdl$extensions$BPEFault = ExtensibilityArtifacts.class$("org.apache.ode.bpe.wsdl.extensions.BPEFault")) : class$org$apache$ode$bpe$wsdl$extensions$BPEFault);
        er.registerSerializer(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = ExtensibilityArtifacts.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPE_VAR, (ExtensionSerializer)bpeVariableSerializer);
        er.registerDeserializer(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = ExtensibilityArtifacts.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPE_VAR, (ExtensionDeserializer)bpeVariableSerializer);
        er.mapExtensionTypes(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = ExtensibilityArtifacts.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPE_VAR, class$org$apache$ode$bpe$wsdl$extensions$BPEVariableMap == null ? (class$org$apache$ode$bpe$wsdl$extensions$BPEVariableMap = ExtensibilityArtifacts.class$("org.apache.ode.bpe.wsdl.extensions.BPEVariableMap")) : class$org$apache$ode$bpe$wsdl$extensions$BPEVariableMap);
        return er;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

