/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.engine;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.ode.bpe.context.IContextService;
import org.apache.ode.bpe.context.base.ContextServiceException;
import org.apache.ode.bpe.context.base.ContextServiceFactory;
import org.apache.ode.bpe.context.base.ContextTypeEnum;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.engine.InactiveDefinitionException;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.engine.ProcessInstance;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.instance.service.InstanceService;
import org.apache.ode.bpe.instance.service.InstanceServiceException;
import org.apache.ode.bpe.instance.service.InstanceServiceFactory;
import org.apache.ode.bpe.scope.service.IScopeService;
import org.apache.ode.bpe.scope.service.ScopeServiceException;
import org.apache.ode.bpe.scope.service.ScopeServiceFactory;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;
import org.apache.ode.bpe.uuid.UUIDService;
import org.apache.ode.bpe.uuid.UUIDServiceException;

public class ProcessService {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$engine$ProcessService == null ? (class$org$apache$ode$bpe$engine$ProcessService = ProcessService.class$("org.apache.ode.bpe.engine.ProcessService")) : class$org$apache$ode$bpe$engine$ProcessService).getName());
    private InstanceService is;
    private IContextService ctxPersistent;
    private IContextService ctxNonPersistent;
    private HashMap scopeServices;
    private BPEProperties props;
    private UUIDService us;
    private boolean persistServicesAvailable;
    static /* synthetic */ Class class$org$apache$ode$bpe$engine$ProcessService;

    public ProcessService(BPEProperties props, UUIDService us) throws DefinitionServiceException, InstanceServiceException, UUIDServiceException {
        this.persistServicesAvailable = props.getInstanceServicePersistence();
        this.is = InstanceServiceFactory.createInstanceService(props, us, this);
        this.us = us;
        this.props = props;
        this.scopeServices = new HashMap();
    }

    public synchronized ProcessInstance createProcess(ProcessDefinitionKey key) throws BPException {
        IPMDRoot rootDefinition = this.is.getDefinitionService().getRootDefinition(key);
        if (!rootDefinition.isActive()) {
            throw new InactiveDefinitionException(rootDefinition.getLabel(), key.getValue());
        }
        return new ProcessInstance(this.is.createRootInstance(this.is.getDefinitionService().getRootDefinition(key)), this);
    }

    public synchronized ProcessInstance createSubProcess(IPMIProcess ipmi, IPMDProcess ipmd) throws BPException {
        return new ProcessInstance(ipmi.createSubProcess(ipmd), this);
    }

    public synchronized ProcessInstance lookupProcess(String rootkey, String key) throws BPException {
        return new ProcessInstance(this.is.getInstance(rootkey, key), this);
    }

    public synchronized InstanceService getInstanceService() {
        return this.is;
    }

    public synchronized IContextService getContextService(IPMIProcess rootkey) throws BPException {
        return this.getContextService(rootkey.isStateless());
    }

    public synchronized IContextService getContextService(String rootkey) throws BPException {
        IPMIProcess proc = this.is.getInstanceForContext(rootkey, rootkey);
        if (proc == null) {
            return this.getContextService(false);
        }
        IPMDRoot rootDef = this.is.getDefinitionService().getRootDefinition(proc.getDefinition().getRootKey());
        return this.getContextService(rootDef.getIsStateless());
    }

    private synchronized IContextService getContextService(boolean isStateless) throws BPException {
        IContextService ret = null;
        if (!this.persistServicesAvailable) {
            return this.getTransientContextService();
        }
        if (!isStateless) {
            if (this.ctxPersistent == null) {
                InitialContext ic;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Creating persistent context.");
                }
                try {
                    ic = new InitialContext();
                }
                catch (NamingException e) {
                    BPException bpx = new BPException("NATIVE_EXCEPTION", new Object[]{"NamingException"}, e);
                    bpx.log(logger, Level.SEVERE);
                    throw bpx;
                }
                BPEProperties props = new BPEProperties(true, ic);
                props.setProperty("CTX_CLASS_PERSISTENT_KEY", "org.apache.ode.bpe.context.persistent.PersistentContextService");
                props.setProperty("CTX_PERSISTENCE_KEY", "CTX_PERSISTENT");
                props.setProperty("DOF_CLASS_PERSISTENT_KEY", "org.apache.ode.bpe.context.ejb.EJBDataObjectFactory");
                props.setProperty("DOF_EJB_HOME_KEY", "java:comp/env/theCMPObjectBean");
                ret = this.ctxPersistent = ContextServiceFactory.createContextService(props, this.us, ContextTypeEnum.PERSISTENT);
            } else {
                ret = this.ctxPersistent;
            }
        } else {
            ret = this.getTransientContextService();
        }
        return ret;
    }

    public synchronized IScopeService getScopeService(IPMIProcess rootkey) throws ScopeServiceException, BPException {
        IScopeService ss = (IScopeService)this.scopeServices.get(rootkey.getRootKey());
        if (ss == null) {
            ss = ScopeServiceFactory.createScopeService(this.getContextService(rootkey), rootkey.getRootKey(), this.props);
            this.scopeServices.put(rootkey.getRootKey(), ss);
        }
        return ss;
    }

    public synchronized IScopeService getScopeService(String rootkey) throws ScopeServiceException, BPException {
        IScopeService ss = (IScopeService)this.scopeServices.get(rootkey);
        if (ss == null) {
            ss = ScopeServiceFactory.createScopeService(this.getContextService(rootkey), rootkey, this.props);
            this.scopeServices.put(rootkey, ss);
        }
        return ss;
    }

    public synchronized void update(String rootkey, IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        this.scopeServices.remove(rootkey);
        this.is.update(rootkey, ec, pcb);
    }

    public synchronized void init() {
        this.ctxPersistent = null;
        this.is.init();
    }

    public synchronized IContextService getTransientContextService() throws ContextServiceException {
        if (this.ctxNonPersistent == null) {
            BPEProperties props = new BPEProperties();
            this.ctxNonPersistent = ContextServiceFactory.createContextService(props, this.us, ContextTypeEnum.TRANSIENT);
        }
        return this.ctxNonPersistent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

