/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.engine;

import java.io.Serializable;

public class StateEnum
implements Serializable {
    static final long serialVersionUID = -4611739077212611477L;
    private String stringValue;
    private int intValue;
    private static final String STARTED_VALUE = "STARTED";
    private static final String UNSTARTED_VALUE = "UNSTARTED";
    private static final String PAUSED_VALUE = "PAUSED";
    private static final String FINISHED_VALUE = "FINISHED";
    private static final String TERMINATED_VALUE = "TERMINATED";
    private static final String RUNNING_VALUE = "RUNNING";
    private static final int STARTED_INT = 1;
    private static final int UNSTARTED_INT = 2;
    private static final int PAUSED_INT = 3;
    private static final int FINISHED_INT = 4;
    private static final int TERMINATED_INT = 5;
    private static final int RUNNING_INT = 6;
    public static final StateEnum STARTED = new StateEnum("STARTED", 1);
    public static final StateEnum UNSTARTED = new StateEnum("UNSTARTED", 2);
    public static final StateEnum PAUSED = new StateEnum("PAUSED", 3);
    public static final StateEnum FINISHED = new StateEnum("FINISHED", 4);
    public static final StateEnum TERMINATED = new StateEnum("TERMINATED", 5);
    public static final StateEnum RUNNING = new StateEnum("RUNNING", 6);

    private StateEnum() {
    }

    private StateEnum(String stateString, int stateInt) {
        this.stringValue = stateString;
        this.intValue = stateInt;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public int hashCode() {
        return this.intValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StateEnum) {
            return this.intValue == ((StateEnum)obj).intValue;
        }
        return false;
    }

    public static StateEnum getState(String state) {
        if (state.equals(STARTED_VALUE)) {
            return STARTED;
        }
        if (state.equals(UNSTARTED_VALUE)) {
            return UNSTARTED;
        }
        if (state.equals(PAUSED_VALUE)) {
            return PAUSED;
        }
        if (state.equals(FINISHED_VALUE)) {
            return FINISHED;
        }
        if (state.equals(TERMINATED_VALUE)) {
            return TERMINATED;
        }
        if (state.equals(RUNNING_VALUE)) {
            return RUNNING;
        }
        return null;
    }

    public static StateEnum getState(int state) {
        switch (state) {
            case 1: {
                return STARTED;
            }
            case 2: {
                return UNSTARTED;
            }
            case 3: {
                return PAUSED;
            }
            case 4: {
                return FINISHED;
            }
            case 5: {
                return TERMINATED;
            }
            case 6: {
                return RUNNING;
            }
        }
        return null;
    }
}

