/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.enginestate.service;

import java.util.HashMap;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.ode.bpe.engine.CleanUpEnum;
import org.apache.ode.bpe.engine.StateEnum;
import org.apache.ode.bpe.enginestate.service.EngineStateException;
import org.apache.ode.bpe.enginestate.service.IEngineState;
import org.apache.ode.bpe.enginestate.service.managed.EngineStateLocal;
import org.apache.ode.bpe.enginestate.service.managed.EngineStateLocalHome;
import org.apache.ode.bpe.enginestate.service.unmanaged.EngineStateImImpl;
import org.apache.ode.bpe.util.BPException;

public class EngineStateFactory {
    private static HashMap engineStates;
    public static String ENGINE_NAME;

    public static IEngineState getEngineState(String engienName) throws BPException {
        boolean remote = true;
        String val = System.getProperty("java.naming.factory.initial");
        if (val != null && val.compareTo("org.apache.ode.bpe.inmemory.jndi.IMContextFactory") == 0) {
            remote = false;
        }
        if (remote) {
            return EngineStateFactory.getEjbEngineState(ENGINE_NAME);
        }
        return EngineStateFactory.getInMemoryEngineState(engienName);
    }

    private static IEngineState getEjbEngineState(String engienName) throws BPException {
        try {
            InitialContext init = new InitialContext();
            EngineStateLocalHome eslh = (EngineStateLocalHome)init.lookup("java:comp/env/theEngineState");
            EngineStateLocal esl = null;
            try {
                esl = eslh.findByPrimaryKey(engienName);
            }
            catch (FinderException fe) {
                try {
                    esl = eslh.create(engienName, StateEnum.STARTED.getStringValue(), CleanUpEnum.CLEANUP.getStringValue());
                }
                catch (CreateException e) {
                    throw new EngineStateException("NATIVE_EXCEPTION", new Object[]{"CreateException"}, e);
                }
            }
            return esl;
        }
        catch (NamingException e) {
            throw new EngineStateException("NATIVE_EXCEPTION", new Object[]{"NamingException"}, e);
        }
    }

    private static IEngineState getInMemoryEngineState(String engienName) {
        EngineStateImImpl es;
        if (engineStates == null) {
            engineStates = new HashMap();
        }
        if ((es = (EngineStateImImpl)engineStates.get(engienName)) == null) {
            es = new EngineStateImImpl(engienName, StateEnum.STARTED.getStringValue(), CleanUpEnum.CLEANUP.getStringValue());
            engineStates.put(engienName, es);
        }
        return es;
    }

    static {
        ENGINE_NAME = "BPE_ENGINE";
    }
}

