/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.instance.service;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.definition.service.DefinitionServiceFactory;
import org.apache.ode.bpe.engine.ProcessService;
import org.apache.ode.bpe.instance.service.InstanceService;
import org.apache.ode.bpe.instance.service.InstanceServiceException;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;
import org.apache.ode.bpe.uuid.UUIDService;
import org.apache.ode.bpe.uuid.UUIDServiceException;

public class InstanceServiceFactory {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$instance$service$InstanceServiceFactory == null ? (class$org$apache$ode$bpe$instance$service$InstanceServiceFactory = InstanceServiceFactory.class$("org.apache.ode.bpe.instance.service.InstanceServiceFactory")) : class$org$apache$ode$bpe$instance$service$InstanceServiceFactory).getName());
    static /* synthetic */ Class class$org$apache$ode$bpe$instance$service$InstanceServiceFactory;

    public static InstanceService createInstanceService(BPEProperties props, UUIDService us, ProcessService ps) throws InstanceServiceException, DefinitionServiceException, UUIDServiceException {
        DefinitionService ds = DefinitionServiceFactory.createDefinitionService(props, us);
        return InstanceServiceFactory.createInstanceService(props, ds, us, ps);
    }

    private static InstanceService createInstanceService(BPEProperties props, DefinitionService ds, UUIDService us, ProcessService ps) throws InstanceServiceException, DefinitionServiceException, UUIDServiceException {
        InstanceService is = null;
        try {
            Class<?> instClass = Class.forName(props.getInstanceServiceClass());
            is = (InstanceService)instClass.newInstance();
            is.init(ds, us, ps);
        }
        catch (ClassNotFoundException e) {
            InstanceServiceException bpx = new InstanceServiceException("CLASS_NOT_FOUND", new Object[]{props.getEventDirectorClass()});
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (InstantiationException e) {
            InstanceServiceException bpx = new InstanceServiceException("NATIVE_EXCEPTION", new Object[]{"InstantiationException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (IllegalAccessException e) {
            InstanceServiceException bpx = new InstanceServiceException("NATIVE_EXCEPTION", new Object[]{"IllegalAccessException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (BPException e) {
            InstanceServiceException bpx = new InstanceServiceException("BP_EXCEPTION", new Object[0], e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        return is;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

