/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.instance.service.nonpersistent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.engine.ProcessService;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.instance.nonpersistent.PMIProcessTransientImpl;
import org.apache.ode.bpe.instance.service.InstanceService;
import org.apache.ode.bpe.instance.service.InstanceServiceException;
import org.apache.ode.bpe.util.BPException;
import org.apache.ode.bpe.uuid.UUIDService;

public class InstanceServiceTransientImpl
implements InstanceService {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$instance$service$nonpersistent$InstanceServiceTransientImpl == null ? (class$org$apache$ode$bpe$instance$service$nonpersistent$InstanceServiceTransientImpl = InstanceServiceTransientImpl.class$("org.apache.ode.bpe.instance.service.nonpersistent.InstanceServiceTransientImpl")) : class$org$apache$ode$bpe$instance$service$nonpersistent$InstanceServiceTransientImpl).getName());
    private DefinitionService definitionService;
    private HashMap rootInstances = new HashMap();
    static /* synthetic */ Class class$org$apache$ode$bpe$instance$service$nonpersistent$InstanceServiceTransientImpl;

    public Collection getRootInstances(String defkey) throws BPException {
        ArrayList<IPMIProcess> rootInstForDef = new ArrayList<IPMIProcess>();
        Iterator ri = this.rootInstances.keySet().iterator();
        while (ri.hasNext()) {
            IPMIProcess inst = this.getRootInstance((String)ri.next());
            if (!inst.getDefinition().getKey().equals(defkey)) continue;
            rootInstForDef.add(inst);
        }
        return rootInstForDef;
    }

    public IPMIProcess getRootInstance(String rootkey) throws BPException {
        IPMIProcess p = null;
        HashMap instances = (HashMap)this.rootInstances.get(rootkey);
        if (instances != null) {
            p = (IPMIProcess)instances.get(rootkey);
        }
        if (p == null) {
            InstanceServiceException ise = new InstanceServiceException("IS_IMPL_PNF", new Object[]{rootkey});
            ise.log(logger, Level.SEVERE);
            throw ise;
        }
        return p;
    }

    public IPMIProcess getInstance(String rootkey, String key) throws BPException {
        HashMap instances = (HashMap)this.rootInstances.get(rootkey);
        if (instances == null) {
            InstanceServiceException bp = new InstanceServiceException("IS_IMPL_PNF", new Object[]{key});
            bp.log(logger, Level.SEVERE);
            throw bp;
        }
        IPMIProcess p = (IPMIProcess)instances.get(key);
        if (p == null) {
            InstanceServiceException bp = new InstanceServiceException("IS_IMPL_PNF", new Object[]{key});
            bp.log(logger, Level.SEVERE);
            throw bp;
        }
        return p;
    }

    public IPMIProcess createRootInstance(IPMDRoot rootDefinition) throws BPException {
        PMIProcessTransientImpl inst = new PMIProcessTransientImpl(rootDefinition.getProcess().getKey().getValue(), this.definitionService, this);
        this.rootInstances.put(inst.getKey(), new HashMap());
        this.addInstance(inst.getKey(), inst);
        return inst;
    }

    public DefinitionService getDefinitionService() {
        return this.definitionService;
    }

    public void init(DefinitionService ds, UUIDService us, ProcessService ps) {
        this.definitionService = ds;
    }

    public void update(String rootkey, IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        if (this.getInstance(rootkey, rootkey).isMarkedForCleanUp()) {
            ec.getProcessService().getContextService(rootkey).getRoot().removeChild(rootkey);
            this.rootInstances.remove(rootkey);
        }
    }

    public void init() {
    }

    public void addInstance(String rootkey, IPMIProcess instance) throws InstanceServiceException {
        HashMap instances = (HashMap)this.rootInstances.get(rootkey);
        instances.put(instance.getKey(), instance);
    }

    public IPMIProcess getInstanceForContext(String rootkey, String key) throws BPException {
        return this.getInstance(rootkey, key);
    }

    public void pauseRootInstance(String rootkey) throws BPException {
        throw new UnsupportedOperationException();
    }

    public void resumeRootInstance(String rootkey) throws BPException {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

